/*
 * Decompiled with CFR 0.152.
 */
package pph1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import pph1.Model;
import pph1.MyLogFunc;

public class HMMAlgos
implements Serializable {
    private static Random rand = new Random();
    public double[][] mu;
    public double[][] sigma;
    public double[][] priors;
    public double[][] lengthProbas;
    public double[][] cumulLengthProbas;
    private int[][] durations;
    public Model lambda;
    private double[][] alpha;
    private double[][] beta;
    public double[][] gamma;
    private double obsSeqProba;
    private double[][][] ksi;
    private double[][] delta;
    private int[][] psi;
    public int[] qstar;
    private double[] scaleFactor;
    private transient int len_obseq = 0;
    public ArrayList obSeq;
    private transient String file_name = null;

    public HMMAlgos() {
    }

    public HMMAlgos(Model model, int lobseq) {
        this.lambda = model;
        this.len_obseq = lobseq;
        this.alpha = new double[this.len_obseq][this.getNumStates()];
        this.beta = new double[this.len_obseq][this.getNumStates()];
        this.gamma = new double[this.len_obseq][this.getNumStates()];
        this.ksi = new double[this.len_obseq - 1][this.getNumStates()][this.getNumStates()];
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        this.scaleFactor = new double[this.len_obseq];
        this.obSeq = new ArrayList();
    }

    public void computeGamma() {
        for (int t = 0; t < this.len_obseq; ++t) {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.getNumStates(); ++i) {
                this.gamma[t][i] = this.alpha[t][i] * this.beta[t][i];
                sum += this.gamma[t][i];
            }
            i = 0;
            while (i < this.getNumStates()) {
                double[] dArray = this.gamma[t];
                int n = i++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    public void computeLengthProbas(double[][] _lengthsprobas) {
        this.cumulLengthProbas = _lengthsprobas;
    }

    public void computeLogDelta(int t, int i) {
        MyLogFunc myLog = new MyLogFunc();
        if (t > 0) {
            double tmp = 0.0;
            double max = this.delta[t - 1][0] + myLog.apply(this.lambda.getA(0, i));
            int index = 0;
            for (int k = 0; k < this.getNumStates(); ++k) {
                tmp = this.delta[t - 1][k] + myLog.apply(this.lambda.getA(k, i));
                if (!(tmp > max)) continue;
                max = tmp;
                index = k;
            }
            int[] multiob = (int[])this.obSeq.get(t);
            double bmoy = 0.0;
            for (int k = 0; k < multiob.length; ++k) {
                bmoy += this.lambda.getB(i, multiob[k]);
            }
            double[] dArray = this.delta[t];
            int n = i;
            dArray[n] = dArray[n] + (max + myLog.apply(bmoy /= (double)multiob.length));
            this.psi[t][i] = index;
        } else {
            int[] multiob0 = (int[])this.obSeq.get(0);
            double bmoy = 0.0;
            for (int k = 0; k < multiob0.length; ++k) {
                bmoy += this.lambda.getB(i, multiob0[k]);
            }
            double[] dArray = this.delta[0];
            int n = i;
            dArray[n] = dArray[n] + (myLog.apply(this.lambda.getPi(i)) + myLog.apply(bmoy /= (double)multiob0.length));
            this.psi[0][i] = 0;
        }
    }

    public double viterbiAlgorithm() {
        for (int t = 0; t < this.obSeq.size(); ++t) {
            for (int s = 0; s < this.getNumStates(); ++s) {
                this.computeLogDelta(t, s);
            }
        }
        double temp = 0.0;
        double max = this.delta[this.len_obseq - 1][0];
        this.qstar[this.len_obseq - 1] = 0;
        for (int s = 1; s < this.getNumStates(); ++s) {
            temp = this.delta[this.len_obseq - 1][s];
            if (!(temp > max)) continue;
            max = temp;
            this.qstar[this.len_obseq - 1] = s;
        }
        for (int t = this.len_obseq - 2; t >= 0; --t) {
            this.qstar[t] = this.psi[t + 1][this.qstar[t + 1]];
        }
        return max;
    }

    public void forwardAlgo() {
        int j;
        Model model = this.lambda;
        double[][] a = model.getA();
        double[][] b = model.getB();
        double[] pi = model.getPi();
        for (j = 0; j < this.getNumStates(); ++j) {
            int[] multiob0 = (int[])this.obSeq.get(0);
            double bmoy = 0.0;
            for (int k = 0; k < multiob0.length; ++k) {
                bmoy += b[j][multiob0[k]];
            }
            double[] dArray = this.alpha[0];
            int n = j;
            dArray[n] = dArray[n] + pi[j] * (bmoy /= (double)multiob0.length);
        }
        for (int t = 1; t < this.obSeq.size(); ++t) {
            int j2 = 0;
            while (j2 < this.getNumStates()) {
                for (int s = 0; s < this.getNumStates(); ++s) {
                    double[] dArray = this.alpha[t];
                    int n = j2;
                    dArray[n] = dArray[n] + a[s][j2] * this.alpha[t - 1][s];
                }
                int[] multiob = (int[])this.obSeq.get(t);
                double bmoy = 0.0;
                for (int k = 0; k < multiob.length; ++k) {
                    bmoy += b[j2][multiob[k]];
                }
                double[] dArray = this.alpha[t];
                int n = j2++;
                dArray[n] = dArray[n] * (bmoy /= (double)multiob.length);
            }
        }
        for (j = 0; j < this.getNumStates(); ++j) {
            this.obsSeqProba += this.alpha[this.getLenObSeq() - 1][j];
        }
    }

    public void backwardAlgo() {
        Model model = this.lambda;
        double[][] a = model.getA();
        double[][] b = model.getB();
        double[] pi = model.getPi();
        for (int j = 0; j < this.getNumStates(); ++j) {
            this.beta[this.len_obseq - 1][j] = 1.0;
        }
        for (int t = this.obSeq.size() - 2; t >= 0; --t) {
            for (int i = 0; i < this.getNumStates(); ++i) {
                for (int j = 0; j < this.getNumStates(); ++j) {
                    double bmoy = 0.0;
                    int[] multiob = (int[])this.obSeq.get(t + 1);
                    for (int k = 0; k < multiob.length; ++k) {
                        bmoy += (double)multiob[k];
                    }
                    double[] dArray = this.beta[t];
                    int n = i;
                    dArray[n] = dArray[n] + a[i][j] * (bmoy /= (double)multiob.length) * this.beta[t + 1][j];
                }
            }
        }
    }

    private void computeKsi() {
        for (int t = 0; t < this.len_obseq - 1; ++t) {
            int j;
            int i;
            double sum = 0.0;
            for (i = 0; i < this.getNumStates(); ++i) {
                for (j = 0; j < this.getNumStates(); ++j) {
                    double bmoy = 0.0;
                    int[] multiob = (int[])this.obSeq.get(t + 1);
                    for (int k = 0; k < multiob.length; ++k) {
                        bmoy += this.lambda.getB(j, multiob[k]);
                    }
                    this.ksi[t][i][j] = this.alpha[t][i] * this.beta[t + 1][i] * this.lambda.getA(i, j) * (bmoy /= (double)multiob.length);
                    sum += this.ksi[t][i][j];
                }
            }
            for (i = 0; i < this.getNumStates(); ++i) {
                j = 0;
                while (j < this.getNumStates()) {
                    double[] dArray = this.ksi[t][i];
                    int n = j++;
                    dArray[n] = dArray[n] / sum;
                }
            }
        }
    }

    public double forwardBackwardAlgo() {
        this.forwardAlgo();
        this.backwardAlgo();
        this.computeGamma();
        return this.obsSeqProba;
    }

    public int getNumStates() {
        return this.lambda.getNumStates();
    }

    public int getNumSymbols() {
        return this.lambda.getNumSymbols();
    }

    public int getLenObSeq() {
        return this.len_obseq;
    }

    public double getObsSeqProba() {
        return this.obsSeqProba;
    }

    public void loadHmmAscii(String file, int lobseq) {
        this.lambda.loadModelAscii(file);
        this.len_obseq = lobseq;
        this.alpha = new double[this.len_obseq][this.getNumStates()];
        this.beta = new double[this.len_obseq][this.getNumStates()];
        this.gamma = new double[this.len_obseq][this.getNumStates()];
        this.ksi = new double[this.len_obseq - 1][this.getNumStates()][this.getNumStates()];
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        this.scaleFactor = new double[this.len_obseq];
        this.obSeq = new ArrayList();
    }

    public void loadHmmXml(String file, int lobseq) {
        this.lambda.loadModelXml(file);
        this.len_obseq = lobseq;
        this.alpha = new double[this.len_obseq][this.getNumStates()];
        this.beta = new double[this.len_obseq][this.getNumStates()];
        this.gamma = new double[this.len_obseq][this.getNumStates()];
        this.ksi = new double[this.len_obseq - 1][this.getNumStates()][this.getNumStates()];
        this.delta = new double[this.len_obseq][this.getNumStates()];
        this.psi = new int[this.len_obseq][this.getNumStates()];
        this.qstar = new int[this.len_obseq];
        this.scaleFactor = new double[this.len_obseq];
        this.obSeq = new ArrayList();
    }

    public void setObSeq(ArrayList seq) {
        this.obSeq = seq;
    }

    public int getObSeq(int t, int k) {
        int[] ali = (int[])this.obSeq.get(k);
        return ali[k];
    }

    public ArrayList getObSeq() {
        return this.obSeq;
    }

    public int[] generateSeq() {
        int[] seq = new int[this.len_obseq];
        block0: for (int t = 0; t < this.len_obseq; ++t) {
            double r = rand.nextDouble();
            double p = 0.0;
            for (int k = 0; k < this.getNumSymbols(); ++k) {
                double s = 0.0;
                for (int i = 0; i < this.getNumStates(); ++i) {
                    s += this.lambda.getB(i, k) * this.lambda.getPi(t, i);
                }
                if (!((p += s) > r)) continue;
                seq[t] = k;
                continue block0;
            }
        }
        return seq;
    }
}

