/*
 * Decompiled with CFR 0.152.
 */
package pph1;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXDocument;
import com.stevesoft.pat.Regex;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Model
implements Serializable {
    private static double MIN_PROB = 1.0E-5;
    public int num_states = 0;
    public String[] states;
    public String[] symbols;
    private int num_symbols = 0;
    static final String IBM_PARSER = "ibm";
    static final String SUN_PARSER = "sun";
    public String PARSER_NAME = "sun";
    public double[][] a;
    public double[][] b;
    private double[] pi;
    private double[][] lengthsProb;
    public String[] labels;

    public static double getMinProb() {
        return MIN_PROB;
    }

    public static double setMinProb(double p) {
        if (p >= 0.0 && p < 1.0) {
            MIN_PROB = p;
        }
        return MIN_PROB;
    }

    public int getNumStates() {
        return this.num_states;
    }

    public int getNumSymbols() {
        return this.num_symbols;
    }

    public void setA(int i, int j, double p) {
        this.a[i][j] = p > MIN_PROB ? p : MIN_PROB;
    }

    public void setA(double[][] p) {
        this.a = new double[this.num_states][this.num_states];
        for (int i = 0; i < this.num_states; ++i) {
            for (int j = 0; j < this.num_states; ++j) {
                this.a[i][j] = p[i][j] > MIN_PROB ? p[i][j] : MIN_PROB;
            }
        }
    }

    public void setB(int i, int k, double p) {
        this.b[i][k] = p > MIN_PROB ? p : MIN_PROB;
    }

    public void setB(int i, double[] p) {
        for (int k = 0; k < this.num_symbols; ++k) {
            this.b[i][k] = p[k] > MIN_PROB ? p[k] : MIN_PROB;
        }
    }

    public void setLenProbs(double[][] lp) {
        this.lengthsProb = lp;
    }

    public void setB(double[][] p) {
        for (int i = 0; i < this.num_states; ++i) {
            for (int k = 0; k < this.num_symbols; ++k) {
                this.b[i][k] = p[i][k] > MIN_PROB ? p[i][k] : MIN_PROB;
            }
        }
    }

    public void setPi(int j, double p) {
        this.pi[j] = p > MIN_PROB ? p : MIN_PROB;
    }

    public void setPi(double[] p) {
        for (int j = 0; j < this.num_states; ++j) {
            this.pi[j] = p[j] > MIN_PROB ? p[j] : MIN_PROB;
        }
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] lab) {
        this.labels = new String[this.num_states];
        this.labels = lab;
    }

    public double getA(int i, int j) {
        return this.a[i][j];
    }

    public double[] getA(int i) {
        return this.a[i];
    }

    public double[][] getA() {
        return this.a;
    }

    public double getB(int i, int k) {
        return this.b[i][k];
    }

    public double[][] getLengthProbs() {
        return this.lengthsProb;
    }

    public double[] getB(int i) {
        return this.b[i];
    }

    public double[][] getB() {
        return this.b;
    }

    public double getPi(int j) {
        return this.pi[j];
    }

    public double[] getPi() {
        return this.pi;
    }

    public double getPi(int t, int j) {
        if (t == 0) {
            return this.pi[j];
        }
        double sum = 0.0;
        for (int i = 0; i < this.num_states; ++i) {
            sum += this.getPi(t - 1, i) * this.a[i][j];
        }
        return sum;
    }

    public void loadModelAscii(String file) {
        try {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(file));
            Regex comments = new Regex("#");
            String line = in.readLine();
            int ind = 0;
            while (ind < 4) {
                comments.search(line);
                if (!comments.didMatch()) {
                    if (ind == 0) {
                        this.num_states = Integer.valueOf(line);
                    }
                    if (ind == 1) {
                        this.num_symbols = Integer.valueOf(line);
                    }
                    ++ind;
                }
                line = in.readLine();
            }
            this.a = new double[this.num_states][this.num_states];
            this.b = new double[this.num_states][this.num_symbols];
            this.pi = new double[this.num_states];
            StringTokenizer stkn = null;
            for (i = 0; i < this.num_states; ++i) {
                comments.search(line);
                if (!comments.didMatch()) {
                    stkn = new StringTokenizer(line);
                    int j = 0;
                    while (stkn.hasMoreTokens()) {
                        double val = Double.valueOf(stkn.nextToken());
                        this.a[i][j++] = val;
                    }
                }
                line = in.readLine();
            }
            for (i = 0; i < this.num_states; ++i) {
                comments.search(line);
                if (!comments.didMatch()) {
                    stkn = new StringTokenizer(line);
                    int k = 0;
                    while (stkn.hasMoreTokens()) {
                        this.b[i][k++] = Double.valueOf(stkn.nextToken());
                    }
                }
                line = in.readLine();
            }
            comments.search(line);
            if (!comments.didMatch()) {
                stkn = new StringTokenizer(line);
                int j = 0;
                while (stkn.hasMoreTokens()) {
                    this.pi[j++] = Double.valueOf(stkn.nextToken());
                }
            }
            in.close();
        }
        catch (FileNotFoundException exc) {
            System.out.println("File Not Found: ".concat(String.valueOf(String.valueOf(file))));
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void loadModelXml(String file) {
        int i;
        String value;
        String col;
        String row;
        int m;
        Object doc = null;
        if (this.PARSER_NAME.equals(IBM_PARSER)) {
            doc = new TXDocument();
        } else if (this.PARSER_NAME.equals(SUN_PARSER)) {
            doc = new XmlDocument();
        } else {
            System.err.println("Parser name not recognized!");
        }
        doc = this.openLocalDocument(file);
        NodeList nodeList = null;
        NodeList childList = null;
        Node childNode = null;
        Element nodeElement = null;
        Element childElement = null;
        String strElement = null;
        nodeList = doc.getElementsByTagName("states");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("count");
        this.num_states = Integer.valueOf(strElement);
        nodeList = doc.getElementsByTagName("symbols");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("count");
        this.num_symbols = Integer.valueOf(strElement);
        nodeList = doc.getElementsByTagName("bounds");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("ll_bound");
        nodeElement = (Element)nodeList.item(0);
        strElement = nodeElement.getAttribute("ur_bound");
        this.a = new double[this.num_states][this.num_states];
        this.b = new double[this.num_states][this.num_symbols];
        this.pi = new double[this.num_states];
        nodeList = doc.getElementsByTagName("transition_matrix");
        childList = nodeList.item(0).getChildNodes();
        for (m = 0; m < childList.getLength(); ++m) {
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            row = childElement.getAttribute("row");
            col = childElement.getAttribute("col");
            value = childElement.getAttribute("value");
            if (row == null || col == null) continue;
            i = Integer.valueOf(row);
            int j = Integer.valueOf(col);
            this.a[i][j] = Double.valueOf(value);
        }
        nodeList = doc.getElementsByTagName("symbol_generation_matrix");
        childList = nodeList.item(0).getChildNodes();
        for (m = 0; m < childList.getLength(); ++m) {
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            row = childElement.getAttribute("row");
            col = childElement.getAttribute("col");
            value = childElement.getAttribute("value");
            if (row == null || col == null) continue;
            i = Integer.valueOf(row);
            int k = Integer.valueOf(col);
            this.b[i][k] = Double.valueOf(value);
        }
        nodeList = doc.getElementsByTagName("initial_state_vector");
        childList = nodeList.item(0).getChildNodes();
        for (m = 0; m < childList.getLength(); ++m) {
            childNode = childList.item(m);
            if (childNode.getNodeType() != 1) continue;
            childElement = (Element)childNode;
            row = childElement.getAttribute("row");
            String value2 = childElement.getAttribute("value");
            if (row == null) continue;
            int j = Integer.valueOf(row);
            this.pi[j] = Double.valueOf(value2);
        }
    }

    public void saveModelAscii(String file) {
        try {
            int i;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            out.println(this.num_states);
            out.println(this.num_symbols);
            for (i = 0; i < this.num_states; ++i) {
                for (int j = 0; j < this.num_states; ++j) {
                    out.print(this.a[i][j]);
                    out.print("\t");
                }
                out.println();
            }
            for (i = 0; i < this.num_states; ++i) {
                for (int k = 0; k < this.num_symbols; ++k) {
                    out.print(this.b[i][k]);
                    out.print("\t");
                }
                out.println();
            }
            for (int j = 0; j < this.num_states; ++j) {
                out.print(this.pi[j]);
                out.print("\t");
            }
            out.println();
            out.close();
        }
        catch (FileNotFoundException exc) {
            System.out.println("File Not Found: ".concat(String.valueOf(String.valueOf(file))));
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void saveModelXml(String file) {
        this.normaliseProbas();
        try {
            int i;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            out.println("<?xml version=\"1.0\"?>");
            out.println("<!DOCTYPE hmm SYSTEM \"hmm03.dtd\">");
            out.println(" ");
            out.println("<hmm version=\"0.3\">");
            out.println("<name>");
            out.println("Hidden Markov Model Test");
            out.println("</name>");
            out.println("<Model>");
            out.print("<states count=\"");
            out.print(this.num_states);
            out.println("\">");
            out.println("</states>");
            out.print("<symbols count=\"");
            out.print(this.num_symbols);
            out.println("\">");
            out.println("</symbols>");
            out.print("<bounds ll_bound=\"");
            out.print("\" ur_bound=\"");
            out.println("\">");
            out.println("</bounds>");
            out.println("<transition_matrix>");
            for (i = 0; i < this.num_states; ++i) {
                for (int j = 0; j < this.num_states; ++j) {
                    out.print(String.valueOf(String.valueOf(new StringBuffer("<element row=\"").append(i).append("\" ").append("col=\"").append(j).append("\" ").append("value=\"").append(this.a[i][j]).append("\"/>"))));
                }
                out.println();
            }
            out.println("</transition_matrix>");
            out.println("<symbol_generation_matrix>");
            for (i = 0; i < this.num_states; ++i) {
                for (int k = 0; k < this.num_symbols; ++k) {
                    out.print(String.valueOf(String.valueOf(new StringBuffer("<element row=\"").append(i).append("\" ").append("col=\"").append(k).append("\" ").append("value=\"").append(this.b[i][k]).append("\"/>"))));
                }
                out.println();
            }
            out.println("</symbol_generation_matrix>");
            out.println("<initial_state_vector>");
            for (int j = 0; j < this.num_states; ++j) {
                out.print(String.valueOf(String.valueOf(new StringBuffer("<element row=\"").append(j).append("\" ").append("value=\"").append(this.pi[j]).append("\"/>"))));
            }
            out.println();
            out.println("</initial_state_vector>");
            out.println("</Model>");
            out.println("</hmm>");
            out.close();
        }
        catch (FileNotFoundException exc) {
            System.out.println("File Not Found: ".concat(String.valueOf(String.valueOf(file))));
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void removeState(String state) {
        boolean stillMore = true;
        int i = -1;
        while (stillMore) {
            int j;
            int k;
            for (int s = 0; s < this.num_states; ++s) {
                if (state.equals(this.labels[s])) {
                    i = s;
                    stillMore = true;
                    break;
                }
                stillMore = false;
            }
            if (!stillMore) continue;
            --this.num_states;
            double[][] initA = new double[this.num_states][this.num_states];
            double[][] initB = new double[this.getB().length][this.num_states];
            double[] initPi = new double[this.num_states];
            double[][] initProb = new double[this.num_states][this.lengthsProb[0].length];
            String[] initLabels = new String[this.num_states];
            if (i == 0) {
                for (k = 1; k < this.num_states + 1; ++k) {
                    for (j = 1; j < this.num_states + 1; ++j) {
                        initA[k - 1][j - 1] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k - 1][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k - 1][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k - 1] = this.getPi(k);
                    initLabels[k - 1] = this.getLabels()[k];
                }
            } else if (i == this.num_states) {
                for (k = 0; k < this.num_states; ++k) {
                    for (j = 0; j < this.num_states; ++j) {
                        initA[k][j] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k] = this.getPi(k);
                    initLabels[k] = this.getLabels()[k];
                }
            } else {
                for (k = 0; k < i; ++k) {
                    for (j = 0; j < i; ++j) {
                        initA[k][j] = this.getA(k, j);
                    }
                    for (j = i + 1; j < this.num_states + 1; ++j) {
                        initA[k][j - 1] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k] = this.getPi(k);
                    initLabels[k] = this.getLabels()[k];
                }
                for (k = i + 1; k < this.num_states + 1; ++k) {
                    for (j = 0; j < i - 1; ++j) {
                        initA[k - 1][j] = this.getA(k, j);
                    }
                    for (j = i + 1; j < this.num_states + 1; ++j) {
                        initA[k - 1][j - 1] = this.getA(k, j);
                    }
                    for (j = 0; j < this.num_symbols; ++j) {
                        initB[k - 1][j] = this.getB(k, j);
                    }
                    for (j = 0; j < this.lengthsProb[0].length; ++j) {
                        initProb[k - 1][j] = this.getLengthProbs()[k][j];
                    }
                    initPi[k - 1] = this.getPi(k);
                    initLabels[k - 1] = this.getLabels()[k];
                }
            }
            this.a = initA;
            this.b = initB;
            this.setPi(initPi);
            this.setLenProbs(initProb);
            this.setLabels(initLabels);
        }
    }

    private void normaliseProbas() {
        double[][] matA = this.getA();
        for (int i = 0; i < matA.length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < matA[i].length; ++j) {
                sum += matA[i][j];
            }
            j = 0;
            while (j < matA[i].length) {
                double[] dArray = matA[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        double[][] matB = this.getB();
        for (int i = 0; i < matB.length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < matB[i].length; ++j) {
                sum += matB[i][j];
            }
            j = 0;
            while (j < matB[i].length) {
                double[] dArray = matB[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    public Document openLocalDocument(String fileName) {
        XmlDocument doc = null;
        if (this.PARSER_NAME.equals(IBM_PARSER)) {
            if (fileName != null) {
                FileInputStream is;
                try {
                    is = new FileInputStream(fileName);
                }
                catch (FileNotFoundException notFound) {
                    System.err.println(notFound);
                    Document document = null;
                    return document;
                }
                Parser parser = new Parser(fileName);
                parser.setPreserveSpace(false);
                parser.setKeepComment(false);
                doc = parser.readStream((InputStream)is);
            }
        } else if (this.PARSER_NAME.equals(SUN_PARSER)) {
            if (fileName != null) {
                try {
                    String uri = "file:".concat(String.valueOf(String.valueOf(new File(fileName).getAbsolutePath())));
                    doc = XmlDocumentBuilder.createXmlDocument((String)uri);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("Parser name not recognized!");
        }
        return doc;
    }

    static {
        IBM_PARSER = IBM_PARSER;
        SUN_PARSER = SUN_PARSER;
    }
}

