/*
 * Decompiled with CFR 0.152.
 */
package pph1;

import cern.jet.stat.Probability;
import com.stevesoft.pat.Regex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.filechooser.FileSystemView;
import pph1.HMMAlgos;
import pph1.ListComparator;
import pph1.Model;

public class PphAlign {
    private boolean hasTransmem;
    private boolean hasSP;
    private boolean isNotLongEnough;
    private boolean hasPeptide;
    private boolean hasExtra;
    private int numberSequences;
    public String sequence;
    public String name;
    public ArrayList multiAli;
    public HMMAlgos hmmAlgo;
    private Model hmmModel;
    public Model model;
    public double score;
    public double score2;
    public double ratio;
    public int lengthHuman;
    public int[] bestPath;
    public double[] gammaScores;
    public String typeSeq;
    public double[][] lengthsProbas;
    public static PrintWriter out;
    public BufferedReader in;
    public static final String NTER = "n-ter";
    public static final String CTER = "c-ter";
    public static final String SIGCLEAV = "cleav";
    public static final String MATURE = "mature";
    public static final String HYDROPHOBIC = "hydro";
    public static final String EXTRACELLULAR = "extracellular";
    public static final String INTRACELLULAR = "intracellular";
    public static final String PEPTIDE = "peptide";
    public static final String TRANSMEMBRANE = "transmembrane";
    public static final String FURIN = "furin cleavage";
    public static final String PC1 = "PC1 cleavage";
    public static final String PC2 = "PC2 cleavage";
    public static final String GKR = "gkr cleavage";
    public static final String THROMBIN = "thrombin cleavage";
    public static final String ANCHOR = "signal-anchor (type 2 transmem)";
    private static final boolean DEBUG = false;
    public static ArrayList listScores;
    public int numSavedSeqs = 3000;
    public int numCheckedSeqs = 3000;
    public int[] indexesOfSavedSeqs;
    public String description;
    public static final String[] aminoAcids;
    public static String seqFolder;
    public static String mainDirectory;
    public static String outDirectory;
    public static final String[] totalLabels;
    public String[] labels;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("usage ali_files_directory main_directory out_directory");
        }
        PphAlign predHorm = new PphAlign();
        seqFolder = args[0];
        mainDirectory = args[1];
        outDirectory = args[2];
        predHorm.setProbabilities();
        predHorm.hmmAlgo = new HMMAlgos();
        predHorm.hmmModel = new Model();
        predHorm.hmmModel.loadModelXml(String.valueOf(String.valueOf(mainDirectory)).concat("/HMMGLOBALMODELFURIN4.xml"));
        predHorm.hmmModel.setLabels(predHorm.getTotalLabels());
        predHorm.hmmModel.setLenProbs(predHorm.getLengthsProbs());
        predHorm.hmmModel.removeState(ANCHOR);
        predHorm.hmmModel.removeState(THROMBIN);
        predHorm.setLabels(predHorm.hmmModel.labels);
        listScores = new ArrayList(predHorm.numSavedSeqs);
        Object br = null;
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File dir = new File(seqFolder);
        File[] files = fsv.getFiles(dir, false);
        predHorm.in = null;
        int numseq = 0;
        int l = 0;
        try {
            for (int i = 0; i < files.length; ++i) {
                predHorm.in = new BufferedReader(new FileReader(files[i].getPath()));
                predHorm.readMultiAli();
                boolean valid = true;
                if (predHorm.sequence.equals("") || predHorm.lengthHuman == 0) {
                    System.out.println("ERROR AT SEQUENCE ".concat(String.valueOf(String.valueOf(files[i].getPath()))));
                    valid = false;
                }
                if (valid) {
                    predHorm.hmmAlgo = new HMMAlgos(predHorm.hmmModel, predHorm.lengthHuman);
                    predHorm.computeHmmPredictions();
                    ArrayList<Number> list = new ArrayList<Number>(2);
                    list.add(new Integer(numseq));
                    list.add(new Double(predHorm.ratio));
                    listScores.add(list);
                }
                if (numseq == 200 * l) {
                    ++l;
                }
                ++numseq;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        predHorm.numberSequences = numseq;
        predHorm.retrieveBestSequencesIndexes();
        ArrayList<Integer> indexes = new ArrayList<Integer>(0);
        for (int i = 0; i < predHorm.indexesOfSavedSeqs.length; ++i) {
            indexes.add(new Integer(predHorm.indexesOfSavedSeqs[i]));
        }
        Collections.sort(indexes);
        predHorm.saveInitPrediction();
        int k = 0;
        l = 0;
        int nombre = 0;
        try {
            for (int i = 0; i < files.length; ++i) {
                if (k < predHorm.numSavedSeqs && (Integer)indexes.get(k) == i) {
                    predHorm.in = new BufferedReader(new FileReader(files[i].getPath()));
                    predHorm.readMultiAli();
                    predHorm.hmmAlgo = new HMMAlgos(predHorm.hmmModel, predHorm.lengthHuman);
                    predHorm.computeHmmPredictions();
                    predHorm.savePrediction();
                    ++k;
                }
                if (nombre == 1000 * l) {
                    ++l;
                }
                ++nombre;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            predHorm.saveEndPrediction();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private Model getModel() {
        return this.model;
    }

    private void setHmm(Model model) {
        this.hmmAlgo = new HMMAlgos();
        this.hmmAlgo.lambda = model;
    }

    private void setLabels(String[] labels) {
        this.labels = labels;
    }

    private void setLengthsProbas(double[][] lp) {
        this.lengthsProbas = lp;
    }

    private void setNumberSequences(int num) {
        this.numberSequences = num;
    }

    private void computeHmmPredictions() {
        this.hmmAlgo.setObSeq(this.multiAli);
        this.score = this.hmmAlgo.viterbiAlgorithm();
        this.score2 = this.hmmAlgo.forwardBackwardAlgo();
        this.ratio = this.score / (double)this.lengthHuman;
        this.bestPath = new int[this.lengthHuman];
        this.gammaScores = new double[this.lengthHuman];
        this.hasTransmem = false;
        this.hasSP = false;
        this.isNotLongEnough = false;
        this.typeSeq = "2";
        for (int k = 0; k < this.lengthHuman; ++k) {
            this.bestPath[k] = this.hmmAlgo.qstar[k];
            this.gammaScores[k] = this.hmmAlgo.gamma[k][this.bestPath[k]];
            if (this.labels[this.hmmAlgo.qstar[k]].equals(TRANSMEMBRANE) && k < this.lengthHuman - 6) {
                this.hasTransmem = true;
                this.score -= (double)200;
            }
            if (this.labels[this.hmmAlgo.qstar[k]].equals(SIGCLEAV)) {
                this.hasSP = true;
            }
            if (this.labels[this.hmmAlgo.qstar[k]].equals(EXTRACELLULAR)) {
                this.hasExtra = true;
            }
            if (this.labels[this.hmmAlgo.qstar[k]].equals(PEPTIDE)) {
                this.hasPeptide = true;
            }
            if (this.lengthHuman >= 50) continue;
            this.isNotLongEnough = true;
            this.score -= (double)50;
        }
        if (!this.hasSP) {
            this.score -= (double)100;
        }
        if (!this.hasPeptide) {
            this.score -= 0.3 * new Integer(this.lengthHuman).doubleValue();
        }
    }

    private double[][] getLengthsProbs() {
        return this.lengthsProbas;
    }

    private String[] getTotalLabels() {
        return totalLabels;
    }

    private HashMap createFeaturesFromPredictions() {
        int[] states = this.bestPath;
        int numExtra = 1;
        int numIntra = 1;
        int numPeptide = 1;
        int numTransmem = 1;
        int numFurin = 1;
        int numPC1 = 1;
        int numGKR = 1;
        int numTHR = 1;
        HashMap<String, int[]> feats = new HashMap<String, int[]>(4);
        int currentFeatSize = 1;
        for (int k = 1; k < this.sequence.length(); ++k) {
            int[] cleavBounds;
            String featName = "";
            if (states[k - 1] == states[k]) {
                ++currentFeatSize;
                continue;
            }
            if (currentFeatSize > 1) {
                featName = this.labels[states[k - 1]];
                if (featName.equals(EXTRACELLULAR)) {
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numExtra).toString())));
                    ++numExtra;
                }
                if (featName.equals(INTRACELLULAR)) {
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numIntra).toString())));
                    ++numIntra;
                }
                if (featName.equals(PEPTIDE)) {
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numPeptide).toString())));
                    ++numPeptide;
                }
                if (featName.equals(TRANSMEMBRANE)) {
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numTransmem).toString())));
                    ++numTransmem;
                }
                int[] bounds = new int[]{k - currentFeatSize + 1, k};
                feats.put(featName, bounds);
            }
            if (states[k] == 5) {
                cleavBounds = new int[]{k + 1, k + 3};
                feats.put(this.labels[5], cleavBounds);
            }
            if (states[k] == 12 || states[k] == 16 || states[k] == 20 || states[k] == 23) {
                if (this.labels[states[k]].equals(FURIN)) {
                    featName = this.labels[states[k]];
                    cleavBounds = new int[]{k + 1, k + 4};
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numFurin).toString())));
                    ++numFurin;
                    feats.put(featName, cleavBounds);
                }
                if (this.labels[states[k]].equals(PC1)) {
                    featName = this.labels[states[k]];
                    cleavBounds = new int[]{k + 1, k + 4};
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numPC1).toString())));
                    ++numPC1;
                    feats.put(featName, cleavBounds);
                }
                if (this.labels[states[k]].equals(THROMBIN)) {
                    featName = this.labels[states[k]];
                    cleavBounds = new int[]{k + 1, k + 4};
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numTHR).toString())));
                    ++numTHR;
                    feats.put(featName, cleavBounds);
                }
                if (this.labels[states[k]].equals(GKR)) {
                    featName = this.labels[states[k]];
                    cleavBounds = new int[]{k + 1, k + 3};
                    featName = String.valueOf(String.valueOf(featName)).concat(String.valueOf(String.valueOf(new Integer(numGKR).toString())));
                    ++numGKR;
                    feats.put(featName, cleavBounds);
                }
            }
            currentFeatSize = 1;
        }
        int[] finalBounds = new int[]{this.sequence.length() - currentFeatSize + 1, this.sequence.length() + 1};
        String finalName = this.labels[states[this.sequence.length() - 1]];
        feats.put(finalName, finalBounds);
        return feats;
    }

    private void saveInitPrediction() {
        out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(String.valueOf(outDirectory)).concat("\\pred.xml"))));
            out.println("<?xml version=\"1.0\"?>");
            out.println(String.valueOf(String.valueOf(new StringBuffer("<!DOCTYPE hmmpred SYSTEM \"").append(outDirectory).append("/hmmpred181104.dtd\">"))));
            out.println(" ");
            out.println("<hmmpred version=\"0.1\">");
            out.print("<types_of_seq>\n");
            out.print("<types_seq indgroup=\"1\" namegroup=\"hormone\" numberseq=\"".concat(String.valueOf(String.valueOf(this.numberSequences))));
            out.print(String.valueOf(String.valueOf(new StringBuffer("\"/><types_seq indgroup=\"2\" namegroup=\"nonhormone\" numberseq=\"").append(this.numberSequences).append("\"/>"))));
            out.println("\n</types_of_seq>");
            out.println("<type_of_hmm>");
            out.println("\"STANDARD\"");
            out.println("</type_of_hmm>");
            out.print(String.valueOf(String.valueOf(new StringBuffer("<states number_of_states=\"").append(this.labels.length).append("\">\n"))));
            for (int i = 0; i < this.labels.length; ++i) {
                out.print(String.valueOf(String.valueOf(new StringBuffer("<label statenum=\"").append(i).append("\" statename=\"").append(this.labels[i]).append("\"/>"))));
            }
            out.println("\n</states>");
            out.println("<sequences>");
        }
        catch (FileNotFoundException exc) {
            System.out.println("File Not Found: ".concat(String.valueOf(String.valueOf(outDirectory))));
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    private void saveEndPrediction() throws IOException {
        out.println("</sequences>");
        out.println("</hmmpred>");
        out.close();
    }

    private void savePrediction() {
        out.print(String.valueOf(String.valueOf(new StringBuffer("<sequence group=\"").append(this.typeSeq).append("\" name=\"").append(this.name).append("\" description=\"").append(this.description))));
        out.println(String.valueOf(String.valueOf(new StringBuffer("\" organism=\"human\" length=\"").append(this.lengthHuman).append("\" score=\"").append(this.score).append("\" signal=\"").append(this.hasSP).append("\" transmembrane=\"").append(this.hasTransmem).append("\" peptide=\"").append(this.hasPeptide).append("\" extracellular=\"").append(this.hasExtra).append("\">"))));
        out.println("<aa_sequence>");
        out.print(this.sequence);
        out.println("\n</aa_sequence>");
        out.println("<features>");
        HashMap feats = this.createFeaturesFromPredictions();
        Iterator it = feats.keySet().iterator();
        for (int j = 0; j < feats.size(); ++j) {
            String name = (String)it.next();
            int[] bounds = (int[])feats.get(name);
            out.print(String.valueOf(String.valueOf(new StringBuffer("<feature name=\"").append(name).append("\" min=\"").append(bounds[0]).append("\" max=\"").append(bounds[1]).append("\"/>"))));
        }
        out.println("\n</features>");
        out.println("</sequence>");
    }

    private void setProbabilities() {
        int k;
        int maxSize = 2500;
        double[][] lengthsProbs = new double[28][maxSize];
        for (k = 0; k < 28; ++k) {
            if (!(k == 1 | k == 3 | k == 5 | k == 6 | k == 7 | k == 12 | k == 13 | k == 14 | k == 15 | k == 16 | k == 17 | k == 18 | k == 19 | k == 20 | k == 21 | k == 22 | k == 23 | k == 24 | k == 25 | k == 26)) continue;
            lengthsProbs[k][0] = 1.0;
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[0][k] = 1.0 - Probability.normal((double)3.0, (double)12.0, (double)k);
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[2][k] = 1.0 - Probability.normal((double)14.0, (double)15.0, (double)k);
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[27][k] = 1.0 - Probability.normal((double)18.0, (double)10.0, (double)k);
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[4][k] = 1.0 - Probability.normal((double)2.0, (double)6.0, (double)k);
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[8][k] = 1.0 - Probability.normal((double)150.0, (double)100.0, (double)k);
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[9][k] = 1.0 - Probability.normal((double)150.0, (double)100.0, (double)k);
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[10][k] = 1.0 - Probability.normal((double)60.0, (double)20.0, (double)k);
        }
        for (k = 0; k < maxSize; ++k) {
            lengthsProbs[11][k] = 1.0 - Probability.normal((double)18.0, (double)20.0, (double)k);
        }
        this.setLengthsProbas(lengthsProbs);
    }

    private void retrieveBestSequencesIndexes() {
        ListComparator comp = new ListComparator(1);
        Collections.sort(listScores, comp);
        this.numSavedSeqs = this.numSavedSeqs > listScores.size() ? listScores.size() : this.numSavedSeqs;
        this.indexesOfSavedSeqs = new int[this.numSavedSeqs];
        for (int i = 0; i < this.numSavedSeqs; ++i) {
            this.indexesOfSavedSeqs[i] = (Integer)((ArrayList)listScores.get(i)).get(0);
        }
    }

    private void normaliseProbas() {
        double[][] matA = this.getModel().getA();
        for (int i = 0; i < matA.length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < matA[i].length; ++j) {
                sum += matA[i][j];
            }
            j = 0;
            while (j < matA[i].length) {
                double[] dArray = matA[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        double[][] matB = this.getModel().getB();
        for (int i = 0; i < matB.length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < matB[i].length; ++j) {
                sum += matB[i][j];
            }
            j = 0;
            while (j < matB[i].length) {
                double[] dArray = matB[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    public void readMultiAli() {
        Regex dog = new Regex("(ENSCAFP\\d+)\\s+([-\\w]+)");
        Regex mouse = new Regex("(ENSMUSP\\d+)\\s+([-\\w]+)");
        Regex rat = new Regex("(ENSRNOP\\d+)\\s+([-\\w]+)");
        Regex human = new Regex("([\\w\\d-]+\\d)_([\\'\\=\\\u00b0\\^\\<\\>\\\u00a7\"\\\\~\\,\\#\\.\\;\\:\\+\\-\\[\\]\\}\\{\\&\\%\\)\\(\\/\\{\\d\\w-]+)\\s+([-\\w]+)");
        String humanSeq = "";
        String mouseSeq = "";
        String ratSeq = "";
        String dogSeq = "";
        String name = "";
        String description = "";
        ArrayList<int[]> mulAliList = new ArrayList<int[]>();
        try {
            String line = this.in.readLine();
            while (line != null) {
                if (dog.search(line)) {
                    dogSeq = String.valueOf(String.valueOf(dogSeq)).concat(String.valueOf(String.valueOf(dog.stringMatched(2))));
                } else if (rat.search(line)) {
                    ratSeq = String.valueOf(String.valueOf(ratSeq)).concat(String.valueOf(String.valueOf(rat.stringMatched(2))));
                } else if (mouse.search(line)) {
                    mouseSeq = String.valueOf(String.valueOf(mouseSeq)).concat(String.valueOf(String.valueOf(mouse.stringMatched(2))));
                } else if (human.search(line)) {
                    this.description = human.stringMatched(2);
                    humanSeq = String.valueOf(String.valueOf(humanSeq)).concat(String.valueOf(String.valueOf(human.stringMatched(3))));
                    this.name = human.stringMatched(1);
                }
                line = this.in.readLine();
            }
            this.sequence = "";
            for (int i = 0; i < humanSeq.length(); ++i) {
                ArrayList<Integer> intermediateal = new ArrayList<Integer>(0);
                int humanaa = this.humanCheckLetter(humanSeq.substring(i, i + 1));
                if (humanaa == 21) continue;
                intermediateal.add(new Integer(humanaa));
                int mouseaa = 21;
                if (mouseSeq != "" && (mouseaa = this.checkLetter(mouseSeq.substring(i, i + 1))) != 21) {
                    intermediateal.add(new Integer(mouseaa));
                }
                int dogaa = 21;
                if (dogSeq != "" && (dogaa = this.checkLetter(dogSeq.substring(i, i + 1))) != 21) {
                    intermediateal.add(new Integer(dogaa));
                }
                int rataa = 21;
                if (ratSeq != "") {
                    dogaa = this.checkLetter(ratSeq.substring(i, i + 1));
                    if (rataa != 21) {
                        intermediateal.add(new Integer(rataa));
                    }
                }
                int[] values = new int[intermediateal.size()];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = (Integer)intermediateal.get(j);
                }
                mulAliList.add(values);
            }
            this.lengthHuman = this.sequence.length();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.multiAli = mulAliList;
    }

    public int checkLetter(String letter) {
        int result = 21;
        for (int i = 0; i < 20; ++i) {
            if (!aminoAcids[i].equals(letter)) continue;
            result = i;
        }
        return result;
    }

    public int humanCheckLetter(String letter) {
        int result = 21;
        for (int i = 0; i < 20; ++i) {
            if (!aminoAcids[i].equals(letter)) continue;
            this.sequence = String.valueOf(String.valueOf(this.sequence)).concat(String.valueOf(String.valueOf(aminoAcids[i])));
            result = i;
        }
        return result;
    }

    static {
        NTER = NTER;
        CTER = CTER;
        SIGCLEAV = SIGCLEAV;
        MATURE = MATURE;
        HYDROPHOBIC = HYDROPHOBIC;
        EXTRACELLULAR = EXTRACELLULAR;
        INTRACELLULAR = INTRACELLULAR;
        PEPTIDE = PEPTIDE;
        TRANSMEMBRANE = TRANSMEMBRANE;
        FURIN = FURIN;
        PC1 = PC1;
        PC2 = PC2;
        GKR = GKR;
        THROMBIN = THROMBIN;
        ANCHOR = ANCHOR;
        DEBUG = false;
        aminoAcids = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V"};
        seqFolder = "adsd";
        mainDirectory = "dss";
        outDirectory = "dss";
        totalLabels = new String[]{NTER, NTER, HYDROPHOBIC, CTER, CTER, SIGCLEAV, SIGCLEAV, SIGCLEAV, EXTRACELLULAR, INTRACELLULAR, PEPTIDE, TRANSMEMBRANE, FURIN, FURIN, FURIN, FURIN, PC1, PC1, PC1, PC1, GKR, GKR, GKR, THROMBIN, THROMBIN, THROMBIN, THROMBIN, ANCHOR};
    }
}

