/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.ExternalID;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Source;
import com.ibm.xml.parser.TXDOMException;
import com.ibm.xml.parser.Token;
import com.ibm.xml.parser.Visitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntityDecl
extends Parent {
    String name;
    boolean isParameter = false;
    String value;
    ExternalID externalID;
    String ndata;
    byte[] rawByteStream;
    String encoding;
    char[] rawCharStream;
    boolean parsed = false;

    public EntityDecl(String string, String string2, boolean bl) {
        this.name = string;
        this.value = string2;
        this.isParameter = bl;
    }

    public EntityDecl(String string, ExternalID externalID, boolean bl, String string2) {
        this.name = string;
        this.externalID = externalID;
        this.isParameter = bl;
        this.ndata = string2;
    }

    public synchronized Object clone() {
        return this.cloneNode(true);
    }

    public synchronized Node cloneNode(boolean bl) {
        this.checkFactory();
        EntityDecl entityDecl = this.factory.createEntityDecl(this.name, this.value, this.isParameter);
        entityDecl.setFactory(this.getFactory());
        entityDecl.externalID = this.externalID;
        entityDecl.ndata = this.ndata;
        entityDecl.rawByteStream = this.rawByteStream;
        entityDecl.rawCharStream = this.rawCharStream;
        entityDecl.encoding = this.encoding;
        if (bl) {
            entityDecl.children.ensureCapacity(this.children.getLength());
            int n = 0;
            while (n < this.children.getLength()) {
                entityDecl.appendChild(this.children.item(n).cloneNode(true));
                ++n;
            }
            entityDecl.parsed = this.parsed;
        }
        return entityDecl;
    }

    public boolean equals(Node node, boolean bl) {
        if (node == null) {
            return false;
        }
        if (!(node instanceof EntityDecl)) {
            return false;
        }
        return false;
    }

    public short getNodeType() {
        return 6;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public String getValue() {
        return this.value;
    }

    public String getSystemId() {
        return this.externalID.getSystemLiteral();
    }

    public String getPublicId() {
        return this.externalID.getPubidLiteral();
    }

    public ExternalID getExternalID() {
        return this.externalID;
    }

    public boolean isExternal() {
        return this.externalID != null;
    }

    public String getNDATAType() {
        return this.ndata;
    }

    public String getNotationName() {
        return this.ndata;
    }

    public boolean isNDATA() {
        return this.ndata != null;
    }

    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitEntityDeclPre(this);
    }

    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitEntityDeclPost(this);
    }

    void load(Parser parser) throws IOException {
        if (this.getExternalID() != null && (this.rawByteStream == null || this.rawCharStream == null)) {
            try {
                int n;
                Source source = parser.streamProducer.getInputStream(this.name, this.externalID.getPubidLiteral(), this.externalID.getSystemLiteral());
                if (source.getInputStream() != null) {
                    int n2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    InputStream inputStream = source.getInputStream();
                    while ((n2 = inputStream.read()) >= 0) {
                        byteArrayOutputStream.write(n2);
                    }
                    inputStream.close();
                    ((OutputStream)byteArrayOutputStream).close();
                    this.rawByteStream = byteArrayOutputStream.toByteArray();
                    this.encoding = source.getEncoding();
                    return;
                }
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                Reader reader = source.getReader();
                while ((n = reader.read()) >= 0) {
                    charArrayWriter.write(n);
                }
                reader.close();
                charArrayWriter.close();
                this.rawCharStream = charArrayWriter.toCharArray();
                return;
            }
            catch (IOException iOException) {
                this.rawByteStream = new byte[0];
                this.rawCharStream = new char[0];
                throw iOException;
            }
        }
    }

    Source getInputStream() {
        if (this.rawByteStream != null) {
            return new Source(new ByteArrayInputStream(this.rawByteStream), this.encoding);
        }
        return new Source(new CharArrayReader(this.rawCharStream));
    }

    void setValue(String string) {
        this.value = string;
    }

    void setParsed(boolean bl) {
        this.parsed = bl;
    }

    boolean getParsed() {
        return this.parsed;
    }

    Token createToken(Parser parser, Token token) throws IOException {
        Token token2;
        if (this.getExternalID() != null) {
            try {
                this.load(parser);
            }
            catch (FileNotFoundException fileNotFoundException) {
                parser.format1(token, "E_IO0", this.getExternalID().getSystemLiteral());
            }
            token2 = new Token(parser, this.getExternalID().getSystemLiteral(), this.getInputStream());
        } else {
            token2 = new Token(parser, this.getValue());
            token2.getReading().setNext(token.getReading());
            token2.m_follow = false;
        }
        return token2;
    }

    protected void checkChildType(Node node) throws DOMException {
        switch (node.getNodeType()) {
            default: {
                throw new TXDOMException(3, "Specified node type (" + node.getNodeType() + ") can't be a child of EntityReference.");
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 23: 
        }
    }

    protected Entity getEntityImpl() {
        if (this.isParameter()) {
            throw new RuntimeException("XML4J internal error: EntityImpl for parameter entity.");
        }
        return new EntityImpl(this);
    }

    static class EntityImpl
    implements Entity {
        EntityDecl decl;

        EntityImpl(EntityDecl entityDecl) {
            this.decl = entityDecl;
        }

        public Node getParentNode() {
            return null;
        }

        public String getPublicId() {
            return this.decl.getPublicId();
        }

        public String getSystemId() {
            return this.decl.getSystemId();
        }

        public String getNotationName() {
            return this.decl.getNotationName();
        }

        public String getNodeName() {
            return this.decl.getNodeName();
        }

        public String getNodeValue() {
            return null;
        }

        public void setNodeValue(String string) {
            throw new TXDOMException(7, "This Entity is read-only.");
        }

        public short getNodeType() {
            return 6;
        }

        public NodeList getChildNodes() {
            return this.decl.getChildNodes();
        }

        public Node getFirstChild() {
            return this.decl.getFirstChild();
        }

        public Node getLastChild() {
            return this.decl.getLastChild();
        }

        public Node getPreviousSibling() {
            return this.decl.getPreviousSibling();
        }

        public Node getNextSibling() {
            return this.decl.getNextSibling();
        }

        public NamedNodeMap getAttributes() {
            return null;
        }

        public Document getOwnerDocument() {
            return this.decl.getOwnerDocument();
        }

        public Node insertBefore(Node node, Node node2) {
            throw new TXDOMException(7, "This Entity is read-only.");
        }

        public Node replaceChild(Node node, Node node2) {
            throw new TXDOMException(7, "This Entity is read-only.");
        }

        public Node removeChild(Node node) {
            throw new TXDOMException(7, "This Entity is read-only.");
        }

        public Node appendChild(Node node) {
            throw new TXDOMException(7, "This Entity is read-only.");
        }

        public boolean hasChildNodes() {
            return this.decl.hasChildNodes();
        }

        public Node cloneNode(boolean bl) {
            return ((EntityDecl)this.decl.cloneNode(bl)).getEntityImpl();
        }
    }
}

