/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.EntityDecl;
import com.ibm.xml.parser.ErrorListener;
import com.ibm.xml.parser.ExternalID;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Source;
import com.ibm.xml.parser.StreamProducer;
import com.ibm.xml.parser.StylesheetPI;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.TagHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Stack;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class SAXDriver
implements org.xml.sax.Parser,
AttributeList,
ErrorListener,
TagHandler,
StreamProducer {
    static HandlerBase s_defaulthandler = new HandlerBase();
    Parser parser;
    Locale locale;
    EntityResolver entityHandler = s_defaulthandler;
    DTDHandler dtdHandler = s_defaulthandler;
    DocumentHandler documentHandler = s_defaulthandler;
    ErrorHandler errorHandler = s_defaulthandler;
    TXAttribute[] attributes;
    DTD dtd;
    String currentSystemID;
    Stack stack;
    int depth;
    RuntimeException userException;
    boolean pause = false;

    public void setLocale(Locale locale) throws SAXException {
        this.locale = locale;
        if (this.parser != null) {
            this.parser.setLocale(locale);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityHandler = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.depth = 0;
        this.pause = false;
        this.stack = new Stack();
        this.currentSystemID = inputSource.getSystemId();
        this.documentHandler.startDocument();
        try {
            try {
                this.parser = new Parser(this.currentSystemID, this, this);
                this.parser.setSAXDriver(this);
                if (this.locale != null) {
                    this.parser.setLocale(this.locale);
                }
                this.parser.setElementFactory(new SAXDocument());
                this.parser.setTagHandler(this);
                this.stack.push(this.currentSystemID);
                if (inputSource.getByteStream() != null) {
                    this.parser.readStream(inputSource.getByteStream());
                } else if (inputSource.getCharacterStream() != null) {
                    this.parser.readStream(inputSource.getCharacterStream());
                } else {
                    this.parser.readStream(this.getInputStream(this.currentSystemID, null, this.currentSystemID));
                }
                if (this.userException == null) {
                    this.documentHandler.endDocument();
                }
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (ExceptionWrapper exceptionWrapper) {
                throw exceptionWrapper.wrapped;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
            Object var3_5 = null;
            this.parser = null;
            this.attributes = null;
            this.dtd = null;
            this.currentSystemID = null;
            this.stack = null;
            this.userException = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.parser = null;
            this.attributes = null;
            this.dtd = null;
            this.currentSystemID = null;
            this.stack = null;
            this.userException = null;
            throw throwable;
        }
    }

    public void parse(String string) throws SAXException {
        this.parse(new InputSource(string));
    }

    public int getLength() {
        return this.attributes.length;
    }

    public String getName(int n) {
        return this.attributes[n].getName();
    }

    public String getType(int n) {
        int n2 = this.attributes[n].getType();
        if (n2 == 0) {
            n2 = 1;
        }
        return AttDef.S_TYPESTR[n2];
    }

    public String getType(String string) {
        int n = this.searchAttribute(string);
        if (n < 0) {
            return null;
        }
        return this.getType(n);
    }

    public String getValue(int n) {
        return this.attributes[n].getValue();
    }

    public String getValue(String string) {
        int n = this.searchAttribute(string);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    public Source getInputStream(String string, String string2, String string3) throws IOException, RuntimeException {
        Source source = null;
        String string4 = this.currentSystemID;
        if (string3 != null) {
            try {
                this.stack.push(string4);
                this.currentSystemID = string3;
                InputSource inputSource = this.entityHandler.resolveEntity(string2, string3);
                if (inputSource != null) {
                    if (inputSource.getSystemId() != null) {
                        this.currentSystemID = string3 = inputSource.getSystemId();
                    }
                    if (inputSource.getByteStream() != null) {
                        source = new Source(inputSource.getByteStream());
                    } else if (inputSource.getCharacterStream() != null) {
                        source = new Source(inputSource.getCharacterStream());
                    }
                }
                if (source == null) {
                    URL uRL = new URL(new URL(string4), string3);
                    this.currentSystemID = uRL.toString();
                    source = new Source(uRL.openStream());
                }
            }
            catch (MalformedURLException malformedURLException) {
                source = new Source(new FileInputStream(string3));
            }
            catch (SAXException sAXException) {
                throw new ExceptionWrapper(sAXException);
            }
        }
        return source;
    }

    public void closeInputStream(Source source) {
        try {
            this.currentSystemID = (String)this.stack.pop();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void loadCatalog(Reader reader) throws IOException {
    }

    public int error(String string, int n, int n2, Object object, String string2) throws RuntimeException {
        if (this.userException != null) {
            throw this.userException;
        }
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setSystemId(string);
        locatorImpl.setLineNumber(n);
        locatorImpl.setColumnNumber(n2);
        SAXParseException sAXParseException = new SAXParseException(string2, locatorImpl);
        boolean bl = object instanceof String && ((String)object).startsWith("W_");
        boolean bl2 = object instanceof String && ((String)object).startsWith("V_");
        try {
            if (bl) {
                this.errorHandler.warning(sAXParseException);
            } else if (bl2) {
                this.errorHandler.error(sAXParseException);
            } else {
                this.errorHandler.fatalError(sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            this.userException = new ExceptionWrapper(sAXException);
            throw this.userException;
        }
        return 0;
    }

    public void handleStartTag(TXElement tXElement, boolean bl) throws RuntimeException {
        ++this.depth;
        if (!this.pause) {
            this.attributes = tXElement.getAttributeArray();
            try {
                this.documentHandler.startElement(tXElement.getNodeName(), this);
            }
            catch (SAXException sAXException) {
                throw new ExceptionWrapper(sAXException);
            }
            this.attributes = null;
        }
    }

    public void handleEndTag(TXElement tXElement, boolean bl) throws RuntimeException {
        --this.depth;
        if (!this.pause) {
            try {
                this.documentHandler.endElement(tXElement.getNodeName());
                return;
            }
            catch (SAXException sAXException) {
                throw new ExceptionWrapper(sAXException);
            }
        }
    }

    private int searchAttribute(String string) {
        int n = 0;
        while (n < this.attributes.length) {
            if (string.equals(this.attributes[n].getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void pauseEvent(boolean bl) {
        this.pause = bl;
    }

    class ExceptionWrapper
    extends RuntimeException {
        SAXException wrapped;

        ExceptionWrapper(SAXException sAXException) {
            super(sAXException.getMessage());
            SAXDriver.this = SAXDriver.this;
            this.wrapped = sAXException;
        }

        public String getMessage() {
            return this.wrapped.getMessage();
        }
    }

    class SAXDocument
    extends TXDocument {
        public DTD createDTD(String string, ExternalID externalID) {
            SAXDriver.this.dtd = super.createDTD(string, externalID);
            return SAXDriver.this.dtd;
        }

        public EntityDecl createEntityDecl(String string, ExternalID externalID, boolean bl, String string2) throws RuntimeException {
            if (string2 != null) {
                try {
                    SAXDriver.this.dtdHandler.unparsedEntityDecl(string, externalID.getPubidLiteral(), externalID.getSystemLiteral(), string2);
                }
                catch (SAXException sAXException) {
                    throw new ExceptionWrapper(sAXException);
                }
            }
            return super.createEntityDecl(string, externalID, bl, string2);
        }

        public TXNotation createNotation(String string, ExternalID externalID) throws RuntimeException {
            try {
                SAXDriver.this.dtdHandler.notationDecl(string, externalID.getPubidLiteral(), externalID.getSystemLiteral());
            }
            catch (SAXException sAXException) {
                throw new ExceptionWrapper(sAXException);
            }
            return super.createNotation(string, externalID);
        }

        public TXText createTextNode(char[] cArray, int n, int n2, boolean bl) throws RuntimeException {
            if (SAXDriver.this.depth > 0 && !SAXDriver.this.pause) {
                try {
                    if (bl) {
                        SAXDriver.this.documentHandler.ignorableWhitespace(cArray, n, n2);
                    } else {
                        SAXDriver.this.documentHandler.characters(cArray, n, n2);
                    }
                }
                catch (SAXException sAXException) {
                    throw new ExceptionWrapper(sAXException);
                }
            }
            return null;
        }

        public CDATASection createCDATASection(String string) throws RuntimeException {
            if (!SAXDriver.this.pause) {
                try {
                    char[] cArray = string.toCharArray();
                    SAXDriver.this.documentHandler.characters(cArray, 0, cArray.length);
                }
                catch (SAXException sAXException) {
                    throw new ExceptionWrapper(sAXException);
                }
            }
            return null;
        }

        public Comment createComment(String string) {
            return null;
        }

        public ProcessingInstruction createProcessingInstruction(String string, String string2) throws RuntimeException {
            if (!SAXDriver.this.pause) {
                try {
                    SAXDriver.this.documentHandler.processingInstruction(string, string2);
                }
                catch (SAXException sAXException) {
                    throw new ExceptionWrapper(sAXException);
                }
            }
            return null;
        }

        public StylesheetPI createStylesheetPI(String string, String string2, String string3, String string4, String string5) throws RuntimeException {
            if (!SAXDriver.this.pause) {
                try {
                    SAXDriver.this.documentHandler.processingInstruction(string, string2);
                }
                catch (SAXException sAXException) {
                    throw new ExceptionWrapper(sAXException);
                }
            }
            return null;
        }

        SAXDocument() {
            SAXDriver.this = SAXDriver.this;
        }
    }
}

