/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.Timer;
import cern.colt.map.AbstractIntIntMap;
import cern.colt.map.OpenIntIntHashMap;
import cern.colt.map.PrimeFinder;
import cern.colt.map.QuickOpenIntIntHashMap;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;

public class Benchmark {
    protected Benchmark() {
    }

    public static void benchmark(int n, int n2, String string) {
        System.out.println("initializing...");
        QuickOpenIntIntHashMap quickOpenIntIntHashMap = new QuickOpenIntIntHashMap();
        int n3 = 0;
        while (n3 < n2) {
            quickOpenIntIntHashMap.put(n3, n3);
            ++n3;
        }
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Now benchmarking...");
        int n4 = 0;
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        int n5 = n;
        while (--n5 >= 0) {
            int n6;
            if (string.equals("add")) {
                quickOpenIntIntHashMap.clear();
                timer.start();
                n6 = n2;
                while (--n6 >= 0) {
                    quickOpenIntIntHashMap.put(n6, n6);
                }
                timer.stop();
            }
            if (string.equals("get")) {
                timer.start();
                n6 = n2;
                while (--n6 >= 0) {
                    n4 += quickOpenIntIntHashMap.get(n6);
                }
                timer.stop();
                continue;
            }
            timer2.start();
            quickOpenIntIntHashMap.rehash(PrimeFinder.nextPrime(n2 * 2));
            timer2.stop();
            timer3.start();
            quickOpenIntIntHashMap.rehash(PrimeFinder.nextPrime((int)((double)n2 * 1.5)));
            timer3.stop();
        }
        System.out.println("adding: " + timer);
        System.out.println("growing: " + timer2);
        System.out.println("shrinking: " + timer3);
        System.out.println("total: " + timer2.plus(timer3));
        System.out.print(n4);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        String string = stringArray[2];
        Benchmark.benchmark(n, n2, string);
    }

    public static void test2(int n) {
        Uniform uniform = new Uniform(new MersenneTwister());
        int[] nArray = new int[n];
        int n2 = 10000000;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = uniform.nextIntFromTo(0, n2);
            ++n3;
        }
        int[] nArray2 = (int[])nArray.clone();
        int n4 = nArray.length;
        OpenIntIntHashMap openIntIntHashMap = new OpenIntIntHashMap();
        int n5 = 0;
        while (n5 < nArray.length) {
            ((AbstractIntIntMap)openIntIntHashMap).put(nArray[n5], nArray2[n5]);
            ++n5;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < nArray.length) {
            n6 += ((AbstractIntIntMap)openIntIntHashMap).get(nArray[n7]);
            ++n7;
        }
        System.out.println(openIntIntHashMap);
        System.out.println(n6);
        System.out.println("\n\n");
    }
}

