/*
 * Decompiled with CFR 0.152.
 */
package jal.LONG;

import jal.LONG.BinaryOperator;

public final class Numeric {
    public static long accumulate(long[] lArray, int n, int n2, long l) {
        long l2 = l;
        while (n < n2) {
            l2 += lArray[n++];
        }
        return l2;
    }

    public static long accumulate(long[] lArray, int n, int n2, long l, BinaryOperator binaryOperator) {
        long l2 = l;
        while (n < n2) {
            l2 = binaryOperator.apply(l2, lArray[n++]);
        }
        return l2;
    }

    public static long inner_product(long[] lArray, long[] lArray2, int n, int n2, int n3, long l) {
        long l2 = l;
        while (n < n2) {
            l2 += lArray[n++] * lArray2[n3++];
        }
        return l2;
    }

    public static long inner_product(long[] lArray, long[] lArray2, int n, int n2, int n3, long l, BinaryOperator binaryOperator, BinaryOperator binaryOperator2) {
        long l2 = l;
        while (n < n2) {
            l2 = binaryOperator.apply(l2, binaryOperator2.apply(lArray[n++], lArray2[n3++]));
        }
        return l2;
    }

    public static int partial_sum(long[] lArray, long[] lArray2, int n, int n2, int n3) {
        if (n < n2) {
            lArray2[n3] = lArray[n];
            long l = lArray2[n3];
            while (++n < n2) {
                lArray2[++n3] = l += lArray[n];
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int partial_sum(long[] lArray, long[] lArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            lArray2[n3] = lArray[n];
            long l = lArray2[n3];
            while (++n < n2) {
                l = binaryOperator.apply(l, lArray[n]);
                lArray2[++n3] = l;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(long[] lArray, long[] lArray2, int n, int n2, int n3) {
        if (n < n2) {
            lArray2[n3] = lArray[n];
            long l = lArray[n];
            while (++n < n2) {
                long l2 = lArray[n];
                lArray2[++n3] = l2 - l;
                l = l2;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(long[] lArray, long[] lArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            lArray2[n3] = lArray[n];
            long l = lArray[n];
            while (++n < n2) {
                long l2 = lArray[n];
                lArray2[++n3] = binaryOperator.apply(l2, l);
                l = l2;
            }
            return n3 + 1;
        }
        return n3;
    }

    private Numeric() {
    }
}

