/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class MergeAnnotation
extends AbstractChangeable
implements Annotation,
Serializable {
    private transient ChangeListener propertyForwarder = null;
    private List mergeSet = new ArrayList();

    public void addAnnotation(Annotation ann) throws ChangeVetoException {
        this.mergeSet.add(ann);
    }

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        ChangeSupport changeSupport = super.getChangeSupport(changeType);
        if (changeType == null || changeType.isMatchingType(Annotation.PROPERTY) && this.propertyForwarder == null) {
            this.propertyForwarder = new PropertyForwarder(this, changeSupport);
            Iterator i = this.mergeSet.iterator();
            while (i.hasNext()) {
                Annotation a = (Annotation)i.next();
                a.addChangeListener(this.propertyForwarder, Annotation.PROPERTY);
            }
        }
        return changeSupport;
    }

    public void setProperty(Object key, Object value) throws ChangeVetoException {
        throw new ChangeVetoException("MergeAnnotations don't allow property setting at the moment");
    }

    public void removeProperty(Object key) throws ChangeVetoException {
        throw new ChangeVetoException("MergeAnnotations don't allow property removal at the moment");
    }

    public Object getProperty(Object key) {
        Iterator i = this.mergeSet.iterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            if (!a.containsProperty(key)) continue;
            return a.getProperty(key);
        }
        throw new NoSuchElementException("Can't find property " + key);
    }

    public boolean containsProperty(Object key) {
        Iterator i = this.mergeSet.iterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            if (!a.containsProperty(key)) continue;
            return true;
        }
        return false;
    }

    private Object getPropertySilent(Object key) {
        try {
            return this.getProperty(key);
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public Set keys() {
        HashSet<Set> s = new HashSet<Set>();
        Iterator i = this.mergeSet.iterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            s.add(a.keys());
        }
        return s;
    }

    public Map asMap() {
        return new MAMap();
    }

    protected class PropertyForwarder
    extends ChangeForwarder {
        public PropertyForwarder(Object source, ChangeSupport cs) {
            super(source, cs);
        }

        public ChangeEvent generateEvent(ChangeEvent ce) {
            Object[] cur;
            Object curVal;
            ChangeType ct = ce.getType();
            if (ct == Annotation.PROPERTY && (curVal = ce.getChange()) instanceof Object[] && (cur = (Object[])curVal).length == 2) {
                Object key = cur[0];
                Object value = cur[0];
                if (MergeAnnotation.this.getProperty(key) != value) {
                    return new ChangeEvent(this.getSource(), Annotation.PROPERTY, curVal, ce.getPrevious(), ce);
                }
            }
            return null;
        }
    }

    private class MAMap
    extends AbstractMap {
        MAEntrySet es;

        private MAMap() {
            this.es = new MAEntrySet();
        }

        public Set entrySet() {
            return this.es;
        }

        public Set keySet() {
            return MergeAnnotation.this.keys();
        }

        public Object get(Object key) {
            try {
                return MergeAnnotation.this.getProperty(key);
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
    }

    private class MAMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        private MAMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object v) {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            boolean bl;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mo = (Map.Entry)o;
            if (this.key == null) {
                if (mo.getKey() != null) return false;
                bl = true;
            } else {
                bl = this.key.equals(mo.getKey());
            }
            if (!bl) return false;
            if (this.value == null) {
                if (mo.getValue() != null) return false;
                return true;
            }
            boolean bl2 = this.value.equals(mo.getValue());
            if (!bl2) return false;
            return true;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class MAEntrySet
    extends AbstractSet {
        private MAEntrySet() {
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator ksi;
                {
                    this.ksi = MergeAnnotation.this.keys().iterator();
                }

                public boolean hasNext() {
                    return this.ksi.hasNext();
                }

                public Object next() {
                    Object k = this.ksi.next();
                    Object v = MergeAnnotation.this.getProperty(k);
                    return new MAMapEntry(k, v);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return MergeAnnotation.this.keys().size();
        }
    }
}

