/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public final class SimpleDistributionTrainer
implements DistributionTrainer,
Serializable {
    private final Distribution dis;
    private final Map c = new HashMap();

    public void addCount(DistributionTrainerContext dtc, AtomicSymbol sym, double count) throws IllegalSymbolException {
        Double d = (Double)this.c.get(sym);
        if (d == null) {
            throw new IllegalSymbolException("Symbol " + sym.getName() + " not found in " + this.dis.getAlphabet().getName());
        }
        if (count < 0.0) {
            throw new Error("Can't add a negative count for " + sym.getName() + " of " + count);
        }
        this.c.put(sym, new Double(d + count));
    }

    public double getCount(DistributionTrainerContext dtc, AtomicSymbol sym) throws IllegalSymbolException {
        Double d = (Double)this.c.get(sym);
        if (d == null) {
            throw new IllegalSymbolException("Symbol " + sym.getName() + " not found in " + this.dis.getAlphabet().getName());
        }
        return (Double)this.c.get(sym);
    }

    public void train(DistributionTrainerContext dtc, double weight) throws ChangeVetoException {
        Distribution nullModel = this.dis.getNullModel();
        double sum = 0.0;
        try {
            Iterator i = ((FiniteAlphabet)this.dis.getAlphabet()).iterator();
            while (i.hasNext()) {
                Symbol s = (Symbol)i.next();
                Double d = (Double)this.c.get(s);
                sum += d + nullModel.getWeight(s) * weight;
            }
            Iterator i2 = ((FiniteAlphabet)this.dis.getAlphabet()).iterator();
            while (i2.hasNext()) {
                Symbol sym = (Symbol)i2.next();
                Double d = (Double)this.c.get(sym);
                this.dis.setWeight(sym, (d + nullModel.getWeight(sym) * weight) / sum);
            }
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("The alphabet for this distribution is not self-consistent");
        }
    }

    public void clearCounts(DistributionTrainerContext dtc) {
        Iterator i = ((FiniteAlphabet)this.dis.getAlphabet()).iterator();
        while (i.hasNext()) {
            this.c.put(i.next(), new Double(0.0));
        }
    }

    public SimpleDistributionTrainer(Distribution dis) throws IllegalAlphabetException {
        Alphabet a = dis.getAlphabet();
        if (!(a instanceof FiniteAlphabet)) {
            throw new IllegalAlphabetException("Can't create a SimpleDistributionTrainer for non-finite alphabet " + a.getName() + " of type " + a.getClass());
        }
        this.dis = dis;
    }
}

