/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class TranslatedDistribution
extends AbstractChangeable
implements Distribution,
Serializable {
    private final Distribution other;
    private final Distribution delegate;
    private final ReversibleTranslationTable table;
    private transient ChangeListener forwarder;

    public TranslatedDistribution(ReversibleTranslationTable table, Distribution other, DistributionFactory distFact) throws IllegalAlphabetException {
        if (!table.getTargetAlphabet().equals(other.getAlphabet())) {
            throw new IllegalAlphabetException("Table target alphabet and distribution alphabet don't match: " + table.getTargetAlphabet().getName() + " and " + other.getAlphabet().getName() + " without symbol ");
        }
        this.other = other;
        this.table = table;
        this.delegate = distFact.createDistribution(table.getSourceAlphabet());
    }

    public Alphabet getAlphabet() {
        return this.table.getSourceAlphabet();
    }

    public double getWeight(Symbol sym) throws IllegalSymbolException {
        return this.delegate.getWeight(sym);
    }

    public void setWeight(Symbol sym, double weight) throws IllegalSymbolException, ChangeVetoException {
        this.delegate.setWeight(sym, weight);
    }

    public Symbol sampleSymbol() {
        return this.delegate.sampleSymbol();
    }

    public Distribution getNullModel() {
        return this.delegate.getNullModel();
    }

    public void setNullModel(Distribution dist) throws IllegalAlphabetException, ChangeVetoException {
        this.delegate.setNullModel(dist);
    }

    public ReversibleTranslationTable getTable() {
        return this.table;
    }

    public void registerWithTrainer(DistributionTrainerContext dtc) {
        dtc.registerDistribution(this.other);
        dtc.registerTrainer(this, new DistributionTrainer(){

            public void addCount(DistributionTrainerContext dtc, AtomicSymbol s, double count) throws IllegalSymbolException {
                dtc.addCount(TranslatedDistribution.this.other, TranslatedDistribution.this.table.translate(s), count);
            }

            public double getCount(DistributionTrainerContext dtc, AtomicSymbol s) throws IllegalSymbolException {
                return dtc.getCount(TranslatedDistribution.this.other, TranslatedDistribution.this.table.translate(s));
            }

            public void train(DistributionTrainerContext dtc, double weight) throws ChangeVetoException {
                SimpleDistributionTrainerContext subCtxt = new SimpleDistributionTrainerContext();
                subCtxt.setNullModelWeight(weight);
                subCtxt.registerDistribution(TranslatedDistribution.this.delegate);
                Iterator i = ((FiniteAlphabet)TranslatedDistribution.this.other.getAlphabet()).iterator();
                while (i.hasNext()) {
                    AtomicSymbol sym = (AtomicSymbol)i.next();
                    try {
                        subCtxt.addCount(TranslatedDistribution.this.delegate, TranslatedDistribution.this.table.translate(sym), dtc.getCount(TranslatedDistribution.this.other, sym));
                    }
                    catch (IllegalSymbolException ise) {
                        throw new BioError(ise, "Assertion Failed: Can't train");
                    }
                }
                subCtxt.train();
            }

            public void clearCounts(DistributionTrainerContext dtc) {
            }
        });
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.forwarder == null && ct.isMatchingType(Distribution.WEIGHTS)) {
            this.forwarder = new Forwarder(this, cs);
            this.delegate.addChangeListener(this.forwarder, Distribution.WEIGHTS);
        }
        return cs;
    }

    private class Forwarder
    extends ChangeForwarder {
        public Forwarder(Object source, ChangeSupport changeSupport) {
            super(source, changeSupport);
        }

        protected ChangeEvent generateChangeEvent(ChangeEvent ce) {
            ChangeType ct = ce.getType();
            Object[] change = ce.getChange();
            Object[] previous = ce.getPrevious();
            if (ct == Distribution.WEIGHTS) {
                Object[] pa;
                Object[] ca;
                if (change != null && change instanceof Object[] && (ca = (Object[])change).length == 2 && ca[0] instanceof Symbol) {
                    try {
                        change = new Object[]{TranslatedDistribution.this.table.translate((Symbol)ca[0]), ca[1]};
                    }
                    catch (IllegalSymbolException ise) {
                        throw new BioError(ise, "Couldn't translate symbol");
                    }
                }
                if (previous != null && previous instanceof Object[] && (pa = (Object[])previous).length == 2 && pa[0] instanceof Symbol) {
                    try {
                        previous = new Object[]{TranslatedDistribution.this.table.translate((Symbol)pa[0]), pa[1]};
                    }
                    catch (IllegalSymbolException ise) {
                        throw new BioError(ise, "Couldn't translate symbol");
                    }
                }
            } else if (ct == Distribution.NULL_MODEL) {
                change = null;
                previous = null;
            }
            return new ChangeEvent(TranslatedDistribution.this, ct, change, previous, ce);
        }
    }
}

