/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.SimpleDistribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelInState;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.Transition;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleMarkovModel
extends AbstractChangeable
implements MarkovModel,
Serializable {
    public static final long serialVersionUID = -3043028839927615753L;
    private final Alphabet emissionAlpha;
    private final FiniteAlphabet stateAlpha;
    private final MagicalState magicalState;
    private final Map transFrom;
    private final Map transTo;
    private final Map transWeights;
    private transient MarkovModel.DistributionForwarder distForwarder;
    private Transition _tran = new Transition(null, null);

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport changeSupport = super.getChangeSupport(ct);
        if ((ct == null || ct == MarkovModel.PARAMETER) && this.distForwarder == null) {
            this.distForwarder = new MarkovModel.DistributionForwarder(this, changeSupport);
            Iterator si = this.stateAlpha.iterator();
            while (si.hasNext()) {
                State s = (State)si.next();
                if (!(s instanceof EmissionState)) continue;
                EmissionState es = (EmissionState)s;
                Distribution dist = es.getDistribution();
                dist.addChangeListener(this.distForwarder, Distribution.WEIGHTS);
                dist.addChangeListener(this.distForwarder, Distribution.NULL_MODEL);
            }
        }
        return changeSupport;
    }

    public Alphabet emissionAlphabet() {
        return this.emissionAlpha;
    }

    public FiniteAlphabet stateAlphabet() {
        return this.stateAlpha;
    }

    public int heads() {
        return this.magicalState().getAdvance().length;
    }

    public MagicalState magicalState() {
        return this.magicalState;
    }

    public Distribution getWeights(State source) throws IllegalSymbolException {
        this.stateAlphabet().validate(source);
        Distribution dist = (Distribution)this.transWeights.get(source);
        if (dist == null) {
            throw new BioError("Model does contain " + source.getName() + " but the associated transition distribution is missing.");
        }
        return dist;
    }

    public void setWeights(State source, Distribution dist) throws IllegalSymbolException, IllegalAlphabetException {
        FiniteAlphabet ta = this.transitionsFrom(source);
        if (!dist.getAlphabet().equals(ta)) {
            throw new IllegalAlphabetException("Can't set distribution from state " + source.getName() + " as the distribution alphabet is not the alphabet of transitions: " + ta.getName() + " and " + dist.getAlphabet().getName());
        }
        this.transWeights.put(source, dist);
    }

    public void createTransition(State from, State to) throws IllegalSymbolException, ChangeVetoException {
        this.stateAlphabet().validate(from);
        this.stateAlphabet().validate(to);
        ChangeEvent ce = new ChangeEvent(this, MarkovModel.ARCHITECTURE, new Object[]{from, to}, null);
        FiniteAlphabet f = this.transitionsFrom(from);
        FiniteAlphabet t = this.transitionsTo(to);
        if (f.contains(to)) {
            throw new ChangeVetoException(ce, "Transition already exists: " + from.getName() + " -> " + to.getName());
        }
        if (!this.hasListeners()) {
            f.addSymbol(to);
            t.addSymbol(from);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(MarkovModel.ARCHITECTURE);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                f.addSymbol(to);
                t.addSymbol(from);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public void destroyTransition(State from, State to) throws IllegalSymbolException, ChangeVetoException {
        this.stateAlphabet().validate(from);
        this.stateAlphabet().validate(to);
        FiniteAlphabet f = this.transitionsFrom(from);
        FiniteAlphabet t = this.transitionsTo(to);
        ChangeEvent ce = new ChangeEvent(this, MarkovModel.ARCHITECTURE, null, new Object[]{from, to});
        if (!f.contains(to)) {
            throw new ChangeVetoException(ce, "Transition does not exists: " + from.getName() + " -> " + to.getName());
        }
        Distribution dist = this.getWeights(from);
        double w = dist.getWeight(to);
        if (w != 0.0) {
            throw new ChangeVetoException(ce, "Can't remove transition as its weight is not zero: " + from.getName() + " -> " + to.getName() + " = " + w);
        }
        if (!this.hasListeners()) {
            this.transitionsFrom(from).removeSymbol(to);
            this.transitionsTo(to).removeSymbol(from);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(MarkovModel.ARCHITECTURE);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.transitionsFrom(from).removeSymbol(to);
                this.transitionsTo(to).removeSymbol(from);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public boolean containsTransition(State from, State to) throws IllegalSymbolException {
        this.stateAlphabet().validate(to);
        return this.transitionsFrom(from).contains(to);
    }

    public FiniteAlphabet transitionsFrom(State from) throws IllegalSymbolException {
        this.stateAlphabet().validate(from);
        FiniteAlphabet s = (FiniteAlphabet)this.transFrom.get(from);
        if (s == null) {
            throw new BioError("State " + from.getName() + " is known in states " + this.stateAlphabet().getName() + " but is not listed in the transFrom table");
        }
        return s;
    }

    public FiniteAlphabet transitionsTo(State to) throws IllegalSymbolException {
        this.stateAlphabet().validate(to);
        FiniteAlphabet s = (FiniteAlphabet)this.transTo.get(to);
        if (s == null) {
            throw new BioError("State " + to + " is known in states " + this.stateAlphabet().getName() + " but is not listed in the transTo table");
        }
        return s;
    }

    public void addState(State toAdd) throws IllegalSymbolException, ChangeVetoException {
        int esh;
        if (toAdd instanceof MagicalState && toAdd != this.magicalState) {
            throw new IllegalSymbolException("Can not add a MagicalState");
        }
        if (this.stateAlphabet().contains(toAdd)) {
            throw new IllegalSymbolException("We already contain " + toAdd.getName());
        }
        if (toAdd instanceof EmissionState && (esh = ((EmissionState)toAdd).getAdvance().length) != this.heads()) {
            throw new IllegalSymbolException("This model " + this.stateAlphabet().getName() + " has " + this.heads() + " heads, but the state " + toAdd.getName() + " has " + esh + " heads");
        }
        if (toAdd instanceof ModelInState && (esh = ((ModelInState)toAdd).getModel().heads()) != this.heads()) {
            throw new IllegalSymbolException("This model " + this.stateAlphabet().getName() + " has " + this.heads() + " heads, but the model-in-state " + toAdd.getName() + " has " + esh + " heads");
        }
        if (!this.hasListeners()) {
            this.doAddState(toAdd);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(MarkovModel.ARCHITECTURE);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, MarkovModel.ARCHITECTURE, toAdd, null);
                changeSupport.firePreChangeEvent(ce);
                this.doAddState(toAdd);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    private void doAddState(State toAdd) throws IllegalSymbolException, ChangeVetoException {
        ((SimpleAlphabet)this.stateAlphabet()).addSymbol(toAdd);
        SimpleAlphabet fa = new SimpleAlphabet("Transitions from " + toAdd.getName());
        this.transFrom.put(toAdd, fa);
        this.transTo.put(toAdd, new SimpleAlphabet("Transitions to " + toAdd.getName()));
        this.transWeights.put(toAdd, new SimpleDistribution(fa));
        ((SimpleAlphabet)this.stateAlphabet()).addSymbol(toAdd);
        if (toAdd instanceof EmissionState) {
            Distribution dist = ((EmissionState)toAdd).getDistribution();
            if (this.distForwarder != null) {
                dist.addChangeListener(this.distForwarder, Distribution.WEIGHTS);
                dist.addChangeListener(this.distForwarder, Distribution.NULL_MODEL);
            }
        }
    }

    public void removeState(State toGo) throws IllegalSymbolException, IllegalTransitionException, ChangeVetoException {
        this.stateAlphabet().validate(toGo);
        if (toGo instanceof MagicalState) {
            throw new IllegalSymbolException("You can not remove the MagicalState");
        }
        FiniteAlphabet t = this.transitionsFrom(toGo);
        if (t.size() != 0) {
            throw new IllegalTransitionException(toGo, (State)t.iterator().next(), "You can not remove a state untill all transitions to and from it have been destroyed");
        }
        t = this.transitionsTo(toGo);
        if (t.size() != 0) {
            throw new IllegalTransitionException((State)t.iterator().next(), toGo, "You can not remove a state untill all transitions to and from it have been destroyed");
        }
        if (!this.hasListeners()) {
            this.doRemoveState(toGo);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(MarkovModel.ARCHITECTURE);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, MarkovModel.ARCHITECTURE, null, toGo);
                changeSupport.firePreChangeEvent(ce);
                this.doRemoveState(toGo);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    private void doRemoveState(State toGo) throws IllegalSymbolException {
        ((SimpleAlphabet)this.stateAlphabet()).removeSymbol(toGo);
        this.transFrom.remove(toGo);
        this.transTo.remove(toGo);
        if (toGo instanceof EmissionState) {
            Distribution dist = ((EmissionState)toGo).getDistribution();
            if (this.distForwarder != null) {
                toGo.removeChangeListener(this.distForwarder, Distribution.NULL_MODEL);
                toGo.removeChangeListener(this.distForwarder, Distribution.WEIGHTS);
            }
        }
    }

    public SimpleMarkovModel(int heads, Alphabet emissionAlpha, String name) {
        this(heads, emissionAlpha);
        ((SimpleAlphabet)this.stateAlpha).setName(name);
    }

    public SimpleMarkovModel(int heads, Alphabet emissionAlpha) {
        this.transFrom = new HashMap();
        this.transTo = new HashMap();
        this.transWeights = new HashMap();
        this.emissionAlpha = emissionAlpha;
        this.stateAlpha = new SimpleAlphabet();
        this.magicalState = MagicalState.getMagicalState(emissionAlpha, heads);
        try {
            this.addState(this.magicalState);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion failure: Couldn't add magical state");
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Assertion failure: Couldn't add magical state");
        }
    }
}

