/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.onehead;

import java.util.Iterator;
import org.biojava.bio.dp.onehead.DPCursor;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

abstract class AbstractCursor
implements DPCursor {
    private static final Symbol gap = AlphabetManager.getGapSymbol();
    private Iterator symIterator;
    private Symbol currentRes;
    private Symbol lastRes;

    public Symbol currentRes() {
        return this.currentRes;
    }

    public Symbol lastRes() {
        return this.lastRes;
    }

    public boolean canAdvance() {
        return this.symIterator.hasNext() || this.currentRes != gap;
    }

    public void advance() {
        this.lastRes = this.currentRes;
        this.currentRes = this.symIterator.hasNext() ? (Symbol)this.symIterator.next() : gap;
    }

    public AbstractCursor(Iterator symIterator) {
        this.symIterator = symIterator;
        this.currentRes = gap;
        this.lastRes = gap;
    }

    protected AbstractCursor() {
    }

    public abstract double[] lastCol();

    public abstract double[] currentCol();

    public abstract int length();

    public abstract SymbolList symList();
}

