/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class LabelledSequenceRenderer
extends AbstractChangeable
implements SequenceRenderer {
    boolean selected = true;
    SequenceRenderer seqRend = null;
    double width = 200.0;
    double depth = 100.0;
    List labels = new ArrayList();
    Rectangle mouseClickArea = new Rectangle(0, 0, -1, -1);
    private transient ChangeForwarder rendererForwarder = null;
    public static final ChangeType RENDERER = new ChangeType("The SequenceRenderer has been added or removed", "SequenceLabelRenderer", "RENDERER", SequenceRenderContext.LAYOUT);
    public static final ChangeType VALUES = new ChangeType("The label value has changed", "SequenceLabelRenderer", "VALUES", SequenceRenderContext.REPAINT);

    protected ChangeSupport generateChangeSupport() {
        ChangeSupport cs = super.generateChangeSupport();
        this.rendererForwarder = new SequenceRenderer.RendererForwarder(this, cs);
        if (this.seqRend != null && this.seqRend instanceof Changeable) {
            Changeable c = (Changeable)((Object)this.seqRend);
            c.addChangeListener(this.rendererForwarder, SequenceRenderContext.REPAINT);
            c.addChangeListener(this.rendererForwarder, SequenceRenderContext.LAYOUT);
        }
        return cs;
    }

    public LabelledSequenceRenderer() {
    }

    public LabelledSequenceRenderer(double minWidth, double minDepth) {
        this.width = minWidth;
        this.depth = minDepth;
    }

    public void setRenderer(SequenceRenderer sR) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERER, sR, this.seqRend);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERER);
            synchronized (changeSupport) {
                Changeable c;
                cs.firePreChangeEvent(ce);
                if (this.seqRend != null && this.seqRend instanceof Changeable) {
                    c = (Changeable)((Object)this.seqRend);
                    c.removeChangeListener(this.rendererForwarder);
                }
                this.seqRend = sR;
                if (this.seqRend instanceof Changeable) {
                    c = (Changeable)((Object)this.seqRend);
                    c.addChangeListener(this.rendererForwarder);
                }
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.seqRend = sR;
        }
    }

    public void addLabelString(String text) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(VALUES);
            ChangeEvent ce = new ChangeEvent(this, VALUES, text);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.labels.add(text);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.labels.add(text);
        }
    }

    public void removeLabelString(String text) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(VALUES);
            ChangeEvent ce = new ChangeEvent(this, VALUES, null, text);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.labels.remove(text);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.labels.remove(text);
        }
    }

    public void toggleSelectionStatus() throws ChangeVetoException {
        boolean newStatus = !this.selected;
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(VALUES);
            ChangeEvent ce = new ChangeEvent(this, VALUES);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.selected = newStatus;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.selected = newStatus;
        }
    }

    public double getMinimumLeader(SequenceRenderContext sRC) {
        return this.width + this.seqRend.getMinimumLeader(sRC);
    }

    public double getMinimumTrailer(SequenceRenderContext sRC) {
        return this.seqRend.getMinimumTrailer(sRC);
    }

    public double getDepth(SequenceRenderContext sRC) {
        return Math.max(this.depth, this.seqRend.getDepth(sRC));
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext sRC, MouseEvent mE, List path) {
        path.add(this);
        SequenceViewerEvent sVE = this.mouseClickArea.contains(mE.getX(), mE.getY()) ? new SequenceViewerEvent(this, this, 1, mE, path) : this.seqRend.processMouseEvent(sRC, mE, path);
        return sVE;
    }

    public void paint(Graphics2D g, SequenceRenderContext sRC) {
        Color selectedFill = Color.yellow;
        Color textColor = Color.black;
        Color notSelectedFill = g.getBackground();
        BasicStroke beadStroke = new BasicStroke();
        Shape originalClip = g.getClip();
        AffineTransform originalTransform = g.getTransform();
        Rectangle2D.Double labelArea = new Rectangle2D.Double();
        Font font = sRC.getFont();
        FontRenderContext fRC = g.getFontRenderContext();
        if (sRC.getDirection() == 1) {
            g.rotate(-1.5707963267948966);
            g.translate(-this.width, 0.0);
            this.mouseClickArea.setRect(0.0, -this.width, this.depth, this.width);
        } else {
            this.mouseClickArea.setRect(-this.width, 0.0, this.width, this.depth);
        }
        ((Rectangle2D)labelArea).setRect(-this.width, 0.0, this.width, this.depth);
        g.clip(labelArea);
        if (this.selected) {
            g.setPaint(selectedFill);
        } else {
            g.setPaint(notSelectedFill);
        }
        g.fill(labelArea);
        g.setPaint(textColor);
        float drawPosY = 3.0f;
        float drawPosX = (float)(5.0 - this.width);
        Iterator labelIterator = this.labels.iterator();
        while (labelIterator.hasNext()) {
            String currentString = (String)labelIterator.next();
            TextLayout tLayout = new TextLayout(currentString, font, fRC);
            tLayout.draw(g, drawPosX, drawPosY += tLayout.getAscent());
            drawPosY += tLayout.getDescent() + tLayout.getLeading();
        }
        g.setTransform(originalTransform);
        g.setClip(originalClip);
        this.seqRend.paint(g, sRC);
    }
}

