/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.sequence.PairwiseRenderContext;
import org.biojava.bio.gui.sequence.PairwiseSequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class PairwiseDiagonalRenderer
extends AbstractChangeable
implements PairwiseSequenceRenderer,
Serializable {
    public static final ChangeType OUTLINE = new ChangeType("The outline paint has changed", "org.biojava.bio.gui.sequence.PairwiseDiagonalRenderer", "OUTLINE", SequenceRenderContext.REPAINT);
    private static FeatureFilter spf;
    protected Line2D.Float line = new Line2D.Float();
    protected Paint outline;

    public PairwiseDiagonalRenderer() {
        this(Color.black);
    }

    public PairwiseDiagonalRenderer(Paint outline) {
        this.outline = outline;
    }

    public void paint(Graphics2D g2, PairwiseRenderContext context) {
        FeatureHolder fh = context.getDirection() == 0 ? context.getFeatures().filter(new FeatureFilter.And(new FeatureFilter.OverlapsLocation(context.getRange()), spf), false) : context.getFeatures().filter(new FeatureFilter.And(new FeatureFilter.OverlapsLocation(context.getSecondaryRange()), spf), false);
        Iterator fi = fh.features();
        while (fi.hasNext()) {
            SimilarityPairFeature f1 = (SimilarityPairFeature)fi.next();
            SimilarityPairFeature f2 = f1.getSibling();
            StrandedFeature.Strand s1 = f1.getStrand();
            StrandedFeature.Strand s2 = f2.getStrand();
            Location loc1 = f1.getLocation();
            Location loc2 = f2.getLocation();
            int min1 = loc1.getMin();
            int max1 = loc1.getMax();
            int min2 = loc2.getMin();
            int max2 = loc2.getMax();
            if (context.getDirection() == 0) {
                float posX1 = (float)context.sequenceToGraphics(min1);
                float posY1 = (float)context.secondarySequenceToGraphics(min2);
                float posX2 = (float)context.sequenceToGraphics(max1);
                float posY2 = (float)context.secondarySequenceToGraphics(max2);
                if (s1 == s2) {
                    this.line.setLine(posX1, posY1, posX2, posY2);
                } else {
                    this.line.setLine(posX2, posY1, posX1, posY2);
                }
            } else {
                float posY1 = (float)context.sequenceToGraphics(min1);
                float posX1 = (float)context.secondarySequenceToGraphics(min2);
                float posY2 = (float)context.sequenceToGraphics(max1);
                float posX2 = (float)context.secondarySequenceToGraphics(max2);
                if (s1 == s2) {
                    this.line.setLine(posX1, posY1, posX2, posY2);
                } else {
                    this.line.setLine(posX2, posY1, posX1, posY2);
                }
            }
            Rectangle clip = g2.getClipBounds();
            this.clipLine((float)clip.getMinX(), (float)clip.getMaxX(), (float)clip.getMinY(), (float)clip.getMaxY(), this.line);
            g2.setPaint(this.outline);
            g2.draw(this.line);
        }
    }

    public Paint getOutline() {
        return this.outline;
    }

    public void setOutline(Paint outline) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent(this, OUTLINE, outline, this.outline));
                cs.firePreChangeEvent(ce);
                this.outline = outline;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.outline = outline;
        }
    }

    public SequenceViewerEvent processMouseEvent(PairwiseRenderContext context, MouseEvent me, List path) {
        path.add(this);
        double gPos = context.getDirection() == 0 ? me.getPoint().getX() : me.getPoint().getY();
        int priMin = context.graphicsToSequence(gPos);
        int priMax = context.graphicsToSequence(gPos + 1.0);
        FeatureHolder fh = context.getFeatures().filter(new FeatureFilter.And(new FeatureFilter.OverlapsLocation(new RangeLocation(priMin, priMax)), spf), false);
        return new SequenceViewerEvent(this, fh, priMin, me, path);
    }

    private void clipLine(float xMin, float xMax, float yMin, float yMax, Line2D.Float line) {
        int clipTypeY;
        int clipTypeX = this.calcClipType(xMin, xMax, yMin, yMax, line.x1, line.y1);
        if ((clipTypeX | (clipTypeY = this.calcClipType(xMin, xMax, yMin, yMax, line.x2, line.y2))) != 0) {
            if ((clipTypeX & clipTypeY) != 0) {
                return;
            }
            float dx = line.x2 - line.x1;
            float dy = line.y2 - line.y1;
            if (clipTypeX != 0) {
                if ((clipTypeX & 8) == 8) {
                    line.y1 += (xMin - line.x1) * dy / dx;
                    line.x1 = xMin;
                } else if ((clipTypeX & 4) == 4) {
                    line.y1 += (xMax - line.x1) * dy / dx;
                    line.x1 = xMax;
                } else if ((clipTypeX & 2) == 2) {
                    line.x1 += (yMin - line.y1) * dx / dy;
                    line.y1 = yMin;
                } else if ((clipTypeX & 1) == 1) {
                    line.x1 += (yMax - line.y1) * dx / dy;
                    line.y1 = yMax;
                }
            } else if (clipTypeY != 0) {
                if ((clipTypeY & 8) == 8) {
                    line.y2 += (xMin - line.x2) * dy / dx;
                    line.x2 = xMin;
                } else if ((clipTypeY & 4) == 4) {
                    line.y2 += (xMax - line.x2) * dy / dx;
                    line.x2 = xMax;
                } else if ((clipTypeY & 2) == 2) {
                    line.x2 += (yMin - line.y2) * dx / dy;
                    line.y2 = yMin;
                } else if ((clipTypeY & 1) == 1) {
                    line.x2 += (yMax - line.y2) * dx / dy;
                    line.y2 = yMax;
                }
            }
        }
    }

    private int calcClipType(float xMin, float xMax, float yMin, float yMax, float x, float y) {
        return (x < xMin ? 8 : 0) | (x > xMax ? 4 : 0) | (y < yMin ? 2 : 0) | (y > yMax ? 1 : 0);
    }

    static {
        String className = "org.biojava.bio.seq.homol.SimilarityPairFeature";
        try {
            spf = new FeatureFilter.ByClass(Class.forName(className));
        }
        catch (Exception e) {
            throw new BioError(e, "Failed to load Class for " + className);
        }
    }
}

