/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionSupport;
import org.biojava.bio.gui.sequence.SequenceViewerSupport;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class TranslatedSequencePanel
extends JComponent
implements SequenceRenderContext,
Changeable {
    public static final ChangeType RENDERER = new ChangeType("The renderer for this TranslatedSequencePanel has changed", "org.biojava.bio.gui.sequence.TranslatedSequencePanel", "RENDERER", SequenceRenderContext.LAYOUT);
    public static final ChangeType TRANSLATION = new ChangeType("The translation for this TranslatedSequencePanel has changed", "org.biojava.bio.gui.sequence.TranslatedSequencePanel", "TRANSLATION", SequenceRenderContext.REPAINT);
    private Sequence sequence;
    private int translation;
    private int direction;
    private double scale;
    private SequenceRenderer renderer;
    private double rendererBorders;
    private RenderingHints hints;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent pce) {
            TranslatedSequencePanel.this.repaint();
        }
    };
    private transient ChangeSupport changeSupport = null;
    private ChangeListener repaintListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            TranslatedSequencePanel.this.repaint();
        }
    };
    private ChangeListener layoutListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            TranslatedSequencePanel.this.revalidate();
        }
    };
    private SequenceViewerSupport svSupport = new SequenceViewerSupport();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent me) {
            if (!TranslatedSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = TranslatedSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = TranslatedSequencePanel.this.renderer.processMouseEvent(TranslatedSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            TranslatedSequencePanel.this.svSupport.fireMouseClicked(sve);
        }

        public void mousePressed(MouseEvent me) {
            if (!TranslatedSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = TranslatedSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = TranslatedSequencePanel.this.renderer.processMouseEvent(TranslatedSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            TranslatedSequencePanel.this.svSupport.fireMousePressed(sve);
        }

        public void mouseReleased(MouseEvent me) {
            if (!TranslatedSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = TranslatedSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = TranslatedSequencePanel.this.renderer.processMouseEvent(TranslatedSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            TranslatedSequencePanel.this.svSupport.fireMouseReleased(sve);
        }
    };
    private SequenceViewerMotionSupport svmSupport = new SequenceViewerMotionSupport();
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent me) {
            if (!TranslatedSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = TranslatedSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = TranslatedSequencePanel.this.renderer.processMouseEvent(TranslatedSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            TranslatedSequencePanel.this.svmSupport.fireMouseDragged(sve);
        }

        public void mouseMoved(MouseEvent me) {
            if (!TranslatedSequencePanel.this.isActive()) {
                return;
            }
            Insets insets = TranslatedSequencePanel.this.getInsets();
            me.translatePoint(-insets.left, -insets.top);
            SequenceViewerEvent sve = TranslatedSequencePanel.this.renderer.processMouseEvent(TranslatedSequencePanel.this, me, new ArrayList());
            me.translatePoint(insets.left, insets.top);
            TranslatedSequencePanel.this.svmSupport.fireMouseMoved(sve);
        }
    };
    static /* synthetic */ Class class$org$biojava$utils$Changeable;

    public TranslatedSequencePanel() {
        if (this.getFont() == null) {
            this.setFont(new Font("sanserif", 0, 12));
        }
        this.direction = 0;
        this.scale = 10.0;
        this.translation = 0;
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        this.leadingBorder.setSize(0.0);
        this.trailingBorder.setSize(0.0);
        this.hints = new RenderingHints(null);
        this.addPropertyChangeListener(this.propertyListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        Sequence prevSequence = this.sequence;
        if (prevSequence != null) {
            prevSequence.removeChangeListener(this.layoutListener);
        }
        this.sequence = sequence;
        if (sequence != null) {
            if (this.renderer != null) {
                this.rendererBorders = this.renderer.getMinimumLeader(this) + this.renderer.getMinimumTrailer(this);
            }
            sequence.addChangeListener(this.layoutListener);
        }
        this.firePropertyChange("sequence", prevSequence, sequence);
        this.resizeAndValidate();
    }

    public SymbolList getSymbols() {
        return this.sequence;
    }

    public FeatureHolder getFeatures() {
        return this.sequence;
    }

    public RangeLocation getRange() {
        int visibleSymbols = this.getVisibleSymbolCount();
        if (visibleSymbols == 0) {
            return new RangeLocation(this.translation + 1, this.translation + 2);
        }
        return new RangeLocation(this.translation + 1, visibleSymbols);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) throws IllegalArgumentException {
        if (direction != 0 && direction != 1) {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        int prevDirection = this.direction;
        this.direction = direction;
        this.firePropertyChange("direction", prevDirection, direction);
        this.resizeAndValidate();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double prevScale = this.scale;
        this.scale = scale;
        this.firePropertyChange("scale", prevScale, scale);
        this.resizeAndValidate();
    }

    public int getSymbolTranslation() {
        return this.translation;
    }

    public void setSymbolTranslation(int translation) throws IndexOutOfBoundsException {
        if (translation >= this.sequence.length()) {
            throw new IndexOutOfBoundsException("Tried to set symbol translation offset equal to or greater than SymbolList length");
        }
        int prevTranslation = this.translation;
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(TRANSLATION);
            ChangeEvent ce = new ChangeEvent(this, TRANSLATION);
            cs.firePostChangeEvent(ce);
            this.translation = translation;
            cs.firePostChangeEvent(ce);
        } else {
            this.translation = translation;
        }
        this.firePropertyChange("translation", prevTranslation, translation);
        this.resizeAndValidate();
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public SequenceRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(SequenceRenderer renderer) throws ChangeVetoException {
        if (!this.isActive()) {
            this._setRenderer(renderer);
        }
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(RENDERER);
            ChangeEvent ce = new ChangeEvent(this, RENDERER, renderer, this.renderer);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._setRenderer(renderer);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._setRenderer(renderer);
        }
        this.resizeAndValidate();
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderingHints(RenderingHints hints) {
        RenderingHints prevHints = this.hints;
        this.hints = hints;
        this.firePropertyChange("hints", prevHints, hints);
    }

    public double sequenceToGraphics(int sequencePos) {
        return (double)(sequencePos - this.translation - 1) * this.scale;
    }

    public int graphicsToSequence(double graphicsPos) {
        return (int)(graphicsPos / this.scale) + this.translation + 1;
    }

    public int graphicsToSequence(Point point) {
        if (this.direction == 0) {
            return this.graphicsToSequence(point.getX());
        }
        return this.graphicsToSequence(point.getY());
    }

    public int getVisibleSymbolCount() {
        int visible;
        double totalBorders = this.leadingBorder.getSize() + this.trailingBorder.getSize() + this.rendererBorders;
        Insets insets = this.getInsets();
        if (this.direction == 0) {
            int width = this.getWidth() - insets.left - insets.right;
            if ((double)width <= totalBorders) {
                return 0;
            }
            visible = width - (int)totalBorders;
        } else {
            int height = this.getHeight() - insets.top - insets.bottom;
            if ((double)height <= totalBorders) {
                return 0;
            }
            visible = height - (int)totalBorders;
        }
        return Math.min(this.graphicsToSequence(visible), this.sequence.length());
    }

    public void paintComponent(Graphics g) {
        if (!this.isActive()) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(this.hints);
        AffineTransform prevTransform = g2.getTransform();
        Shape prevClip = g2.getClip();
        Insets insets = this.getInsets();
        if (this.isOpaque()) {
            g2.setPaint(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Rectangle2D.Double clip = new Rectangle2D.Double();
        if (this.direction == 0) {
            clip.x = this.renderer.getMinimumLeader(this);
            clip.y = 0.0;
            clip.width = this.sequenceToGraphics(this.getVisibleSymbolCount() + 1) + this.renderer.getMinimumTrailer(this);
            clip.height = this.renderer.getDepth(this);
            g2.translate(this.leadingBorder.getSize() + (double)insets.left, (double)insets.top);
        } else {
            clip.x = 0.0;
            clip.y = this.renderer.getMinimumLeader(this);
            clip.width = this.renderer.getDepth(this);
            clip.height = this.sequenceToGraphics(this.getVisibleSymbolCount() + 1) + this.renderer.getMinimumTrailer(this);
            g2.translate((double)insets.left, this.leadingBorder.getSize() + (double)insets.top);
        }
        g2.clip(clip);
        this.renderer.paint(g2, this);
        g2.setTransform(prevTransform);
        g2.setClip(prevClip);
    }

    public void resizeAndValidate() {
        Dimension d = null;
        if (!this.isActive()) {
            d = new Dimension(0, 0);
        } else {
            double width = this.sequenceToGraphics(this.getVisibleSymbolCount()) + this.rendererBorders;
            double depth = this.renderer.getDepth(this);
            d = this.direction == 0 ? new Dimension((int)Math.ceil(width), (int)Math.ceil(depth)) : new Dimension((int)Math.ceil(depth), (int)Math.ceil(width));
        }
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.revalidate();
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        cs.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(ct);
            cs.removeChangeListener(cl, ct);
        }
    }

    public boolean isUnchanging(ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        return cs.isUnchanging(ct);
    }

    public void addSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.addSequenceViewerListener(svl);
    }

    public void removeSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.removeSequenceViewerListener(svl);
    }

    public void addSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.addSequenceViewerMotionListener(svml);
    }

    public void removeSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.removeSequenceViewerMotionListener(svml);
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        if (this.changeSupport != null) {
            return this.changeSupport;
        }
        TranslatedSequencePanel translatedSequencePanel = this;
        synchronized (translatedSequencePanel) {
            if (this.changeSupport == null) {
                this.changeSupport = new ChangeSupport();
            }
            ChangeSupport changeSupport = this.changeSupport;
            return changeSupport;
        }
    }

    protected boolean hasListeners() {
        return this.changeSupport != null;
    }

    protected boolean isActive() {
        return this.sequence != null && this.renderer != null;
    }

    private void _setRenderer(SequenceRenderer renderer) {
        Changeable c;
        if (this.renderer != null && (class$org$biojava$utils$Changeable == null ? (class$org$biojava$utils$Changeable = TranslatedSequencePanel.class$("org.biojava.utils.Changeable")) : class$org$biojava$utils$Changeable).isInstance(this.renderer)) {
            c = (Changeable)((Object)this.renderer);
            c.removeChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.removeChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
        this.renderer = renderer;
        if (this.sequence != null) {
            this.rendererBorders = renderer.getMinimumLeader(this) + renderer.getMinimumTrailer(this);
        }
        if (renderer != null && (class$org$biojava$utils$Changeable == null ? (class$org$biojava$utils$Changeable = TranslatedSequencePanel.class$("org.biojava.utils.Changeable")) : class$org$biojava$utils$Changeable).isInstance(renderer)) {
            c = (Changeable)((Object)renderer);
            c.addChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.addChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

