/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.ConfigFile;
import org.biojava.bio.program.indexdb.PrimaryIDList;
import org.biojava.bio.program.indexdb.SecondaryFileAsList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;
import org.biojava.utils.SmallMap;

public class BioStoreFactory {
    public static final String STORE_NAME = "name";
    public static final String PRIMARY_KEY_NAME = "primary_namespace";
    public static final String KEYS = "secondary_namespaces";
    public static final AnnotationType META_DATA_TYPE;
    private File storeLoc;
    private String primaryKey;
    private Map keys = new SmallMap();
    private String name;
    static /* synthetic */ Class class$java$lang$String;

    public void setStoreName(String name) {
        this.name = name;
    }

    public String getStoreName() {
        return this.name;
    }

    public void setStoreLocation(File storeLoc) {
        this.storeLoc = storeLoc;
    }

    public File getStoreLocation() {
        return this.storeLoc;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void addKey(String keyName, int length) {
        this.keys.put(keyName, new Integer(length));
    }

    public void removeKey(String keyName) {
        this.keys.remove(keyName);
    }

    public BioStore createBioStore() throws BioException {
        try {
            if (this.storeLoc.exists()) {
                throw new BioException("Store location already exists. Delete first: " + this.storeLoc);
            }
            if (!this.keys.containsKey(this.primaryKey)) {
                throw new BioException("Primary key is not listed as a key: " + this.primaryKey);
            }
            this.storeLoc.mkdirs();
            ConfigFile ann = new ConfigFile(BioStoreFactory.makeConfigFile(this.storeLoc));
            ann.setProperty("index", "flat/1");
            if (this.name != null) {
                ann.setProperty(STORE_NAME, this.name);
            }
            ann.setProperty(PRIMARY_KEY_NAME, this.primaryKey);
            StringBuffer keyList = new StringBuffer();
            Iterator ki = this.keys.keySet().iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                int length = (Integer)this.keys.get(key);
                if (key.equals(this.primaryKey)) {
                    new PrimaryIDList(BioStoreFactory.makePrimaryKeyFile(this.storeLoc, key), BioStoreFactory.calculatePrimRecLen(length), null);
                    continue;
                }
                new SecondaryFileAsList(BioStoreFactory.makeSecondaryFile(this.storeLoc, key), BioStoreFactory.calculateSecRecLen(length, this.primaryKey, this.keys));
                if (keyList.length() != 0) {
                    keyList.append("\t");
                }
                keyList.append(key);
            }
            ann.setProperty(KEYS, keyList.substring(0));
            ann.commit();
            BioStore bStore = new BioStore(this.storeLoc, true, true);
            return bStore;
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Assertion Failure: Can't update annotation");
        }
        catch (IOException ioe) {
            throw new BioError(ioe, "Could not initialize store");
        }
    }

    public static File makeConfigFile(File storeLoc) throws IOException {
        return new File(storeLoc, "config.dat");
    }

    public static File makePrimaryKeyFile(File storeLoc, String key) throws IOException {
        return new File(storeLoc, "key_" + key + ".dat");
    }

    public static File makeSecondaryFile(File storeLoc, String key) throws IOException {
        return new File(storeLoc, "id_" + key + ".index");
    }

    public static int calculatePrimRecLen(int idLen) {
        return idLen + "\t".length() + 4 + "\t".length() + String.valueOf(Long.MAX_VALUE).length() + "\t".length() + String.valueOf(Integer.MAX_VALUE).length();
    }

    public static int calculateSecRecLen(int idLen, String primaryKey, Map keys) {
        int primLength = (Integer)keys.get(primaryKey);
        return idLen + "\t".length() + primLength;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            META_DATA_TYPE = new AnnotationType.Impl();
            META_DATA_TYPE.setDefaultConstraints(PropertyConstraint.ANY, CardinalityConstraint.ANY);
            META_DATA_TYPE.setConstraints(PRIMARY_KEY_NAME, new PropertyConstraint.ByClass(class$java$lang$String == null ? (class$java$lang$String = BioStoreFactory.class$("java.lang.String")) : class$java$lang$String), CardinalityConstraint.ONE);
            META_DATA_TYPE.setConstraints("index", new PropertyConstraint.ByClass(class$java$lang$String == null ? (class$java$lang$String = BioStoreFactory.class$("java.lang.String")) : class$java$lang$String), CardinalityConstraint.ONE);
            META_DATA_TYPE.setConstraints(KEYS, new PropertyConstraint.ByClass(class$java$lang$String == null ? (class$java$lang$String = BioStoreFactory.class$("java.lang.String")) : class$java$lang$String), CardinalityConstraint.ONE);
            META_DATA_TYPE.setConstraints(STORE_NAME, new PropertyConstraint.ByClass(class$java$lang$String == null ? (class$java$lang$String = BioStoreFactory.class$("java.lang.String")) : class$java$lang$String), CardinalityConstraint.ZERO_OR_ONE);
        }
        catch (Exception e) {
            throw new NestedError(e);
        }
    }
}

