/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.SummaryLineHelperIF;
import org.xml.sax.SAXException;

final class GCGBlastSummaryLineHelper
implements SummaryLineHelperIF {
    private StringBuffer oHitDescription;
    private String previousHitID;
    private String previousScore;
    private String previousEValue;

    public void parse(String poLine, HashMap poMap, BlastLikeVersionSupport poVersion) throws SAXException {
        boolean firstLine;
        int iGrab = 2;
        if (poLine.startsWith("!")) {
            firstLine = false;
        } else {
            firstLine = true;
            this.oHitDescription = new StringBuffer();
        }
        StringTokenizer oSt = new StringTokenizer(poLine);
        if (!firstLine) {
            int iCount = oSt.countTokens() - iGrab - 1;
            String hitID = oSt.nextToken();
            poMap.put("hitId", hitID);
            int i = 0;
            while (i < iCount) {
                this.oHitDescription.append(oSt.nextToken());
                this.oHitDescription.append(" ");
                ++i;
            }
            poMap.put("hitDescription", this.oHitDescription.substring(0));
            if (hitID.equals(this.previousHitID)) {
                System.out.println("curr: " + hitID + " prev: " + this.previousHitID);
                poMap.put("score", this.previousScore);
                poMap.put("expectValue", this.previousEValue);
            } else {
                this.previousHitID = hitID;
                this.previousScore = oSt.nextToken();
                this.previousEValue = oSt.nextToken();
                poMap.put("score", this.previousScore);
                poMap.put("expectValue", this.previousEValue);
            }
        } else {
            this.oHitDescription.setLength(0);
            this.oHitDescription.append(oSt.nextToken());
            this.oHitDescription.append(" ");
        }
    }
}

