/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeAlignmentSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.HSPSummaryHelper;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class HitSectionSAXParser
extends AbstractNativeAppSAXParser {
    private BlastLikeAlignmentSAXParser oAlignmentParser;
    private BlastLikeVersionSupport oVersion;
    private BufferedReader oContents;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private char[] aoChars;
    private char[] aoLineSeparator;
    private String oGlobalEndSignal;
    private ArrayList oBuffer = new ArrayList();
    private ArrayList oAlignmentBuffer = new ArrayList();
    private StringBuffer oStringBuffer = new StringBuffer();
    private StringBuffer oDescription = new StringBuffer();
    private String oLine;
    private HashMap oMap = new HashMap();
    private String[] aoKeys;
    private String[] aoArrayType = new String[1];
    private boolean tClearOfWarning = true;
    private static final int STARTUP = 0;
    private static final int DONE = 1;
    private static final int CAPTURING_HIT_SUMMARY = 2;
    private static final int IN_HSP_COLLECTION = 3;
    private static final int ON_FIRST_HSP = 4;
    private static final int IN_HSP_SUMMARY = 5;
    private static final int IN_ALIGNMENT = 6;

    HitSectionSAXParser(BlastLikeVersionSupport poVersion, String poNamespacePrefix) {
        this.oVersion = poVersion;
        this.setNamespacePrefix(poNamespacePrefix);
        this.addPrefixMapping("biojava", "http://www.biojava.org");
        this.changeState(0);
        this.aoLineSeparator = System.getProperty("line.separator").toCharArray();
    }

    public void parse(BufferedReader poContents, String poLine, String poEndSignal) throws SAXException {
        this.oLine = null;
        this.oContents = poContents;
        this.oGlobalEndSignal = poEndSignal;
        if (!poLine.startsWith(">")) {
            return;
        }
        try {
            this.oLine = poLine;
            while (this.oLine != null && !this.oLine.trim().startsWith(this.oGlobalEndSignal) && this.iState != 1) {
                this.interpret(this.oLine);
                if (this.oLine.trim().startsWith(this.oGlobalEndSignal)) {
                    this.changeState(1);
                    break;
                }
                this.oLine = this.oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interupted");
        }
    }

    private void interpret(String poLine) throws SAXException {
        if (poLine.startsWith(">")) {
            this.oStringBuffer.setLength(0);
            this.oStringBuffer.append(poLine.substring(1));
            this.changeState(2);
            return;
        }
        if (this.iState == 2) {
            if (poLine.trim().startsWith("Length =")) {
                StringTokenizer oSt = new StringTokenizer(poLine);
                int iTmpTokenCount = oSt.countTokens() - 1;
                int i = 0;
                while (i < iTmpTokenCount) {
                    oSt.nextToken();
                    ++i;
                }
                String oLength = oSt.nextToken();
                this.oAtts.clear();
                this.oAttQName.setQName("sequenceLength");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oLength);
                this.startElement(new QName(this, this.prefix("Hit")), this.oAtts);
                oSt = new StringTokenizer(this.oStringBuffer.substring(0));
                int iCount = oSt.countTokens();
                String oId = oSt.nextToken();
                this.oAtts.clear();
                this.oAttQName.setQName("id");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oId);
                this.oAttQName.setQName("metaData");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
                this.startElement(new QName(this, this.prefix("HitId")), this.oAtts);
                this.endElement(new QName(this, this.prefix("HitId")));
                this.oDescription.setLength(0);
                if (iCount > 0) {
                    while (oSt.hasMoreTokens()) {
                        this.oDescription.append(oSt.nextToken() + " ");
                    }
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("HitDescription")), this.oAtts);
                    this.aoChars = this.oDescription.substring(0).trim().toCharArray();
                    this.characters(this.aoChars, 0, this.aoChars.length);
                    this.endElement(new QName(this, this.prefix("HitDescription")));
                }
                this.changeState(3);
                return;
            }
            this.oStringBuffer.append(" " + poLine.trim());
            return;
        }
        if (this.iState == 3 && poLine.trim().startsWith("Score")) {
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("HSPCollection")), this.oAtts);
            this.firstHSPEvent(poLine);
            this.endElement(new QName(this, this.prefix("HSPCollection")));
            this.endElement(new QName(this, this.prefix("Hit")));
            this.changeState(2);
        }
    }

    private void firstHSPEvent(String poLine) throws SAXException {
        this.changeState(4);
        try {
            this.oLine = poLine;
            while (this.oLine != null && !this.oLine.trim().startsWith(">") && !this.oLine.trim().startsWith(this.oGlobalEndSignal)) {
                this.interpretHSP(this.oLine);
                this.oLine = this.oContents.readLine();
            }
            if (this.iState != 4) {
                this.outputHSPInfo();
                this.endElement(new QName(this, this.prefix("HSP")));
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interupted");
        }
        if (this.oLine.startsWith(">")) {
            this.oStringBuffer.setLength(0);
            this.oStringBuffer.append(this.oLine.substring(1));
            return;
        }
        if (this.oLine.trim().startsWith(this.oGlobalEndSignal)) {
            this.changeState(1);
            return;
        }
    }

    private void interpretHSP(String poLine) throws SAXException {
        if (!this.tClearOfWarning) {
            if (poLine.trim().equals("")) {
                this.tClearOfWarning = true;
            }
            return;
        }
        if (poLine.trim().toLowerCase().startsWith("minus strand")) {
            return;
        }
        if (poLine.trim().toLowerCase().startsWith("plus strand")) {
            return;
        }
        if (poLine.trim().toLowerCase().startsWith("warning")) {
            this.tClearOfWarning = false;
            return;
        }
        if (poLine.trim().startsWith("Score")) {
            if (this.iState != 4) {
                this.outputHSPInfo();
                this.endElement(new QName(this, this.prefix("HSP")));
            }
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("HSP")), this.oAtts);
            this.oStringBuffer.setLength(0);
            this.oStringBuffer.append(poLine);
            this.oBuffer.clear();
            this.oBuffer.add(poLine);
            this.changeState(5);
            return;
        }
        if (this.iState == 5) {
            if (poLine.startsWith("Query:")) {
                HSPSummaryHelper.parse(this.oStringBuffer.substring(0), this.oMap, this.oVersion);
                this.changeState(6);
                this.oAlignmentBuffer.clear();
                this.oAlignmentBuffer.add(poLine);
                return;
            }
            if (poLine.trim().equals("")) {
                return;
            }
            this.oBuffer.add(poLine);
            this.oStringBuffer.append(", ");
            this.oStringBuffer.append(poLine);
            return;
        }
        if (this.iState == 6) {
            if (poLine.trim().equals("")) {
                return;
            }
            this.oAlignmentBuffer.add(poLine);
            return;
        }
    }

    private void outputHSPInfo() throws SAXException {
        this.aoKeys = this.oMap.keySet().toArray(this.aoArrayType);
        this.oAtts.clear();
        int i = 0;
        while (i < this.aoKeys.length) {
            if (this.aoKeys[i].equals("queryFrame") || this.aoKeys[i].equals("hitFrame") || this.aoKeys[i].equals("queryStrand") || this.aoKeys[i].equals("hitStrand")) {
                this.oAttQName.setQName(this.aoKeys[i]);
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", (String)this.oMap.get(this.aoKeys[i]));
            } else {
                this.oAttQName.setQName(this.aoKeys[i]);
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", (String)this.oMap.get(this.aoKeys[i]));
            }
            ++i;
        }
        this.startElement(new QName(this, this.prefix("HSPSummary")), this.oAtts);
        this.oAtts.clear();
        this.oAttQName.setQName("xml:space");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "preserve");
        this.startElement(new QName(this, this.prefix("RawOutput")), this.oAtts);
        int iTmpBufferSize = this.oBuffer.size();
        int i2 = 0;
        while (i2 < iTmpBufferSize) {
            this.aoChars = ((String)this.oBuffer.get(i2)).toCharArray();
            this.characters(this.aoChars, 0, this.aoChars.length);
            this.characters(this.aoLineSeparator, 0, 1);
            ++i2;
        }
        this.endElement(new QName(this, this.prefix("RawOutput")));
        this.endElement(new QName(this, this.prefix("HSPSummary")));
        this.oAlignmentParser = new BlastLikeAlignmentSAXParser(this.getNamespacePrefix());
        this.oAlignmentParser.setContentHandler(this.oHandler);
        this.oAlignmentParser.parse(this.oAlignmentBuffer);
    }
}

