/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.program.ssbind.AlphabetResolver;
import org.biojava.bio.program.ssbind.AnnotationFactory;
import org.biojava.bio.program.ssbind.ViewSequenceFactory;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.homol.Homology;
import org.biojava.bio.seq.homol.HomologyFeature;
import org.biojava.bio.seq.homol.SimpleHomology;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.utils.ChangeVetoException;

public class BlastLikeHomologyBuilder
extends ViewSequenceFactory
implements SearchContentHandler {
    public static final String HOMOLOGY_FEATURE_TYPE = "homology";
    private String queryID;
    private String databaseID;
    private Map resultData;
    private Map hitData;
    private Map subHitData;
    private AlphabetResolver alphaResolver;
    private SymbolTokenization tokenParser;
    private StringBuffer tokenBuffer;
    private List homologies;
    private boolean moreSearchesAvailable = false;
    private List target;

    public BlastLikeHomologyBuilder(List target) {
        this.target = target;
        this.resultData = new HashMap();
        this.hitData = new HashMap();
        this.subHitData = new HashMap();
        this.queryViewCache = new HashMap();
        this.subjectViewCache = new HashMap();
        this.tokenBuffer = new StringBuffer(1024);
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public void setDatabaseID(String databaseID) {
        this.databaseID = databaseID;
    }

    public boolean getMoreSearches() {
        return this.moreSearchesAvailable;
    }

    public void setMoreSearches(boolean value) {
        this.moreSearchesAvailable = value;
    }

    public void startSearch() {
        this.subjectViewCache.clear();
        this.homologies = new ArrayList();
    }

    public void endSearch() {
        this.target.addAll(this.homologies);
    }

    public void startHeader() {
        this.resultData.clear();
    }

    public void endHeader() {
    }

    public void startHit() {
        this.hitData.clear();
        this.subHitData.clear();
    }

    public void endHit() {
    }

    public void startSubHit() {
    }

    public void endSubHit() {
        try {
            this.homologies.add(this.makeHomology());
        }
        catch (BioException be) {
            System.err.println("Failed to build Homology:");
            be.printStackTrace();
        }
    }

    public void addSearchProperty(Object key, Object value) {
        this.resultData.put(key, value);
    }

    public void addHitProperty(Object key, Object value) {
        this.hitData.put(key, value);
    }

    public void addSubHitProperty(Object key, Object value) {
        this.subHitData.put(key, value);
    }

    private Homology makeHomology() throws BioException {
        int swap;
        this.subHitData.putAll(this.resultData);
        this.subHitData.putAll(this.hitData);
        if (this.tokenParser == null) {
            String identifier;
            if (this.subHitData.containsKey("hitSequenceType")) {
                identifier = (String)this.subHitData.get("hitSequenceType");
            } else if (this.subHitData.containsKey("program")) {
                identifier = (String)this.subHitData.get("program");
            } else {
                throw new BioException("Failed to determine sequence type");
            }
            FiniteAlphabet alpha = AlphabetResolver.resolveAlphabet(identifier);
            this.tokenParser = alpha.getTokenization("token");
        }
        StrandedFeature.Strand qStrand = StrandedFeature.POSITIVE;
        StrandedFeature.Strand sStrand = StrandedFeature.POSITIVE;
        if (this.subHitData.containsKey("queryStrand") && this.subHitData.get("queryStrand").equals("minus")) {
            qStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectStrand") && this.subHitData.get("subjectStrand").equals("minus")) {
            sStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("queryFrame") && ((String)this.subHitData.get("queryFrame")).startsWith("minus")) {
            qStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectFrame") && ((String)this.subHitData.get("subjectFrame")).startsWith("minus")) {
            sStrand = StrandedFeature.NEGATIVE;
        }
        int qStart = Integer.parseInt((String)this.subHitData.get("querySequenceStart"));
        int qEnd = Integer.parseInt((String)this.subHitData.get("querySequenceEnd"));
        int sStart = Integer.parseInt((String)this.subHitData.get("subjectSequenceStart"));
        int sEnd = Integer.parseInt((String)this.subHitData.get("subjectSequenceEnd"));
        if (qStrand == StrandedFeature.NEGATIVE) {
            swap = qStart;
            qStart = qEnd;
            qEnd = swap;
        }
        if (sStrand == StrandedFeature.NEGATIVE) {
            swap = sStart;
            sStart = sEnd;
            sEnd = swap;
        }
        String subjectID = (String)this.subHitData.get("HitId");
        Sequence queryView = this.makeQueryViewSequence(this.queryID);
        Sequence subjectView = this.makeSubjectViewSequence(subjectID);
        SimpleHomology homology = new SimpleHomology();
        HashMap<Feature, SimpleSymbolList> labelMap = new HashMap<Feature, SimpleSymbolList>();
        try {
            String source = "unknown";
            if (this.subHitData.containsKey("program")) {
                source = (String)this.subHitData.get("program");
            }
            this.tokenBuffer.setLength(0);
            this.tokenBuffer.append((String)this.subHitData.get("querySequence"));
            HomologyFeature.Template qt = new HomologyFeature.Template();
            qt.type = HOMOLOGY_FEATURE_TYPE;
            qt.source = source;
            qt.location = new RangeLocation(qStart, qEnd);
            qt.strand = qStrand;
            qt.annotation = AnnotationFactory.makeAnnotation(this.subHitData);
            qt.homology = homology;
            labelMap.put(queryView.createFeature(qt), new SimpleSymbolList(this.tokenParser, this.tokenBuffer.substring(0)));
            this.tokenBuffer.setLength(0);
            this.tokenBuffer.append((String)this.subHitData.get("subjectSequence"));
            HomologyFeature.Template st = new HomologyFeature.Template();
            st.type = HOMOLOGY_FEATURE_TYPE;
            st.source = source;
            st.location = new RangeLocation(sStart, sEnd);
            st.strand = sStrand;
            st.annotation = AnnotationFactory.makeAnnotation(this.subHitData);
            st.homology = homology;
            labelMap.put(subjectView.createFeature(st), new SimpleSymbolList(this.tokenParser, this.tokenBuffer.substring(0)));
            SimpleAlignment a = new SimpleAlignment(labelMap);
            homology.setAlignment(a);
            return homology;
        }
        catch (ChangeVetoException cve) {
            throw new BioException(cve, "Failed to create HomologyFeature");
        }
    }
}

