/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import org.biojava.bio.program.tagvalue.TagValue;
import org.biojava.bio.program.tagvalue.TagValueParser;

public class LineSplitParser
implements TagValueParser,
Cloneable {
    public static final LineSplitParser EMBL = new LineSplitParser();
    public static final LineSplitParser GENBANK;
    private String endOfRecord = null;
    private int splitOffset;
    private boolean trimTag;
    private boolean trimValue;
    private boolean continueOnEmptyTag;
    private boolean mergeSameTag;
    private String tag;

    public void setEndOfRecord(String endOfRecord) {
        this.endOfRecord = endOfRecord;
    }

    public String getEndOfRecord() {
        return this.endOfRecord;
    }

    public void setSplitOffset(int splitOffset) {
        this.splitOffset = splitOffset;
    }

    public int getSplitOffset() {
        return this.splitOffset;
    }

    public void setTrimTag(boolean trimTag) {
        this.trimTag = trimTag;
    }

    public boolean getTrimTag() {
        return this.trimTag;
    }

    public void setTrimValue(boolean trimValue) {
        this.trimValue = trimValue;
    }

    public boolean getTrimValue() {
        return this.trimValue;
    }

    public void setContinueOnEmptyTag(boolean continueOnEmptyTag) {
        this.continueOnEmptyTag = continueOnEmptyTag;
    }

    public boolean getContinueOnEmptyTag() {
        return this.continueOnEmptyTag;
    }

    public void setMergeSameTag(boolean mergeSameTag) {
        this.mergeSameTag = mergeSameTag;
    }

    public boolean getMergeSameTag() {
        return this.mergeSameTag;
    }

    public TagValue parse(Object o) {
        String line = o.toString();
        if (this.endOfRecord != null && (this.endOfRecord == "" ? line.equals("") : line.startsWith(this.endOfRecord))) {
            return null;
        }
        int length = line.length();
        String tag = length > this.splitOffset ? line.substring(0, this.splitOffset) : line;
        if (this.trimTag) {
            tag = tag.trim();
        }
        String value = length > this.splitOffset ? line.substring(this.splitOffset) : "";
        if (this.trimValue) {
            value = value.trim();
        }
        if (this.continueOnEmptyTag && tag.length() == 0) {
            return new TagValue(this.tag, value, false);
        }
        if (this.mergeSameTag && tag.equals(this.tag)) {
            return new TagValue(tag, value, false);
        }
        this.tag = tag;
        return new TagValue(this.tag, value, true);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        EMBL.setEndOfRecord("//");
        EMBL.setSplitOffset(5);
        EMBL.setTrimTag(true);
        EMBL.setTrimValue(false);
        EMBL.setContinueOnEmptyTag(false);
        EMBL.setMergeSameTag(true);
        GENBANK = new LineSplitParser();
        GENBANK.setEndOfRecord("///");
        GENBANK.setSplitOffset(12);
        GENBANK.setTrimTag(true);
        GENBANK.setTrimValue(false);
        GENBANK.setContinueOnEmptyTag(true);
        GENBANK.setMergeSameTag(false);
    }
}

