/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.xff;

import java.io.IOException;
import java.util.Iterator;
import org.biojava.bio.program.xff.BasicXFFHelper;
import org.biojava.bio.program.xff.XFFHelper;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.xml.XMLWriter;

public class XFFWriter {
    private XFFHelper helper;

    public XFFWriter() {
        this.helper = new BasicXFFHelper();
    }

    public XFFWriter(XFFHelper h) {
        this.helper = h;
    }

    private void emitFeature_xff(Feature f, XMLWriter xw) throws IOException {
        if (f instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)f;
            String strand = cf.getStrand() == StrandedFeature.POSITIVE ? "+" : "-";
            xw.openTag("componentFeature");
            xw.attribute("strand", strand);
            String id = this.helper.getFeatureID(cf);
            if (id != null) {
                xw.attribute("id", id);
            }
            this.emitFeature_xff_standardBits(f, xw);
            xw.openTag("componentID");
            xw.print(cf.getComponentSequence().getName());
            xw.closeTag("componentID");
            xw.openTag("componentLocation");
            this.emitLocation_xff(cf.getComponentLocation(), xw);
            xw.closeTag("componentLocation");
            this.emitDetails(xw, cf);
            xw.closeTag("componentFeature");
        } else if (f instanceof StrandedFeature && ((StrandedFeature)f).getStrand() != StrandedFeature.UNKNOWN) {
            StrandedFeature sf = (StrandedFeature)f;
            String strand = sf.getStrand() == StrandedFeature.POSITIVE ? "+" : "-";
            xw.openTag("strandedFeature");
            xw.attribute("strand", strand);
            String id = this.helper.getFeatureID(sf);
            if (id != null) {
                xw.attribute("id", id);
            }
            this.emitFeature_xff_standardBits(f, xw);
            if (f.countFeatures() > 0) {
                this.emitFeature_xff_featureSet(f, xw, false);
            }
            this.emitDetails(xw, f);
            xw.closeTag("strandedFeature");
        } else {
            xw.openTag("feature");
            String id = this.helper.getFeatureID(f);
            if (id != null) {
                xw.attribute("id", id);
            }
            this.emitFeature_xff_standardBits(f, xw);
            if (f.countFeatures() > 0) {
                this.emitFeature_xff_featureSet(f, xw, false);
            }
            this.emitDetails(xw, f);
            xw.closeTag("feature");
        }
    }

    private void emitDetails(XMLWriter xw, Feature f) throws IOException {
        xw.openTag("details");
        this.helper.writeDetails(xw, f);
        xw.closeTag("details");
    }

    private void emitFeature_xff_standardBits(Feature f, XMLWriter xw) throws IOException {
        xw.openTag("type");
        xw.print(f.getType());
        xw.closeTag("type");
        xw.openTag("source");
        xw.print(f.getSource());
        xw.closeTag("source");
        xw.openTag("location");
        this.emitLocation_xff(f.getLocation(), xw);
        xw.closeTag("location");
    }

    private void emitLocation_xff(Location l, XMLWriter xw) throws IOException {
        Iterator i = l.blockIterator();
        while (i.hasNext()) {
            Location block = (Location)i.next();
            xw.openTag("span");
            xw.attribute("start", "" + block.getMin());
            xw.attribute("stop", "" + block.getMax());
            xw.closeTag("span");
        }
    }

    private void emitFeature_xff_featureSet(FeatureHolder fh, XMLWriter xw, boolean explicitNamespace) throws IOException {
        xw.openTag("featureSet");
        if (explicitNamespace) {
            xw.attribute("xmlns", "http://www.bioxml.org/2000/xff");
            xw.attribute("xmlns:biojava", "http://www.biojava.org/2001/xff-biojava");
        }
        Iterator fi = fh.features();
        while (fi.hasNext()) {
            Feature f = (Feature)fi.next();
            this.emitFeature_xff(f, xw);
        }
        xw.closeTag("featureSet");
    }

    public void writeFeatureSet(FeatureHolder fh, XMLWriter xw) throws IOException {
        this.emitFeature_xff_featureSet(fh, xw, true);
    }
}

