/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.xml;

import java.util.Stack;
import org.xml.sax.Attributes;

public class BaseXMLWriter {
    private Stack oElementStack = new Stack();
    private StringBuffer oStr = new StringBuffer();
    private StringBuffer oIndent = new StringBuffer();
    private String oLineSeparator;
    private StringBuffer oSpaceStore = new StringBuffer();
    private boolean tLastWritePCData;
    private boolean tLastWriteStartElement;
    private String oAttName;
    private String oAttValue;
    private static final String oLt = "<";
    private static final String oGt = ">";
    private static final String oLtS = "</";
    private static final String oGtS = "/>";
    private static final String oSp = " ";
    private static final String oEqQuote = "=\"";
    private static final String oQuote = "\"";
    static final String oHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public BaseXMLWriter() {
        this.oLineSeparator = System.getProperty("line.separator");
        this.oIndent.setLength(0);
        this.tLastWritePCData = false;
        this.tLastWriteStartElement = false;
    }

    private void decreaseIndent() {
        this.oIndent.setLength(this.oIndent.length() - 2);
    }

    public String endElement() {
        this.decreaseIndent();
        this.oStr.setLength(0);
        if (!this.tLastWriteStartElement && !this.tLastWritePCData) {
            this.oStr.append(this.nl());
            this.oStr.append(this.indent());
        }
        this.oStr.append(oLtS);
        this.oStr.append((String)this.oElementStack.pop());
        this.oStr.append(oGt);
        this.tLastWritePCData = false;
        this.tLastWriteStartElement = false;
        return this.oStr.substring(0);
    }

    private void increaseIndent() {
        this.oIndent.append("  ");
    }

    public String indent() {
        return this.oIndent.substring(0);
    }

    public String nl() {
        return this.oLineSeparator;
    }

    public String startElement(String string) {
        this.oElementStack.push(string);
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append(oLt);
        this.oStr.append(string);
        this.oStr.append(oGt);
        this.increaseIndent();
        this.tLastWritePCData = false;
        this.tLastWriteStartElement = true;
        return this.oStr.substring(0);
    }

    public String startElement(String string, Attributes attributes) {
        this.oElementStack.push(string);
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append(oLt);
        this.oStr.append(string);
        int i = 0;
        this.oSpaceStore.setLength(0);
        this.oSpaceStore.append(this.indent());
        i = 0;
        while (i <= string.length()) {
            this.oSpaceStore.append(oSp);
            ++i;
        }
        i = 0;
        while (i < attributes.getLength() - 1) {
            this.oAttName = attributes.getQName(i);
            this.oAttValue = attributes.getValue(i);
            this.oStr.append(oSp);
            if (i > 0) {
                this.oStr.append(this.oSpaceStore.substring(0));
            }
            this.oStr.append(this.oAttName);
            this.oStr.append(oEqQuote);
            this.oStr.append(this.oAttValue);
            this.oStr.append(oQuote);
            this.oStr.append(this.nl());
            ++i;
        }
        this.oAttName = attributes.getQName(i);
        this.oAttValue = attributes.getValue(i);
        this.oStr.append(oSp);
        if (attributes.getLength() > 1) {
            this.oStr.append(this.oSpaceStore.substring(0));
        }
        this.oStr.append(this.oAttName);
        this.oStr.append(oEqQuote);
        this.oStr.append(this.oAttValue);
        this.oStr.append(oQuote);
        this.oStr.append(oGt);
        this.increaseIndent();
        this.tLastWritePCData = false;
        this.tLastWriteStartElement = true;
        return this.oStr.substring(0);
    }

    public String writeEmptyElement(String string) {
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append(oLt);
        this.oStr.append(string);
        this.oStr.append(oGtS);
        this.tLastWritePCData = false;
        this.tLastWriteStartElement = false;
        return this.oStr.substring(0);
    }

    public String writeEmptyElement(String string, Attributes attributes) {
        this.oStr.setLength(0);
        if (!this.tLastWritePCData) {
            this.oStr.append(this.nl());
        }
        this.oStr.append(this.indent());
        this.oStr.append(oLt);
        this.oStr.append(string);
        int i = 0;
        while (i < attributes.getLength()) {
            this.oAttName = attributes.getQName(i);
            this.oAttValue = attributes.getValue(i);
            this.oStr.append(oSp);
            this.oStr.append(this.oAttName);
            this.oStr.append(oEqQuote);
            this.oStr.append(this.oAttValue);
            this.oStr.append(oQuote);
            ++i;
        }
        this.oStr.append(oGtS);
        this.tLastWritePCData = false;
        this.tLastWriteStartElement = false;
        return this.oStr.substring(0);
    }

    public String writeHeader() {
        this.oStr.setLength(0);
        this.oStr.append(oHeader);
        this.tLastWritePCData = false;
        return this.oStr.substring(0);
    }

    public String writePCData(String poPCData) {
        this.oStr.setLength(0);
        this.oStr.append(poPCData);
        this.tLastWritePCData = true;
        this.tLastWriteStartElement = false;
        return this.oStr.substring(0);
    }
}

