/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;
import org.biojava.utils.math.BinarySearch;
import org.biojava.utils.math.ComputeObject;

public class IsoelectricPointCalc {
    public static double PK_NH2 = 8.56;
    public static double PK_COOH = 3.56;
    private static Map pKCache = new HashMap();
    private static ComputeObject computeObj = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IsoelectricPointCalc() {
        SymbolPropertyTable pKTable = ProteinTools.getSymbolPropertyTable("pK");
        Iterator aaSyms = ProteinTools.getAlphabet().iterator();
        try {
            while (true) {
                if (!aaSyms.hasNext()) {
                    return;
                }
                Symbol sym = (Symbol)aaSyms.next();
                try {
                    double pK = pKTable.getDoubleValue(sym);
                    if (!(Math.abs(pK) > 0.01)) continue;
                    pKCache.put(sym, new Double(pK));
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
            }
        }
        catch (IllegalSymbolException ise) {
            ise.printStackTrace();
        }
    }

    public double getPI(SymbolList peptide, boolean hasFreeNTerm, boolean hasFreeCTerm) throws IllegalAlphabetException, BioException {
        if (peptide.getAlphabet() == ProteinTools.getTAlphabet() || peptide.getAlphabet() == ProteinTools.getAlphabet()) {
            ChargeCalculator computeObj = new ChargeCalculator(peptide, hasFreeNTerm, hasFreeCTerm);
            double pI = BinarySearch.solve(1.0, 13.0, 0.001, computeObj);
            return pI;
        }
        throw new IllegalAlphabetException();
    }

    public class ChargeCalculator
    implements ComputeObject {
        Map counts = null;
        boolean hasFreeNTerm = true;
        boolean hasFreeCTerm = true;

        private ChargeCalculator(SymbolList peptide, boolean hasFreeNTerm, boolean hasFreeCTerm) {
            this.counts = this.residueCount(peptide);
            this.hasFreeNTerm = hasFreeNTerm;
            this.hasFreeCTerm = hasFreeCTerm;
        }

        private ChargeCalculator(SymbolList peptide) {
            this.counts = this.residueCount(peptide);
        }

        private Map residueCount(SymbolList peptide) {
            Iterator residues = peptide.iterator();
            HashMap<Symbol, Integer> symbolCounts = new HashMap<Symbol, Integer>();
            while (residues.hasNext()) {
                Symbol sym = (Symbol)residues.next();
                if (!pKCache.containsKey(sym)) continue;
                Integer currCount = (Integer)symbolCounts.get(sym);
                if (currCount != null) {
                    int currCountAsInt = currCount;
                    symbolCounts.put(sym, new Integer(++currCountAsInt));
                    continue;
                }
                symbolCounts.put(sym, new Integer(1));
            }
            return symbolCounts;
        }

        public double compute(double pH) {
            double charge = 0.0;
            Iterator aaI = this.counts.keySet().iterator();
            while (aaI.hasNext()) {
                double cr;
                Symbol sym = (Symbol)aaI.next();
                Double value = (Double)pKCache.get(sym);
                if (value == null) continue;
                double pK = value;
                double count = ((Integer)this.counts.get(sym)).intValue();
                if (pK > 0.0) {
                    cr = Math.pow(10.0, pK - pH);
                    charge += count * cr / (cr + 1.0);
                    continue;
                }
                cr = Math.pow(10.0, pH + pK);
                charge -= count * cr / (cr + 1.0);
            }
            if (this.hasFreeNTerm) {
                double cr = Math.pow(10.0, PK_NH2 - pH);
                charge += cr / (1.0 + cr);
            }
            if (this.hasFreeCTerm) {
                double cr = Math.pow(10.0, pH - PK_COOH);
                charge -= cr / (1.0 + cr);
            }
            return charge;
        }
    }
}

