/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Protease {
    static Document doc = null;
    public static String TRYPSIN;
    public static String LYS_C;
    public static String Arg_C;
    public static String ASP_N;
    public static String GLU_C_BICARB;
    public static String GLU_C_PHOS;
    public static String CHYMOTRYP;
    public static String CNBr;
    private SymbolList cleavageResidues;
    private SymbolList notCleaveResidues;
    private boolean endoProtease = true;
    static /* synthetic */ Class class$org$biojava$bio$proteomics$Protease;

    public Protease(SymbolList cleaveRes, boolean endoProtease, SymbolList notCleaveRes) throws IllegalSymbolException, BioException {
        this.cleavageResidues = cleaveRes;
        this.endoProtease = endoProtease;
        this.notCleaveResidues = notCleaveRes;
    }

    public Protease(String cleaveRes, boolean endoProtease, String notCleaveRes) throws IllegalSymbolException, BioException {
        this.cleavageResidues = this.createSymbolList(cleaveRes);
        this.endoProtease = endoProtease;
        this.notCleaveResidues = this.createSymbolList(notCleaveRes);
    }

    public Protease(String cleavageRes, boolean endoProtease) throws IllegalSymbolException, BioException {
        this.cleavageResidues = this.createSymbolList(cleavageRes);
        this.endoProtease = endoProtease;
        this.notCleaveResidues = this.createSymbolList("");
    }

    public SymbolList getCleaveageResidues() {
        return this.cleavageResidues;
    }

    public SymbolList getNotCleaveResidues() {
        return this.notCleaveResidues;
    }

    public boolean isEndoProtease() {
        return this.endoProtease;
    }

    public static String[] getProteaseList() {
        ArrayList<String> list = new ArrayList<String>();
        NodeList children = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            Node cnode = children.item(i);
            if (cnode instanceof Element && (child = (Element)cnode).getNodeName().equals("protease")) {
                String name = child.getAttribute("name");
                list.add(name);
            }
            ++i;
        }
        String[] names = new String[list.size()];
        return list.toArray(names);
    }

    public static Protease getProteaseByName(String proteaseName) throws IllegalSymbolException, BioException {
        Protease protease = null;
        NodeList children = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            Node cnode = children.item(i);
            if (cnode instanceof Element && (child = (Element)cnode).getNodeName().equals("protease") && child.getAttribute("name").equals(proteaseName)) {
                String cleavRes = null;
                String exceptRes = null;
                boolean endo = false;
                NodeList proteaseNodes = child.getChildNodes();
                int j = 0;
                while (j < proteaseNodes.getLength()) {
                    Node cnode2 = proteaseNodes.item(j);
                    if (cnode2 instanceof Element) {
                        Element el = (Element)cnode2;
                        String name = el.getNodeName();
                        String content = el.getFirstChild().getNodeValue();
                        if (name.equals("cleaveRes")) {
                            cleavRes = content.trim();
                        } else if (name.equals("exceptRes")) {
                            exceptRes = content.trim();
                        } else if (name.equals("endo")) {
                            endo = new Boolean(content);
                        }
                    }
                    ++j;
                }
                if (cleavRes != null && exceptRes != null) {
                    protease = new Protease(cleavRes, endo, exceptRes);
                } else if (cleavRes != null && exceptRes == null) {
                    protease = new Protease(cleavRes, endo);
                }
            }
            ++i;
        }
        return protease;
    }

    private SymbolList createSymbolList(String seq) throws IllegalSymbolException, BioException {
        FiniteAlphabet prot = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
        SymbolTokenization tokenization = prot.getTokenization("token");
        SimpleSymbolList sList = new SimpleSymbolList(tokenization, seq);
        return sList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InputStream tablesStream = (class$org$biojava$bio$proteomics$Protease == null ? (class$org$biojava$bio$proteomics$Protease = Protease.class$("org.biojava.bio.proteomics.Protease")) : class$org$biojava$bio$proteomics$Protease).getClassLoader().getResourceAsStream("org/biojava/bio/proteomics/ProteaseManager.xml");
            if (tablesStream == null) {
                throw new BioException("Couldn't locate ProteaseManager.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(is);
        }
        catch (MissingResourceException mre) {
            System.err.println(mre.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TRYPSIN = "Trypsin";
        LYS_C = "Lys-C";
        Arg_C = "Arg-C";
        ASP_N = "Asp-N";
        GLU_C_BICARB = "Glu-C-bicarbonate";
        GLU_C_PHOS = "Glu-C-phosphate";
        CHYMOTRYP = "Chymostrypsin";
        CNBr = "CNBr";
    }
}

