/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ObjectUtil;

public class SequenceDBSearchResult
extends AbstractChangeable
implements SeqSimilaritySearchResult,
Annotatable {
    protected transient Annotatable.AnnotationForwarder annotationForwarder;
    private SymbolList querySequence;
    private SequenceDB sequenceDB;
    private Map searchParameters;
    private Annotation annotation;
    private List hits;
    private int hc;
    private boolean hcCalc;

    public SequenceDBSearchResult(SymbolList querySequence, SequenceDB sequenceDB, Map searchParameters, List hits, Annotation annotation) {
        if (querySequence == null) {
            throw new IllegalArgumentException("querySequence was null");
        }
        if (sequenceDB == null) {
            throw new IllegalArgumentException("sequenceDB was null");
        }
        if (searchParameters != null) {
            this.searchParameters = Collections.unmodifiableMap(searchParameters);
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation was null");
        }
        if (hits == null) {
            throw new IllegalArgumentException("hits was null");
        }
        sequenceDB.addChangeListener(ChangeListener.ALWAYS_VETO);
        querySequence.addChangeListener(ChangeListener.ALWAYS_VETO);
        annotation.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.querySequence = querySequence;
        this.sequenceDB = sequenceDB;
        this.annotation = annotation;
        this.hits = Collections.unmodifiableList(hits);
        this.hcCalc = false;
    }

    public SymbolList getQuerySequence() {
        return this.querySequence;
    }

    public SequenceDB getSequenceDB() {
        return this.sequenceDB;
    }

    public Map getSearchParameters() {
        return this.searchParameters;
    }

    public List getHits() {
        return this.hits;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SequenceDBSearchResult that = (SequenceDBSearchResult)other;
        if (!ObjectUtil.equals(this.querySequence, that.querySequence)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceDB, that.sequenceDB)) {
            return false;
        }
        if (!ObjectUtil.equals(this.searchParameters, that.searchParameters)) {
            return false;
        }
        if (!ObjectUtil.equals(this.annotation, that.annotation)) {
            return false;
        }
        return ObjectUtil.equals(this.hits, that.hits);
    }

    public int hashCode() {
        if (!this.hcCalc) {
            this.hc = ObjectUtil.hashCode(this.hc, this.querySequence);
            this.hc = ObjectUtil.hashCode(this.hc, this.sequenceDB);
            this.hc = ObjectUtil.hashCode(this.hc, this.searchParameters);
            this.hc = ObjectUtil.hashCode(this.hc, this.hits);
            this.hc = ObjectUtil.hashCode(this.hc, this.annotation);
            this.hcCalc = true;
        }
        return this.hc;
    }

    public String toString() {
        return "SequenceDBSearchResult of " + this.getQuerySequence() + " against " + this.getSequenceDB().getName();
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.annotationForwarder == null && (ct == null || ct == Annotatable.ANNOTATION)) {
            this.annotationForwarder = new Annotatable.AnnotationForwarder(this, cs);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        return cs;
    }
}

