/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.ObjectUtil;

public class SimpleSeqSimilaritySearchHit
implements SeqSimilaritySearchHit,
Cloneable {
    private double score;
    private double pValue;
    private double eValue;
    private int qStart;
    private int qEnd;
    private StrandedFeature.Strand qStrand;
    private int sStart;
    private int sEnd;
    private StrandedFeature.Strand sStrand;
    private String subjectID;
    private List subHits;
    private int hc;
    private boolean hcCalc;

    public SimpleSeqSimilaritySearchHit(double score, double eValue, double pValue, int qStart, int qEnd, StrandedFeature.Strand qStrand, int sStart, int sEnd, StrandedFeature.Strand sStrand, String subjectID, List subHits) {
        if (Double.isNaN(score)) {
            throw new IllegalArgumentException("score was NaN");
        }
        if (subjectID == null) {
            throw new IllegalArgumentException("subjectID was null");
        }
        if (subHits == null) {
            throw new IllegalArgumentException("subHits was null");
        }
        this.score = score;
        this.pValue = pValue;
        this.eValue = eValue;
        this.qStart = qStart;
        this.qEnd = qEnd;
        this.qStrand = qStrand;
        this.sStart = sStart;
        this.sEnd = sEnd;
        this.sStrand = sStrand;
        this.subjectID = subjectID;
        this.subHits = Collections.unmodifiableList(subHits);
        this.hcCalc = false;
    }

    public double getScore() {
        return this.score;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getQueryStart() {
        return this.qStart;
    }

    public int getQueryEnd() {
        return this.qEnd;
    }

    public StrandedFeature.Strand getQueryStrand() {
        return this.qStrand;
    }

    public int getSubjectStart() {
        return this.sStart;
    }

    public int getSubjectEnd() {
        return this.sEnd;
    }

    public StrandedFeature.Strand getSubjectStrand() {
        return this.sStrand;
    }

    public String getSubjectID() {
        return this.subjectID;
    }

    public List getSubHits() {
        return this.subHits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchHit that = (SimpleSeqSimilaritySearchHit)o;
        if (!ObjectUtil.equals(this.score, that.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, that.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, that.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectID, that.subjectID)) {
            return false;
        }
        return ObjectUtil.equals(this.subHits, that.subHits);
    }

    public int hashCode() {
        if (!this.hcCalc) {
            this.hc = ObjectUtil.hashCode(this.hc, this.score);
            this.hc = ObjectUtil.hashCode(this.hc, this.pValue);
            this.hc = ObjectUtil.hashCode(this.hc, this.eValue);
            this.hc = ObjectUtil.hashCode(this.hc, this.subjectID);
            this.hc = ObjectUtil.hashCode(this.hc, this.subHits);
            this.hcCalc = true;
        }
        return this.hc;
    }

    public String toString() {
        return "SequenceDBSearchHit to " + this.getSubjectID() + " with score " + this.getScore();
    }

    public Object clone() {
        return this;
    }
}

