/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ObjectUtil;

public class SimpleSeqSimilaritySearchResult
implements SeqSimilaritySearchResult,
Cloneable {
    private SymbolList querySequence;
    private SequenceDB sequenceDB;
    private Map searchParameters;
    private List hits;
    private int hc;
    private boolean hcCalc;

    public SimpleSeqSimilaritySearchResult(SymbolList querySequence, SequenceDB sequenceDB, Map searchParameters, List hits) {
        if (querySequence == null) {
            throw new IllegalArgumentException("querySequence was null");
        }
        if (sequenceDB == null) {
            throw new IllegalArgumentException("sequenceDB was null");
        }
        if (searchParameters != null) {
            this.searchParameters = Collections.unmodifiableMap(searchParameters);
        }
        if (hits == null) {
            throw new IllegalArgumentException("hits was null");
        }
        this.querySequence = querySequence;
        this.sequenceDB = sequenceDB;
        this.hits = Collections.unmodifiableList(hits);
        this.hcCalc = false;
    }

    public SymbolList getQuerySequence() {
        return this.querySequence;
    }

    public SequenceDB getSequenceDB() {
        return this.sequenceDB;
    }

    public Map getSearchParameters() {
        return this.searchParameters;
    }

    public List getHits() {
        return this.hits;
    }

    public String toString() {
        return "SimpleSeqSimilaritySearchResult of " + this.getQuerySequence() + " against " + this.getSequenceDB().getName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchResult that = (SimpleSeqSimilaritySearchResult)o;
        if (!ObjectUtil.equals(this.querySequence, that.querySequence)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceDB, that.sequenceDB)) {
            return false;
        }
        if (!ObjectUtil.equals(this.searchParameters, that.searchParameters)) {
            return false;
        }
        return ObjectUtil.equals(this.hits, that.hits);
    }

    public int hashCode() {
        if (!this.hcCalc) {
            this.hc = ObjectUtil.hashCode(this.hc, this.querySequence);
            this.hc = ObjectUtil.hashCode(this.hc, this.sequenceDB);
            this.hc = ObjectUtil.hashCode(this.hc, this.searchParameters);
            this.hc = ObjectUtil.hashCode(this.hc, this.hits);
            this.hcCalc = true;
        }
        return this.hc;
    }

    public Object clone() {
        return this;
    }
}

