/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;

public final class DNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final FiniteAlphabet dna;
    private static final SymbolTokenization dnaTokens;
    private static final AtomicSymbol a;
    private static final AtomicSymbol g;
    private static final AtomicSymbol c;
    private static final AtomicSymbol t;
    private static final Symbol n;
    private static Map symbolToComplement;

    public static AtomicSymbol a() {
        return a;
    }

    public static AtomicSymbol g() {
        return g;
    }

    public static AtomicSymbol c() {
        return c;
    }

    public static AtomicSymbol t() {
        return t;
    }

    public static Symbol n() {
        return n;
    }

    public static FiniteAlphabet getDNA() {
        return dna;
    }

    public static FiniteAlphabet getCodonAlphabet() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(DNA x DNA x DNA)");
    }

    public static SymbolList createDNA(String dna) throws IllegalSymbolException {
        try {
            SymbolTokenization p = DNATools.getDNA().getTokenization("token");
            return new SimpleSymbolList(p, dna);
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with DNA");
        }
    }

    public static Sequence createDNASequence(String dna, String name) throws IllegalSymbolException {
        try {
            return new SimpleSequenceFactory().createSequence(DNATools.createDNA(dna), "", name, new SimpleAnnotation());
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with DNA");
        }
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == t) {
            return 3;
        }
        DNATools.getDNA().validate(sym);
        throw new IllegalSymbolException("Really confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return t;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return t;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == t) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        DNATools.getDNA().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        if (token == 'a') {
            return a;
        }
        if (token == 'g') {
            return g;
        }
        if (token == 'c') {
            return c;
        }
        if (token == 't') {
            return t;
        }
        throw new IllegalSymbolException("Unable to find symbol for token " + token);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, DNATools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), DNATools.complementTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static char dnaToken(Symbol sym) throws IllegalSymbolException {
        return dnaTokens.tokenizeSymbol(sym).charAt(0);
    }

    static {
        try {
            dna = (FiniteAlphabet)AlphabetManager.alphabetForName("DNA");
            dnaTokens = dna.getTokenization("token");
            SimpleSymbolList syms = new SimpleSymbolList(dnaTokens, "agctn");
            a = (AtomicSymbol)syms.symbolAt(1);
            g = (AtomicSymbol)syms.symbolAt(2);
            c = (AtomicSymbol)syms.symbolAt(3);
            t = (AtomicSymbol)syms.symbolAt(4);
            n = syms.symbolAt(5);
            symbolToComplement = new HashMap();
            Symbol gap = dna.getGapSymbol();
            symbolToComplement.put(gap, gap);
            Iterator i = AlphabetManager.getAllSymbols(dna).iterator();
            while (i.hasNext()) {
                Symbol as = (Symbol)i.next();
                FiniteAlphabet matches = (FiniteAlphabet)as.getMatches();
                if (matches.size() <= 1) continue;
                HashSet<Symbol> l = new HashSet<Symbol>();
                Iterator j = matches.iterator();
                while (j.hasNext()) {
                    l.add(DNATools.complement((Symbol)j.next()));
                }
                symbolToComplement.put(as, dna.getAmbiguity(l));
            }
            complementTable = new DNAComplementTranslationTable();
        }
        catch (Throwable t) {
            throw new BioError(t, "Unable to initialize DNATools");
        }
    }

    private static class DNAComplementTranslationTable
    implements ReversibleTranslationTable {
        private DNAComplementTranslationTable() {
        }

        public Symbol translate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Symbol untranslate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Alphabet getSourceAlphabet() {
            return DNATools.getDNA();
        }

        public Alphabet getTargetAlphabet() {
            return DNATools.getDNA();
        }
    }
}

