/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class HashSequenceDB
extends AbstractSequenceDB
implements SequenceDB,
Serializable {
    private final Map sequenceByID;
    private final IDMaker idMaker;
    private String name;

    public String getName() {
        return this.name;
    }

    public Sequence getSequence(String id) throws IllegalIDException {
        Sequence seq = (Sequence)this.sequenceByID.get(id);
        if (seq == null) {
            throw new IllegalIDException("Sequence with ID " + id + " could not be found");
        }
        return seq;
    }

    public Set ids() {
        return this.sequenceByID.keySet();
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            Iterator seqI;
            {
                this.seqI = HashSequenceDB.this.sequenceByID.values().iterator();
            }

            public boolean hasNext() {
                return this.seqI.hasNext();
            }

            public Sequence nextSequence() {
                return (Sequence)this.seqI.next();
            }
        };
    }

    public void addSequence(String id, Sequence seq) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.sequenceByID.put(id, seq);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceDBLite.SEQUENCES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, SequenceDBLite.SEQUENCES, new Object[]{id, seq}, null);
                changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.put(id, seq);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public IDMaker getIDMaker() {
        return this.idMaker;
    }

    public void addSequence(Sequence seq) throws ChangeVetoException {
        String id = this.idMaker.calcID(seq);
        if (!this.hasListeners()) {
            this.addSequence(id, seq);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceDBLite.SEQUENCES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, SequenceDBLite.SEQUENCES, id, null);
                changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.remove(id);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public void removeSequence(String id) throws BioException, ChangeVetoException {
        if (!this.hasListeners()) {
            this.sequenceByID.remove(id);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceDBLite.SEQUENCES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, SequenceDBLite.SEQUENCES, null, id);
                changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.remove(id);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public HashSequenceDB() {
        this(IDMaker.byName, null);
    }

    public HashSequenceDB(IDMaker idMaker) {
        this(idMaker, null);
    }

    public HashSequenceDB(String name) {
        this(IDMaker.byName, name);
    }

    public HashSequenceDB(IDMaker idMaker, String name) {
        this.idMaker = idMaker;
        this.name = name;
        this.sequenceByID = new HashMap();
    }
}

