/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;
import org.biojava.utils.io.CountedBufferedReader;
import org.biojava.utils.io.RandomAccessReader;

public final class IndexedSequenceDB
extends AbstractSequenceDB
implements SequenceDB,
Serializable {
    private final IDMaker idMaker;
    private final IndexStore indexStore;

    public IndexedSequenceDB(IDMaker idMaker, IndexStore indexStore) {
        this.idMaker = idMaker;
        this.indexStore = indexStore;
    }

    public IndexedSequenceDB(IndexStore indexStore) {
        this(IDMaker.byName, indexStore);
    }

    public IndexStore getIndexStore() {
        return this.indexStore;
    }

    public void addFile(File seqFile) throws IllegalIDException, BioException, ChangeVetoException {
        boolean completed = false;
        try {
            try {
                seqFile = seqFile.getAbsoluteFile();
                CountedBufferedReader bReader = new CountedBufferedReader(new FileReader(seqFile));
                SequenceFormat format = this.indexStore.getFormat();
                SymbolTokenization symParser = this.indexStore.getSymbolParser();
                SequenceBuilderFactory sbFact = this.indexStore.getSBFactory();
                long pos = bReader.getFilePointer();
                boolean hasNextSequence = true;
                while (hasNextSequence) {
                    ElideSymbolsSequenceBuilder sb = new ElideSymbolsSequenceBuilder(sbFact.makeSequenceBuilder());
                    hasNextSequence = format.readSequence(bReader, symParser, sb);
                    Sequence seq = sb.makeSequence();
                    String id = this.idMaker.calcID(seq);
                    long oldPos = pos;
                    pos = bReader.getFilePointer();
                    this.indexStore.store(new SimpleIndex(seqFile, oldPos, (int)(pos - oldPos), id));
                }
                if (!this.hasListeners()) {
                    this.indexStore.commit();
                } else {
                    ChangeSupport changeSupport;
                    ChangeEvent ce = new ChangeEvent(this, SequenceDBLite.SEQUENCES);
                    ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceDBLite.SEQUENCES);
                    synchronized (changeSupport2) {
                        changeSupport.firePreChangeEvent(ce);
                        this.indexStore.commit();
                        changeSupport.firePostChangeEvent(ce);
                    }
                }
                completed = true;
            }
            catch (IOException ioe) {
                throw new BioException(ioe, "Failed to read sequence file");
            }
            Object var17_15 = null;
            if (!completed) {
                this.indexStore.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            if (!completed) {
                this.indexStore.rollback();
            }
            throw throwable;
        }
    }

    public String getName() {
        return this.indexStore.getName();
    }

    public Sequence getSequence(String id) throws IllegalIDException, BioException {
        try {
            Index indx = this.indexStore.fetch(id);
            RandomAccessReader rar = new RandomAccessReader(new RandomAccessFile(indx.getFile(), "r"));
            long toSkip = indx.getStart();
            if (toSkip > rar.length()) {
                throw new BioException("Reached end of file");
            }
            rar.seek(toSkip);
            SequenceBuilder sb = this.indexStore.getSBFactory().makeSequenceBuilder();
            this.indexStore.getFormat().readSequence(new BufferedReader(rar), this.indexStore.getSymbolParser(), sb);
            Sequence seq = sb.makeSequence();
            rar.close();
            return seq;
        }
        catch (IOException ioe) {
            throw new BioException(ioe, "Couldn't grab region of file");
        }
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator idI;
            {
                this.idI = IndexedSequenceDB.this.indexStore.getIDs().iterator();
            }

            public boolean hasNext() {
                return this.idI.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return IndexedSequenceDB.this.getSequence((String)this.idI.next());
            }
        };
    }

    public Set ids() {
        return this.indexStore.getIDs();
    }

    private static class ElideSymbolsSequenceBuilder
    extends SequenceBuilderFilter
    implements ParseErrorSource {
        private Vector listeners = new Vector();

        public synchronized void removeParseErrorListener(ParseErrorListener p) {
            if (this.listeners.contains(p)) {
                this.listeners.remove(p);
            }
        }

        public synchronized void addParseErrorListener(ParseErrorListener p) {
            if (!this.listeners.contains(p)) {
                this.listeners.add(p);
            }
        }

        public ElideSymbolsSequenceBuilder(SequenceBuilder delegate) {
            super(delegate);
        }

        public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) {
        }
    }
}

