/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeVetoException;

public abstract class WebSequenceDB
extends AbstractChangeable
implements SequenceDBLite {
    protected abstract SequenceFormat getSequenceFormat();

    protected abstract URL getAddress(String var1) throws MalformedURLException;

    protected abstract Alphabet getAlphabet();

    public Sequence getSequence(String id) throws BioException {
        if (id.equals("")) {
            throw new BioException("did not specify a valid id for getSequence");
        }
        try {
            URL queryURL = this.getAddress(id);
            System.err.println("query is " + queryURL.toString());
            URLConnection connection = queryURL.openConnection();
            SequenceFormat sFormat = this.getSequenceFormat();
            Alphabet alpha = this.getAlphabet();
            SequenceBuilderFactory sFact = SeqIOTools.formatToFactory(sFormat, alpha);
            SequenceBuilder sbuilder = sFact.makeSequenceBuilder();
            SymbolTokenization rParser = alpha.getTokenization("token");
            System.err.println("got data from " + queryURL);
            StreamReader seqI = new StreamReader(connection.getInputStream(), sFormat, rParser, sFact);
            return seqI.nextSequence();
        }
        catch (Exception e) {
            throw new BioException(e);
        }
    }

    public void addSequence(Sequence seq) throws ChangeVetoException {
        throw new ChangeVetoException("Can't add sequences from web sequence DB: " + seq.getName());
    }

    public void removeSequence(String id) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove sequences from web sequence DB: " + id);
    }

    public abstract String getName();
}

