/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biofetch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

public class BioFetchSequenceDB
extends Unchangeable
implements SequenceDBLite {
    private final String prefix;
    private final String type;
    private final String db;

    public BioFetchSequenceDB(String prefix, String type, String db) {
        this.prefix = prefix;
        this.type = type;
        this.db = db;
    }

    public String getName() {
        return this.db;
    }

    public void addSequence(Sequence seq) throws ChangeVetoException {
        throw new ChangeVetoException("Can't add sequences to XEMBL");
    }

    public void removeSequence(String id) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove sequences from XEMBL");
    }

    public Sequence getSequence(String id) throws BioException, IllegalIDException {
        StringBuffer uri = new StringBuffer(this.prefix);
        uri.append('?');
        uri.append("style=raw;");
        uri.append("format=");
        uri.append(this.type);
        uri.append(";db=");
        uri.append(this.db);
        uri.append(";id=");
        uri.append(id);
        try {
            StringTokenizer toke;
            String first;
            HttpURLConnection huc = (HttpURLConnection)new URL(uri.substring(0)).openConnection();
            huc.connect();
            BufferedReader data = new BufferedReader(new InputStreamReader(huc.getInputStream()));
            data.mark(1000);
            String firstLine = data.readLine();
            if (firstLine.startsWith("Content-")) {
                data.readLine();
                firstLine = data.readLine();
            }
            if ("ERROR".equals(first = (toke = new StringTokenizer(firstLine)).nextToken())) {
                int errorCode = Integer.parseInt(toke.nextToken());
                if (errorCode == 4) {
                    throw new IllegalIDException("No such ID " + id + " in database " + this.getName());
                }
                throw new BioException("Error fetching from BioFetch: firstLine");
            }
            data.reset();
            if ("embl".equals(this.type)) {
                SequenceIterator si = SeqIOTools.readEmbl(data);
                return si.nextSequence();
            }
            throw new BioException("Unknown format " + this.type);
        }
        catch (IOException ex) {
            throw new BioException(ex, "Error reading data from BioFetch");
        }
    }
}

