/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.io.OrganismParser;
import org.biojava.bio.taxa.CircularReferenceException;
import org.biojava.bio.taxa.EbiFormat;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.WeakTaxonFactory;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLSequenceAnnotation
implements Annotation {
    private BioSQLSequenceDB seqDB;
    private int bioentry_id;
    private Annotation underlyingAnnotation;

    int getBioentryID() {
        return this.bioentry_id;
    }

    BioSQLSequenceAnnotation(BioSQLSequenceDB seqDB, int bioentry_id) {
        this.seqDB = seqDB;
        this.bioentry_id = bioentry_id;
    }

    private void initAnnotations() {
        try {
            Connection conn = this.seqDB.getPool().takeConnection();
            this.underlyingAnnotation = new SmallAnnotation();
            this.underlyingAnnotation.setProperty("bioentry_id", new Integer(this.bioentry_id));
            PreparedStatement get_taxa = conn.prepareStatement("select taxa.full_lineage, taxa.common_name, taxa.ncbi_taxa_id from bioentry_taxa, taxa where bioentry_taxa.bioentry_id = ? and       bioentry_taxa.taxa_id = taxa.taxa_id ");
            get_taxa.setInt(1, this.bioentry_id);
            ResultSet rs = get_taxa.executeQuery();
            if (rs.next()) {
                Taxon taxon = EbiFormat.getInstance().parse(WeakTaxonFactory.GLOBAL, rs.getString(1));
                taxon.setCommonName(rs.getString(2));
                taxon.getAnnotation().setProperty(EbiFormat.PROPERTY_NCBI_TAXON, String.valueOf(rs.getInt(3)));
                this.underlyingAnnotation.setProperty(OrganismParser.PROPERTY_ORGANISM, taxon);
            }
            if (this.seqDB.isBioentryPropertySupported()) {
                PreparedStatement get_properties = conn.prepareStatement("select ontology_term.term_name as qn, bioentry_qualifier_value.qualifier_value   from bioentry_qualifier_value, ontology_term  where bioentry_qualifier_value.bioentry_id = ?    and ontology_term.ontology_term_id = bioentry_qualifier_value.ontology_term_id ");
                get_properties.setInt(1, this.bioentry_id);
                rs = get_properties.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(1).trim();
                    String value = rs.getString(2);
                    if (this.underlyingAnnotation.containsProperty(key)) {
                        ArrayList<Object> coll;
                        Object current = this.underlyingAnnotation.getProperty(key);
                        if (!(current instanceof Collection)) {
                            coll = new ArrayList<Object>();
                            coll.add(current);
                            this.underlyingAnnotation.setProperty(key, coll);
                        } else {
                            coll = (ArrayList<Object>)current;
                        }
                        coll.add(value);
                        continue;
                    }
                    this.underlyingAnnotation.setProperty(key, value);
                }
            }
            this.seqDB.getPool().putConnection(conn);
        }
        catch (SQLException ex) {
            throw new BioRuntimeException(ex, "Error fetching annotations");
        }
        catch (ChangeVetoException ex) {
            throw new BioError(ex);
        }
        catch (CircularReferenceException ex) {
            throw new BioError(ex);
        }
    }

    public Object getProperty(Object key) throws NoSuchElementException {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.getProperty(key);
    }

    public void setProperty(Object key, Object value) throws ChangeVetoException {
        BioSQLChangeHub hub;
        BioSQLChangeHub bioSQLChangeHub = hub = this.seqDB.getChangeHub();
        synchronized (bioSQLChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, Annotation.PROPERTY, key);
            hub.fireEntryAnnotationPreChange(cev);
            this._setProperty(key, value);
            hub.fireEntryAnnotationPostChange(cev);
        }
    }

    private void _setProperty(Object key, Object value) throws ChangeVetoException {
        this.persistProperty(key, value);
        if (this.underlyingAnnotation != null) {
            this.underlyingAnnotation.setProperty(key, value);
        }
    }

    public void removeProperty(Object key) throws ChangeVetoException {
        BioSQLChangeHub hub;
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        if (!this.underlyingAnnotation.containsProperty(key)) {
            throw new NoSuchElementException("Annotation doesn't contain property " + key.toString());
        }
        BioSQLChangeHub bioSQLChangeHub = hub = this.seqDB.getChangeHub();
        synchronized (bioSQLChangeHub) {
            ChangeEvent cev = new ChangeEvent(this, Annotation.PROPERTY, key);
            hub.fireFeatureAnnotationPreChange(cev);
            this.underlyingAnnotation.removeProperty(key);
            this.persistProperty(key, null);
            hub.fireFeatureAnnotationPostChange(cev);
        }
    }

    private void persistProperty(Object key, Object value) throws ChangeVetoException {
        Connection conn = null;
        try {
            conn = this.seqDB.getPool().takeConnection();
            conn.setAutoCommit(false);
            this.seqDB.persistBioentryProperty(conn, this.bioentry_id, key, value, true, false);
            conn.commit();
            this.seqDB.getPool().putConnection(conn);
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException(ex, "Error adding BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""));
        }
    }

    public boolean containsProperty(Object key) {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.containsProperty(key);
    }

    public Set keys() {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return this.underlyingAnnotation.keys();
    }

    public Map asMap() {
        if (this.underlyingAnnotation == null) {
            this.initAnnotations();
        }
        return Collections.unmodifiableMap(this.underlyingAnnotation.asMap());
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.seqDB.getChangeHub().addEntryAnnotationListener(this.bioentry_id, cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.seqDB.getChangeHub().removeEntryAnnotationListener(this.bioentry_id, cl, ct);
    }

    public boolean isUnchanging(ChangeType ct) {
        return false;
    }
}

