/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.SQLException;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.biosql.BioSQLChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureReceiver;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.bio.seq.db.biosql.BioSQLStrandedFeature;
import org.biojava.bio.seq.db.biosql.FeaturesSQL;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.CacheReference;

class BioSQLTiledFeatures
implements FeatureHolder,
RealizingFeatureHolder {
    private Sequence seq;
    private BioSQLSequenceDB seqDB;
    private int bioentry_id;
    private Location[] tileLocations;
    private FeatureTile[] tileFeatures;
    private SimpleFeatureHolder overlappingFeatures;
    private MergeFeatureHolder allFeatures;

    BioSQLTiledFeatures(Sequence seq, BioSQLSequenceDB seqDB, int bioentry_id, int tileSize) {
        this.seq = seq;
        this.seqDB = seqDB;
        this.bioentry_id = bioentry_id;
        int numTiles = (int)Math.ceil(1.0 * (double)seq.length() / (double)tileSize);
        this.tileLocations = new Location[numTiles];
        this.tileFeatures = new FeatureTile[numTiles];
        try {
            this.allFeatures = new MergeFeatureHolder();
            int t = 0;
            while (t < numTiles) {
                this.tileLocations[t] = new RangeLocation(1 + t * tileSize, Math.min((t + 1) * tileSize, seq.length()));
                this.tileFeatures[t] = new FeatureTile(t);
                this.allFeatures.addFeatureHolder(this.tileFeatures[t]);
                ++t;
            }
            this.overlappingFeatures = new SimpleFeatureHolder();
            this.allFeatures.addFeatureHolder(this.overlappingFeatures);
        }
        catch (ChangeVetoException ex) {
            throw new BioError(ex);
        }
    }

    public FeatureFilter getSchema() {
        return FeatureFilter.top_level;
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatures().filter(ff, recurse);
    }

    private void _addFeature(Feature f) throws ChangeVetoException {
        int t = 0;
        while (t < this.tileLocations.length) {
            if (this.tileLocations[t].contains(f.getLocation())) {
                this.tileFeatures[t].addFeature(f);
                return;
            }
            ++t;
        }
        this.overlappingFeatures.addFeature(f);
    }

    public Feature createFeature(Feature.Template ft) throws ChangeVetoException, BioException {
        Feature f = this.realizeFeature(this.seq, ft);
        BioSQLChangeHub hub = ((BioSQLSequenceI)this.seq).getSequenceDB().getChangeHub();
        ChangeEvent cev = new ChangeEvent(this.seq, FeatureHolder.FEATURES, f);
        BioSQLChangeHub bioSQLChangeHub = hub;
        synchronized (bioSQLChangeHub) {
            hub.fireEntryPreChange(cev);
            this.seqDB.getFeaturesSQL().persistFeature(f, -1, this.bioentry_id);
            this._addFeature(f);
            hub.fireEntryPostChange(cev);
        }
        return f;
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        FeatureHolder fh = this.overlappingFeatures;
        int t = 0;
        while (t < this.tileLocations.length) {
            if (this.tileLocations[t].contains(f.getLocation())) {
                fh = this.tileFeatures[t];
            }
            ++t;
        }
        if (!fh.containsFeature(f)) {
            throw new ChangeVetoException("Feature doesn't come from this sequence");
        }
        if (!(f instanceof BioSQLFeature)) {
            throw new ChangeVetoException("This isn't a normal BioSQL feature");
        }
        BioSQLChangeHub hub = ((BioSQLSequenceI)this.seq).getSequenceDB().getChangeHub();
        ChangeEvent cev = new ChangeEvent(this.seq, FeatureHolder.FEATURES, f);
        BioSQLChangeHub bioSQLChangeHub = hub;
        synchronized (bioSQLChangeHub) {
            hub.fireEntryPreChange(cev);
            this.seqDB.getFeaturesSQL().removeFeature((BioSQLFeature)f);
            fh.removeFeature(f);
            hub.fireEntryPostChange(cev);
        }
    }

    protected FeatureHolder getFeatures() {
        return this.allFeatures;
    }

    private BioSQLFeature _realizeFeature(FeatureHolder parent, Feature.Template templ) throws BioException {
        if (parent != this.seq && !this.seqDB.isHierarchySupported()) {
            throw new BioException("This database doesn't support feature hierarchy.  Please create a seqfeature_relationship table");
        }
        if (templ instanceof StrandedFeature.Template && this.seq.getAlphabet() == DNATools.getDNA()) {
            return new BioSQLStrandedFeature(this.seq, parent, (StrandedFeature.Template)templ);
        }
        return new BioSQLFeature(this.seq, parent, templ);
    }

    public Feature realizeFeature(FeatureHolder parent, Feature.Template templ) throws BioException {
        return this._realizeFeature(parent, templ);
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public boolean isUnchanging(ChangeType ct) {
        return true;
    }

    private class FeatureTile
    implements FeatureHolder {
        private int tileNumber;
        private CacheReference featuresRef;

        FeatureTile(int tileNumber) {
            this.tileNumber = tileNumber;
        }

        public Iterator features() {
            return this.getTileFeatures().features();
        }

        public int countFeatures() {
            return this.getTileFeatures().countFeatures();
        }

        public boolean containsFeature(Feature f) {
            return this.getTileFeatures().containsFeature(f);
        }

        public FeatureHolder filter(FeatureFilter ff) {
            return this.getTileFeatures().filter(ff);
        }

        public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
            return this.getTileFeatures().filter(ff, recurse);
        }

        /*
         * WARNING - void declaration
         */
        private synchronized SimpleFeatureHolder getTileFeatures() {
            SimpleFeatureHolder fh;
            if (this.featuresRef != null && (fh = (SimpleFeatureHolder)this.featuresRef.get()) != null) {
                return fh;
            }
            try {
                void ex;
                SimpleFeatureHolder features = new SimpleFeatureHolder();
                FeaturesSQL adaptor = BioSQLTiledFeatures.this.seqDB.getFeaturesSQL();
                adaptor.retrieveFeatures(BioSQLTiledFeatures.this.bioentry_id, new TileFeatureReceiver(features, BioSQLTiledFeatures.this.tileLocations[this.tileNumber]), BioSQLTiledFeatures.this.tileLocations[this.tileNumber], -1, -1);
                this.featuresRef = BioSQLTiledFeatures.this.seqDB.getTileCache().makeReference(features);
                return ex;
            }
            catch (SQLException ex) {
                throw new BioRuntimeException(ex, "SQL error while reading features");
            }
            catch (BioException ex) {
                throw new BioRuntimeException(ex);
            }
        }

        public FeatureFilter getSchema() {
            FeatureFilter.ContainedByLocation tileFilter = new FeatureFilter.ContainedByLocation(BioSQLTiledFeatures.this.tileLocations[this.tileNumber]);
            return new FeatureFilter.And(tileFilter, new FeatureFilter.OnlyDescendants(tileFilter));
        }

        public void addFeature(Feature f) throws ChangeVetoException {
            this.getTileFeatures().addFeature(f);
        }

        public void removeFeature(Feature f) throws ChangeVetoException {
            this.getTileFeatures().removeFeature(f);
        }

        public Feature createFeature(Feature.Template ft) throws ChangeVetoException, BioException {
            throw new ChangeVetoException();
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public boolean isUnchanging(ChangeType ct) {
            return true;
        }
    }

    private class TileFeatureReceiver
    extends BioSQLFeatureReceiver {
        private final Location tileLocation;
        private final SimpleFeatureHolder tileFeatures;

        private TileFeatureReceiver(SimpleFeatureHolder tileFeatures, Location tileLocation) {
            super(BioSQLTiledFeatures.this.seq);
            this.tileLocation = tileLocation;
            this.tileFeatures = tileFeatures;
        }

        protected void deliverTopLevelFeature(Feature f) throws ParseException, ChangeVetoException {
            if (LocationTools.contains(this.tileLocation, f.getLocation())) {
                this.tileFeatures.addFeature(f);
            } else if (!BioSQLTiledFeatures.this.overlappingFeatures.containsFeature(f)) {
                BioSQLTiledFeatures.this.overlappingFeatures.addFeature(f);
            }
        }
    }
}

