/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import org.biojava.bio.seq.io.WordTokenization;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class DoubleTokenization
extends WordTokenization {
    public DoubleTokenization() {
        super(DoubleAlphabet.getInstance());
    }

    public Symbol parseToken(String seq) throws IllegalSymbolException {
        try {
            double d = Double.parseDouble(seq);
            return ((DoubleAlphabet)this.getAlphabet()).getSymbol(d);
        }
        catch (NumberFormatException ex) {
            throw new IllegalSymbolException(ex, "Couldn't parse " + seq);
        }
    }

    public String tokenizeSymbol(Symbol sym) throws IllegalSymbolException {
        this.getAlphabet().validate(sym);
        return sym.getName();
    }
}

