/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class FastaFormat
implements SequenceFormat,
Serializable,
ParseErrorListener,
ParseErrorSource {
    public static final String DEFAULT = "FASTA";
    public static final String PROPERTY_DESCRIPTIONLINE = "description_line";
    private Vector mListeners = new Vector();
    private int lineWidth = 60;

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    /*
     * Unable to fully structure code
     */
    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener siol) throws IllegalSymbolException, IOException, ParseException {
        line = reader.readLine();
        if (line != null) ** GOTO lbl7
        throw new IOException("Premature stream end");
lbl-1000:
        // 1 sources

        {
            line = reader.readLine();
            if (line != null) continue;
            throw new IOException("Premature stream end");
lbl7:
            // 2 sources

            ** while (line.length() == 0)
        }
lbl8:
        // 1 sources

        if (!line.startsWith(">")) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + line);
        }
        siol.startSequence();
        description = line.substring(1).trim();
        siol.addSequenceProperty("description_line", description);
        name = new StringTokenizer(description).nextToken();
        siol.setName(name);
        seenEOF = this.readSequenceData(reader, symParser, siol);
        siol.endSequence();
        return seenEOF == false;
    }

    private boolean readSequenceData(BufferedReader r, SymbolTokenization parser, SeqIOListener listener) throws IOException, IllegalSymbolException {
        char[] cache = new char[512];
        boolean reachedEnd = false;
        boolean seenEOF = false;
        StreamParser sparser = parser.parseStream(listener);
        while (!reachedEnd) {
            r.mark(cache.length);
            int bytesRead = r.read(cache, 0, cache.length);
            if (bytesRead < 0) {
                seenEOF = true;
                reachedEnd = true;
                continue;
            }
            int parseStart = 0;
            int parseEnd = 0;
            while (!reachedEnd && parseStart < bytesRead && cache[parseStart] != '>') {
                parseEnd = parseStart;
                while (parseEnd < bytesRead && cache[parseEnd] != '\n' && cache[parseEnd] != '\r') {
                    ++parseEnd;
                }
                sparser.characters(cache, parseStart, parseEnd - parseStart);
                parseStart = parseEnd + 1;
                while (parseStart < bytesRead && cache[parseStart] == '\n' && cache[parseStart] == '\r') {
                    ++parseStart;
                }
            }
            if (parseStart >= bytesRead || cache[parseStart] != '>') continue;
            try {
                r.reset();
            }
            catch (IOException ioe) {
                throw new IOException("Can't reset: " + ioe.getMessage() + " parseStart=" + parseStart + " bytesRead=" + bytesRead);
            }
            if (r.skip(parseStart) != (long)parseStart) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            reachedEnd = true;
        }
        sparser.close();
        return seenEOF;
    }

    protected String describeSequence(Sequence seq) {
        String description = null;
        Annotation seqAnn = seq.getAnnotation();
        description = seqAnn.containsProperty(PROPERTY_DESCRIPTIONLINE) ? (String)seqAnn.getProperty(PROPERTY_DESCRIPTIONLINE) : seq.getName();
        return description;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        os.print(">");
        os.println(this.describeSequence(seq));
        int length = seq.length();
        int pos = 1;
        while (pos <= length) {
            int end = Math.min(pos + this.lineWidth - 1, length);
            os.println(seq.subStr(pos, end));
            pos += this.lineWidth;
        }
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (!format.equalsIgnoreCase(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format '" + format + "'");
        }
        this.writeSequence(seq, os);
    }

    public String getDefaultFormat() {
        return DEFAULT;
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    public void BadLineParsed(ParseErrorEvent theEvent) {
        this.notifyParseErrorEvent(theEvent);
    }

    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        FastaFormat fastaFormat = this;
        synchronized (fastaFormat) {
            listeners = (Vector)this.mListeners.clone();
        }
        int index = 0;
        while (index < listeners.size()) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
            ++index;
        }
    }
}

