/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.EmblLikeLocationParser;
import org.biojava.bio.seq.io.SeqIOListener;

public class FeatureTableParser {
    private static final int WITHOUT = 0;
    private static final int WITHIN = 1;
    private static final int LOCATION = 2;
    private static final int ATTRIBUTE = 3;
    private int featureStatus = 0;
    private StringBuffer featureBuf;
    private Feature.Template featureTemplate;
    private String featureSource;
    private SeqIOListener listener;
    private EmblLikeLocationParser locParser;
    private String seqID;

    FeatureTableParser(SeqIOListener listener, String source) {
        this.listener = listener;
        this.featureSource = source;
        this.seqID = this.seqID;
        this.featureBuf = new StringBuffer();
        this.locParser = new EmblLikeLocationParser(this.seqID);
    }

    public void setSeqID(String seqID) {
        this.seqID = seqID;
    }

    public void startFeature(String type) throws BioException {
        this.featureStatus = 2;
        this.featureBuf.setLength(0);
        this.featureTemplate = this.featureSource.equals("RefSeq:Protein") ? new Feature.Template() : new StrandedFeature.Template();
        this.featureTemplate.type = type;
        this.featureTemplate.source = this.featureSource;
        this.featureTemplate.annotation = new SimpleAnnotation();
    }

    public void featureData(String line) throws BioException {
        switch (this.featureStatus) {
            case 2: {
                this.featureBuf.append(line);
                if (this.countChar(this.featureBuf, '(') != this.countChar(this.featureBuf, ')')) break;
                this.featureTemplate = this.locParser.parseLocation(this.featureBuf.substring(0), this.featureTemplate);
                this.listener.startFeature(this.featureTemplate);
                this.featureStatus = 1;
                break;
            }
            case 1: {
                if (line.charAt(0) == '/') {
                    if (this.countChar(line, '\"') % 2 == 0) {
                        this.processAttribute(line);
                        break;
                    }
                    this.featureBuf.setLength(0);
                    this.featureBuf.append(line);
                    this.featureStatus = 3;
                    break;
                }
                throw new BioException("Invalid line in feature body: " + line);
            }
            case 3: {
                if (this.countChar(this.featureBuf, ' ') > 0 && this.featureBuf.charAt(this.featureBuf.length() - 1) != ' ') {
                    this.featureBuf.append(" ");
                }
                this.featureBuf.append(line);
                if (this.countChar(this.featureBuf, '\"') % 2 != 0) break;
                this.processAttribute(this.featureBuf.substring(0));
                this.featureStatus = 1;
            }
        }
    }

    public void endFeature() throws BioException {
        this.listener.endFeature();
        this.featureStatus = 0;
    }

    public boolean inFeature() {
        return this.featureStatus != 0;
    }

    private void processAttribute(String attr) throws BioException {
        int eqPos = attr.indexOf(61);
        if (eqPos == -1) {
            this.listener.addFeatureProperty(attr.substring(1), Boolean.TRUE);
        } else {
            String val;
            int max;
            String tag = attr.substring(1, eqPos);
            if (attr.charAt(++eqPos) == '\"') {
                ++eqPos;
            }
            if (attr.charAt((max = attr.length()) - 1) == '\"') {
                --max;
            }
            if ((val = attr.substring(eqPos, max)).indexOf(34) >= 0) {
                StringBuffer sb = new StringBuffer();
                boolean escape = false;
                int i = 0;
                while (i < val.length()) {
                    char c = val.charAt(i);
                    if (c == '\"') {
                        if (escape) {
                            sb.append(c);
                        }
                        escape = !escape;
                    } else {
                        sb.append(c);
                        escape = false;
                    }
                    ++i;
                }
                val = sb.substring(0);
            }
            this.listener.addFeatureProperty(tag, val);
        }
    }

    private int countChar(StringBuffer s, char c) {
        int cnt = 0;
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) == c) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    private int countChar(String s, char c) {
        int cnt = 0;
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) == c) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }
}

