/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

class GenbankContext
implements ParseErrorListener,
ParseErrorSource {
    private static final int HEADER = 1;
    private static final int FEATURES = 2;
    private static final int SEQUENCE = 3;
    private static final int VERSION_LENGTH = 11;
    private static final int TAG_LENGTH = 12;
    private int status = 1;
    private SymbolTokenization symParser;
    private StreamParser streamParser;
    private List symbols;
    private String accession;
    private String headerTag = "";
    private StringBuffer headerTagText = new StringBuffer();
    private SeqIOListener listener;
    private Vector mListeners = new Vector();
    private boolean elideSymbols;

    protected GenbankContext(SymbolTokenization theSymbolParser, SeqIOListener theListener) {
        this.symbols = new ArrayList();
        this.listener = theListener;
        this.symParser = theSymbolParser;
        this.streamParser = this.symParser.parseStream(this.listener);
        ((ParseErrorSource)((Object)this.listener)).addParseErrorListener(this);
    }

    public void BadLineParsed(ParseErrorEvent theEvent) {
        this.notifyParseErrorEvent(theEvent);
    }

    protected void processLine(String line) throws ParseException, IllegalSymbolException {
        if (line.startsWith("FEATURES")) {
            this.status = 2;
            this.saveSeqAnno();
        } else if (line.startsWith("ORIGIN")) {
            this.status = 3;
            this.saveSeqAnno();
            this.headerTag = line;
            this.saveSeqAnno();
        } else if (line.startsWith("//")) {
            this.streamParser.close();
        } else if (this.status == 2) {
            this.processFeatureLine(line);
        } else if (this.status == 3 && !this.elideSymbols) {
            this.processSeqLine(line, this.streamParser);
        } else if (this.status == 1) {
            this.processHeaderLine(line);
        }
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        GenbankContext genbankContext = this;
        synchronized (genbankContext) {
            listeners = (Vector)this.mListeners.clone();
        }
        int lnrCount = listeners.size();
        int index = 0;
        while (index < lnrCount) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
            ++index;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processSeqLine(String line, StreamParser theParser) throws IllegalSymbolException {
        cline = line.toCharArray();
        parseStart = 0;
        parseEnd = 0;
        ** GOTO lbl17
        {
            ++parseStart;
            do {
                if (parseStart < cline.length && (cline[parseStart] == ' ' || Character.isDigit(cline[parseStart]))) continue block0;
                if (parseStart >= cline.length) break block0;
                parseEnd = parseStart + 1;
                while (parseEnd < cline.length && cline[parseEnd] != ' ') {
                    if (cline[parseEnd] == '.' || cline[parseEnd] == '~') {
                        cline[parseEnd] = 45;
                    }
                    ++parseEnd;
                }
                theParser.characters(cline, parseStart, parseEnd - parseStart);
                parseStart = parseEnd;
lbl17:
                // 2 sources

            } while (parseStart < cline.length);
        }
    }

    private void processFeatureLine(String line) throws ParseException {
        if (line.startsWith("     ")) {
            this.saveSeqAnno();
            this.headerTag = "FT";
            this.headerTagText = new StringBuffer(line.substring(5));
        } else {
            this.processHeaderLine(line);
        }
    }

    private void processHeaderLine(String line) throws ParseException {
        if (line.startsWith("LOCUS")) {
            if (this.isLocusLinePre127(line)) {
                this.parseLocusLinePre127(line);
            } else {
                this.parseLocusLinePost127(line);
            }
        } else if (line.startsWith("VERSION")) {
            String nextToken;
            this.saveSeqAnno();
            StringTokenizer lineTokens = new StringTokenizer(line);
            this.headerTag = lineTokens.nextToken();
            this.headerTagText = new StringBuffer(lineTokens.nextToken());
            if (lineTokens.hasMoreTokens() && (nextToken = lineTokens.nextToken()).startsWith("GI")) {
                this.saveSeqAnno();
                this.headerTag = "GI";
                this.headerTagText = new StringBuffer(nextToken.substring(3));
            }
        } else if (this.hasHeaderTag(line)) {
            this.saveSeqAnno();
            this.headerTag = line.substring(0, 12).trim();
            this.headerTagText = new StringBuffer(line.substring(12));
        } else if (line.length() >= 12) {
            this.headerTagText.append(" " + line.substring(12));
        }
    }

    private boolean isLocusLinePre127(String theLine) {
        return theLine.length() < 75;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseLocusLinePre127(String theLine) throws ParseException {
        if (theLine.length() < 73) {
            StringTokenizer locusTokens = new StringTokenizer(theLine);
            locusTokens.nextToken();
            if (!locusTokens.hasMoreTokens()) throw new ParseException("LOCUS line too short [" + theLine + "]");
            this.saveSeqAnno2("LOCUS", locusTokens.nextToken());
            return;
        } else {
            this.saveSeqAnno2("LOCUS", theLine.substring(12, 22));
            this.saveSeqAnno2("SIZE", theLine.substring(22, 29));
            this.saveSeqAnno2("STRANDS", theLine.substring(33, 35));
            this.saveSeqAnno2("TYPE", theLine.substring(36, 41));
            this.saveSeqAnno2("CIRCULAR", theLine.substring(42, 52));
            this.saveSeqAnno2("DIVISION", theLine.substring(52, 55));
            this.saveSeqAnno2("MDAT", theLine.substring(62, 73));
        }
    }

    private void parseLocusLinePost127(String theLine) throws ParseException {
        if (theLine.length() < 79) {
            throw new ParseException("LOCUS line too short [" + theLine + "]");
        }
        StringTokenizer locusTokens = new StringTokenizer(theLine);
        if (locusTokens.countTokens() == 8 || locusTokens.countTokens() == 7) {
            boolean includedStrandTag = locusTokens.countTokens() == 8;
            locusTokens.nextToken();
            this.saveSeqAnno2("LOCUS", locusTokens.nextToken());
            this.saveSeqAnno2("SIZE", locusTokens.nextToken());
            locusTokens.nextToken();
            if (includedStrandTag) {
                String strandString = locusTokens.nextToken();
                StringTokenizer strandTokens = new StringTokenizer(strandString, "-");
                if (strandTokens.countTokens() > 1) {
                    this.saveSeqAnno2("STRANDS", strandTokens.nextToken());
                }
                this.saveSeqAnno2("TYPE", strandTokens.nextToken());
            }
            this.saveSeqAnno2("CIRCULAR", locusTokens.nextToken());
            this.saveSeqAnno2("DIVISION", locusTokens.nextToken());
            this.saveSeqAnno2("MDAT", locusTokens.nextToken());
        } else {
            this.saveSeqAnno2("LOCUS", theLine.substring(12, 28));
            this.saveSeqAnno2("SIZE", theLine.substring(29, 40));
            this.saveSeqAnno2("STRANDS", theLine.substring(44, 46));
            this.saveSeqAnno2("TYPE", theLine.substring(47, 53));
            this.saveSeqAnno2("CIRCULAR", theLine.substring(55, 63));
            this.saveSeqAnno2("DIVISION", theLine.substring(64, 67));
            this.saveSeqAnno2("MDAT", theLine.substring(68, 79));
        }
    }

    private void saveSeqAnno() throws ParseException {
        if (!this.headerTag.equals("")) {
            this.listener.addSequenceProperty(this.headerTag, this.headerTagText.substring(0));
            this.headerTag = "";
            this.headerTagText = new StringBuffer("");
        }
    }

    private void saveSeqAnno2(String tag, String value) throws ParseException {
        if ((value = value.trim()).length() > 0) {
            this.saveSeqAnno();
            this.headerTag = tag;
            this.headerTagText = new StringBuffer(value);
        }
    }

    private boolean hasHeaderTag(String line) {
        boolean isHeaderTag = false;
        char[] lar = line.toCharArray();
        int len = Math.min(lar.length, 12);
        int i = 0;
        while (i < len && i < lar.length) {
            if (lar[i] != ' ') {
                isHeaderTag = true;
                break;
            }
            ++i;
        }
        return isHeaderTag;
    }

    public boolean getElideSymbols() {
        return this.elideSymbols;
    }

    public void setElideSymbols(boolean elideSymbols) {
        this.elideSymbols = elideSymbols;
    }
}

