/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.AbstractGenEmblFileFormer;
import org.biojava.bio.seq.io.GenEmblFeatureComparator;
import org.biojava.bio.seq.io.GenEmblPropertyComparator;
import org.biojava.bio.seq.io.GenbankContext;
import org.biojava.bio.seq.io.GenbankFileFormer;
import org.biojava.bio.seq.io.GenpeptFileFormer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.ProteinRefSeqFileFormer;
import org.biojava.bio.seq.io.SeqIOEventEmitter;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class GenbankFormat
implements SequenceFormat,
Serializable,
ParseErrorListener,
ParseErrorSource {
    public static final String DEFAULT = "GENBANK";
    protected static final String LOCUS_TAG = "LOCUS";
    protected static final String SIZE_TAG = "SIZE";
    protected static final String STRAND_NUMBER_TAG = "STRANDS";
    protected static final String TYPE_TAG = "TYPE";
    protected static final String CIRCULAR_TAG = "CIRCULAR";
    protected static final String DIVISION_TAG = "DIVISION";
    protected static final String DATE_TAG = "MDAT";
    protected static final String ACCESSION_TAG = "ACCESSION";
    protected static final String VERSION_TAG = "VERSION";
    protected static final String GI_TAG = "GI";
    protected static final String KEYWORDS_TAG = "KW";
    protected static final String DEFINITION_TAG = "DEFINITION";
    protected static final String SOURCE_TAG = "SOURCE";
    protected static final String ORGANISM_TAG = "ORGANISM";
    protected static final String REFERENCE_TAG = "REFERENCE";
    protected static final String COORDINATE_TAG = "COORDINATE";
    protected static final String REF_ACCESSION_TAG = "";
    protected static final String AUTHORS_TAG = "AUTHORS";
    protected static final String TITLE_TAG = "TITLE";
    protected static final String JOURNAL_TAG = "JOURNAL";
    protected static final String COMMENT_TAG = "COMMENT";
    protected static final String FEATURE_TAG = "FEATURES";
    protected static final String FEATURE_FLAG = "FT";
    protected static final String START_SEQUENCE_TAG = "ORIGIN";
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final String FEATURE_LINE_PREFIX = "     ";
    private Vector mListeners = new Vector();
    private boolean elideSymbols = false;

    /*
     * WARNING - void declaration
     */
    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        String line;
        GenbankContext ctx = new GenbankContext(symParser, listener);
        ctx.addParseErrorListener(this);
        ctx.setElideSymbols(this.getElideSymbols());
        boolean hasAnotherSequence = true;
        boolean hasInternalWhitespace = false;
        listener.startSequence();
        while ((line = reader.readLine()) != null) {
            void var5_7;
            if (var5_7.startsWith(END_SEQUENCE_TAG)) {
                block5: {
                    ctx.processLine((String)var5_7);
                    while (true) {
                        reader.mark(1);
                        int c = reader.read();
                        if (c == -1) {
                            hasAnotherSequence = false;
                            break block5;
                        }
                        if (!Character.isWhitespace((char)c)) break;
                        hasInternalWhitespace = true;
                    }
                    if (hasInternalWhitespace) {
                        System.err.println("Warning: whitespace found between sequence entries");
                    }
                    reader.reset();
                }
                listener.endSequence();
                return hasAnotherSequence;
            }
            ctx.processLine((String)var5_7);
        }
        throw new IOException("Premature end of stream for GENBANK");
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        this.writeSequence(seq, this.getDefaultFormat(), os);
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        AbstractGenEmblFileFormer former;
        if (format.equalsIgnoreCase(DEFAULT)) {
            former = new GenbankFileFormer();
        } else if (format.equalsIgnoreCase("GENPEPT")) {
            former = new GenpeptFileFormer();
        } else if (format.equalsIgnoreCase("REFSEQ:PROTEIN")) {
            former = new ProteinRefSeqFileFormer();
        } else {
            throw new IllegalArgumentException("Unknown format '" + format + "'");
        }
        former.setPrintStream(os);
        SeqIOEventEmitter emitter = new SeqIOEventEmitter(GenEmblPropertyComparator.INSTANCE, GenEmblFeatureComparator.INSTANCE);
        emitter.getSeqIOEvents(seq, (SeqIOListener)((Object)former));
    }

    public String getDefaultFormat() {
        return DEFAULT;
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    public void BadLineParsed(ParseErrorEvent theEvent) {
        this.notifyParseErrorEvent(theEvent);
    }

    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        GenbankFormat genbankFormat = this;
        synchronized (genbankFormat) {
            listeners = (Vector)this.mListeners.clone();
        }
        int lnrCount = listeners.size();
        int index = 0;
        while (index < lnrCount) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
            ++index;
        }
    }

    public boolean getElideSymbols() {
        return this.elideSymbols;
    }

    public void setElideSymbols(boolean elideSymbols) {
        this.elideSymbols = elideSymbols;
    }
}

