/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.regexp.RE;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.AlignmentFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;

public class MSFAlignmentFormat
implements AlignmentFormat {
    private static final boolean DEBUGPRINT = false;
    private static final int DNA = 1;
    private static final int PROTEIN = 2;

    public static void main(String[] args) {
        String filename = args.length < 1 ? "SimpleMSF.msf" : args[0];
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            MSFAlignmentFormat MSFAlignmentFormat1 = new MSFAlignmentFormat();
            MSFAlignmentFormat1.read(reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Alignment read(BufferedReader reader) {
        Vector<String> sequenceNames = new Vector<String>();
        String sequenceName = null;
        String[] sequenceData = null;
        int startOfData = 0;
        int currSeqCount = 0;
        try {
            RE mtc = new RE("Name:\\s+(.*?)\\s+(oo|Len:)");
            RE removewhitespace = new RE("\\s");
            String line = reader.readLine();
            while (line.indexOf("Name:") == -1) {
                line = reader.readLine();
            }
            while (line.indexOf("//") == -1 && line.trim().length() != 0) {
                mtc.match(line);
                sequenceName = line.substring(mtc.getParenStart(1), mtc.getParenEnd(1)).trim();
                if (sequenceName == null || line.trim().length() == 0) break;
                sequenceNames.add(sequenceName);
                line = reader.readLine();
            }
            sequenceData = new String[sequenceNames.size()];
            int it = 0;
            while (it < sequenceNames.size()) {
                sequenceData[it] = new String();
                ++it;
            }
            while (line.indexOf((String)sequenceNames.get(0)) == -1) {
                line = reader.readLine();
            }
            while (line != null) {
                currSeqCount = 0;
                while (currSeqCount < sequenceNames.size()) {
                    if (line.indexOf((String)sequenceNames.get(currSeqCount)) == -1) break;
                    startOfData = line.indexOf((String)sequenceNames.get(currSeqCount)) + ((String)sequenceNames.get(currSeqCount)).length();
                    line = line.substring(startOfData);
                    line = removewhitespace.subst(line, "", 0);
                    sequenceData[currSeqCount] = sequenceData[currSeqCount].concat(line);
                    line = reader.readLine();
                    if (currSeqCount < sequenceNames.size() - 1 && line.trim().length() == 0) break;
                    ++currSeqCount;
                }
                while (line != null && line.indexOf((String)sequenceNames.get(0)) == -1) {
                    line = reader.readLine();
                }
            }
            StringBuffer testString = new StringBuffer();
            int agct = 0;
            currSeqCount = 0;
            while (currSeqCount < sequenceNames.size()) {
                testString.append(sequenceData[currSeqCount]);
                ++currSeqCount;
            }
            StringTokenizer st = null;
            st = new StringTokenizer(testString.toString().toLowerCase(), "a");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "g");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "c");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "t");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "u");
            agct += st.countTokens();
            HashMap<String, SimpleSymbolList> sequenceDataMap = new HashMap<String, SimpleSymbolList>();
            Object sym = null;
            FiniteAlphabet alph = null;
            int i = 0;
            while (i < testString.toString().length()) {
                if (Character.toUpperCase(testString.toString().charAt(i)) == 'F' || Character.toUpperCase(testString.toString().charAt(i)) == 'L' || Character.toUpperCase(testString.toString().charAt(i)) == 'I' || Character.toUpperCase(testString.toString().charAt(i)) == 'P' || Character.toUpperCase(testString.toString().charAt(i)) == 'Q' || Character.toUpperCase(testString.toString().charAt(i)) == 'E') {
                    alph = ProteinTools.getTAlphabet();
                }
                ++i;
            }
            if (alph == null) {
                alph = DNATools.getDNA();
            }
            SymbolTokenization parse = alph.getTokenization("token");
            currSeqCount = 0;
            while (currSeqCount < sequenceNames.size()) {
                String sd = null;
                sd = sequenceData[currSeqCount].replace('~', '-');
                sd = sequenceData[currSeqCount].replace('.', '-');
                StringBuffer sb = new StringBuffer();
                Object sl = null;
                sequenceDataMap.put((String)sequenceNames.get(currSeqCount), new SimpleSymbolList(parse, sd));
                ++currSeqCount;
            }
            return new SimpleAlignment(sequenceDataMap);
        }
        catch (Exception e) {
            System.err.println("MSFFormatReader " + e.getMessage());
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write(OutputStream os, Alignment align, int fileType) throws BioException, IllegalSymbolException {
        out = new PrintStream(os);
        labels = align.getLabels().toArray();
        numSeqs = labels.length;
        seqIts = new Iterator[numSeqs];
        maxLabelLength = 0;
        i = 0;
        while (i < numSeqs) {
            seqIts[i] = align.symbolListForLabel(labels[i]).iterator();
            if (((String)labels[i]).length() > maxLabelLength) {
                maxLabelLength = ((String)labels[i]).length();
            }
            ++i;
        }
        nl = System.getProperty("line.separator");
        toke = null;
        if (fileType == 1) {
            out.println("!!NA_MULTIPLE_ALIGNMENT");
            out.println();
            out.print(" MSF: " + align.length() + "  Type: ");
            out.print("N");
            toke = DNATools.getDNA().getTokenization("token");
        } else if (fileType == 2) {
            out.println("!!AA_MULTIPLE_ALIGNMENT");
            out.println();
            out.print(" MSF: " + align.length() + "  Type: ");
            out.print("P");
            toke = ProteinTools.getTAlphabet().getTokenization("token");
        } else {
            System.out.println("MSFAlignment.write -- File type not recognized.");
            return;
        }
        out.print("  .." + nl);
        out.println();
        i = 0;
        while (i < numSeqs) {
            out.print(" Name: " + labels[i]);
            j = 0;
            while (j < maxLabelLength - ((String)labels[i]).length()) {
                out.print(" ");
                ++j;
            }
            out.print("  Len: " + align.length() + nl);
            ++i;
        }
        out.println("//");
        out.println();
        while (seqIts[0].hasNext()) {
            i = 0;
            ** GOTO lbl66
            {
                labels[i] = " " + labels[i];
                do {
                    if (((String)labels[i]).length() < maxLabelLength + 1) continue block4;
                    out.print(labels[i] + " ");
                    j = 0;
                    block6: while (j < 5) {
                        out.print(" ");
                        k = 0;
                        while (k < 10) {
                            if (!seqIts[i].hasNext()) break block6;
                            out.print(toke.tokenizeSymbol((Symbol)seqIts[i].next()));
                            ++k;
                        }
                        ++j;
                    }
                    out.print(nl);
                    ++i;
lbl66:
                    // 2 sources

                } while (i < numSeqs);
            }
            out.print(nl);
        }
    }

    public void writeDna(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 1);
    }

    public void writeProtein(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 2);
    }
}

