/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.NucleotideTools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaAlignmentFormat;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.MSFAlignmentFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SmartSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.StreamWriter;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public final class SeqIOTools {
    public static final int UNKNOWN = 0;
    public static final int FASTADNA = 1;
    public static final int FASTAPROTEIN = 2;
    public static final int EMBL = 3;
    public static final int GENBANK = 4;
    public static final int SWISSPROT = 5;
    public static final int GENPEPT = 6;
    public static final int MSFDNA = 7;
    public static final int FASTA = 8;
    public static final int FASTAALIGNDNA = 9;
    public static final int MSFPROTEIN = 10;
    public static final int FASTAALIGNPROTEIN = 11;
    public static final int MSF = 12;
    private static SequenceBuilderFactory _emblBuilderFactory;
    private static SequenceBuilderFactory _genbankBuilderFactory;
    private static SequenceBuilderFactory _genpeptBuilderFactory;
    private static SequenceBuilderFactory _swissprotBuilderFactory;
    private static SequenceBuilderFactory _fastaBuilderFactory;

    private SeqIOTools() {
    }

    private static SymbolTokenization getDNAParser() {
        try {
            return DNATools.getDNA().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get DNA token parser");
        }
    }

    private static SymbolTokenization getRNAParser() {
        try {
            return RNATools.getRNA().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get RNA token parser");
        }
    }

    private static SymbolTokenization getNucleotideParser() {
        try {
            return NucleotideTools.getNucleotide().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get nucleotide token parser");
        }
    }

    private static SymbolTokenization getProteinParser() {
        try {
            return ProteinTools.getTAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError(ex, "Assertion failing: Couldn't get PROTEIN token parser");
        }
    }

    public static SequenceBuilderFactory getEmblBuilderFactory() {
        if (_emblBuilderFactory == null) {
            _emblBuilderFactory = new EmblProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _emblBuilderFactory;
    }

    public static SequenceIterator readEmbl(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceIterator readEmblRNA(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getRNAParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceIterator readEmblNucleotide(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getNucleotideParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceBuilderFactory getGenbankBuilderFactory() {
        if (_genbankBuilderFactory == null) {
            _genbankBuilderFactory = new GenbankProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _genbankBuilderFactory;
    }

    public static SequenceIterator readGenbank(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new GenbankFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getGenbankBuilderFactory());
    }

    public static SequenceBuilderFactory getGenpeptBuilderFactory() {
        if (_genpeptBuilderFactory == null) {
            _genpeptBuilderFactory = new GenbankProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _genpeptBuilderFactory;
    }

    public static SequenceIterator readGenpept(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new GenbankFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getGenpeptBuilderFactory());
    }

    public static SequenceBuilderFactory getSwissprotBuilderFactory() {
        if (_swissprotBuilderFactory == null) {
            _swissprotBuilderFactory = new SwissprotProcessor.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _swissprotBuilderFactory;
    }

    public static SequenceIterator readSwissprot(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getSwissprotBuilderFactory());
    }

    public static SequenceBuilderFactory getFastaBuilderFactory() {
        if (_fastaBuilderFactory == null) {
            _fastaBuilderFactory = new FastaDescriptionLineParser.Factory(SmartSequenceBuilder.FACTORY);
        }
        return _fastaBuilderFactory;
    }

    public static SequenceIterator readFastaDNA(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceIterator readFastaRNA(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getRNAParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceIterator readFastaProtein(BufferedReader br) {
        return new StreamReader(br, (SequenceFormat)new FastaFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceDB readFasta(InputStream seqFile, Alphabet alpha) throws BioException {
        HashSequenceDB db = new HashSequenceDB(IDMaker.byName);
        FastaDescriptionLineParser.Factory sbFact = new FastaDescriptionLineParser.Factory(SmartSequenceBuilder.FACTORY);
        FastaFormat fFormat = new FastaFormat();
        StreamReader seqI = new StreamReader(seqFile, (SequenceFormat)fFormat, alpha.getTokenization("token"), (SequenceBuilderFactory)sbFact);
        while (seqI.hasNext()) {
            Sequence seq = seqI.nextSequence();
            try {
                db.addSequence(seq);
            }
            catch (ChangeVetoException cve) {
                throw new NestedError(cve, "Could not successfully add sequence " + seq.getName() + " to sequence database");
            }
        }
        return db;
    }

    public static void writeFasta(OutputStream os, SequenceDB db) throws IOException {
        StreamWriter sw = new StreamWriter(os, new FastaFormat());
        sw.writeStream(db.sequenceIterator());
    }

    public static void writeFasta(OutputStream os, SequenceIterator in) throws IOException {
        StreamWriter sw = new StreamWriter(os, new FastaFormat());
        sw.writeStream(in);
    }

    public static void writeFasta(OutputStream os, Sequence seq) throws IOException {
        SeqIOTools.writeFasta(os, new SingleSeqIterator(seq));
    }

    public static void writeEmbl(OutputStream os, SequenceIterator in) throws IOException {
        StreamWriter sw = new StreamWriter(os, new EmblLikeFormat());
        sw.writeStream(in);
    }

    public static void writeEmbl(OutputStream os, Sequence seq) throws IOException {
        SeqIOTools.writeEmbl(os, new SingleSeqIterator(seq));
    }

    public static void writeSwissprot(OutputStream os, SequenceIterator in) throws IOException, BioException {
        EmblLikeFormat former = new EmblLikeFormat();
        PrintStream ps = new PrintStream(os);
        while (in.hasNext()) {
            former.writeSequence(in.nextSequence(), "Swissprot", ps);
        }
    }

    public static void writeSwissprot(OutputStream os, Sequence seq) throws IOException, BioException {
        SeqIOTools.writeSwissprot(os, new SingleSeqIterator(seq));
    }

    public static void writeGenpept(OutputStream os, SequenceIterator in) throws IOException, BioException {
        GenbankFormat former = new GenbankFormat();
        PrintStream ps = new PrintStream(os);
        while (in.hasNext()) {
            former.writeSequence(in.nextSequence(), "Genpept", ps);
        }
    }

    public static void writeGenpept(OutputStream os, Sequence seq) throws IOException, BioException {
        SeqIOTools.writeGenpept(os, new SingleSeqIterator(seq));
    }

    public static void writeGenbank(OutputStream os, SequenceIterator in) throws IOException {
        StreamWriter sw = new StreamWriter(os, new GenbankFormat());
        sw.writeStream(in);
    }

    public static void writeGenbank(OutputStream os, Sequence seq) throws IOException {
        SeqIOTools.writeGenbank(os, new SingleSeqIterator(seq));
    }

    public static int guessFileType(File seqFile) throws IOException, FileNotFoundException {
        String fileName = seqFile.getName();
        try {
            if (new RE(".*\\u002eem.*").match(fileName)) {
                return 3;
            }
            if (new RE(".*\\u002edat.*").match(fileName)) {
                return 3;
            }
            if (new RE(".*\\u002egb.*").match(fileName)) {
                return 4;
            }
            if (new RE(".*\\u002esp.*").match(fileName)) {
                return 5;
            }
            if (new RE(".*\\u002egp.*").match(fileName)) {
                return 6;
            }
            if (new RE(".*\\u002efa.*").match(fileName)) {
                return SeqIOTools.guessFastaType(seqFile);
            }
            if (new RE(".*\\u002emsf.*").match(fileName)) {
                return SeqIOTools.guessMsfType(seqFile);
            }
        }
        catch (RESyntaxException e) {
            System.out.println("guessFileType -- Problem with regular expression matching for:" + seqFile);
        }
        BufferedReader br = new BufferedReader(new FileReader(seqFile));
        String line1 = br.readLine();
        String line2 = br.readLine();
        br.close();
        if (line1.startsWith(">")) {
            return SeqIOTools.guessFastaType(seqFile);
        }
        if (line1.startsWith("PileUp")) {
            return SeqIOTools.guessMsfType(seqFile);
        }
        if (line1.startsWith("!!AA_MULTIPLE_ALIGNMENT")) {
            return 10;
        }
        if (line1.startsWith("!!NA_MULTIPLE_ALIGNMENT")) {
            return 7;
        }
        if (line1.startsWith("ID")) {
            int i = 0;
            while (i < line1.length()) {
                if (Character.toUpperCase(line1.charAt(i)) == 'P' && Character.toUpperCase(line1.charAt(i + 1)) == 'R' && Character.toUpperCase(line1.charAt(i + 2)) == 'T') {
                    return 5;
                }
                ++i;
            }
            return 3;
        }
        if (line1.toUpperCase().startsWith("LOCUS")) {
            int i = 0;
            while (i < line1.length()) {
                if (Character.toUpperCase(line1.charAt(i)) == 'A' && Character.toUpperCase(line1.charAt(i + 1)) == 'A') {
                    return 6;
                }
                ++i;
            }
            return 4;
        }
        if (line1.length() >= 45 && line1.substring(19, 45).equalsIgnoreCase("GENETIC SEQUENCE DATA BANK")) {
            return SeqIOTools.guessGenType(fileName);
        }
        return 0;
    }

    private static int guessFastaType(File seqFile) throws IOException, FileNotFoundException {
        BufferedReader br = new BufferedReader(new FileReader(seqFile));
        String line = br.readLine();
        line = br.readLine();
        br.close();
        int i = 0;
        while (i < line.length()) {
            if (Character.toUpperCase(line.charAt(i)) == 'F' || Character.toUpperCase(line.charAt(i)) == 'L' || Character.toUpperCase(line.charAt(i)) == 'I' || Character.toUpperCase(line.charAt(i)) == 'P' || Character.toUpperCase(line.charAt(i)) == 'Q' || Character.toUpperCase(line.charAt(i)) == 'E') {
                return 2;
            }
            ++i;
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private static int guessMsfType(File seqFile) throws IOException, FileNotFoundException {
        br = new BufferedReader(new FileReader(seqFile));
        line = br.readLine();
        if (line.startsWith("!!NA_MULTIPLE_ALIGNMENT")) {
            return 7;
        }
        if (!line.startsWith("!!AA_MULTIPLE_ALIGNMENT")) ** GOTO lbl8
        return 10;
lbl-1000:
        // 1 sources

        {
            line = br.readLine();
lbl8:
            // 2 sources

            ** while (line.indexOf((String)"Type: ") == -1)
        }
lbl9:
        // 1 sources

        br.close();
        typeIndex = line.indexOf("Type: ") + 6;
        if (line.substring(typeIndex).startsWith("N")) {
            return 7;
        }
        if (line.substring(typeIndex).startsWith("P")) {
            return 10;
        }
        System.out.println("guessFileType -- Could not guess file type.");
        return 0;
    }

    private static int guessGenType(String fileName) throws IOException, FileNotFoundException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = br.readLine();
        while (line.indexOf("LOCUS") == -1) {
            line = br.readLine();
        }
        br.close();
        int i = 0;
        while (i < line.length()) {
            if (Character.toUpperCase(line.charAt(i)) == 'A' && Character.toUpperCase(line.charAt(i + 1)) == 'A') {
                return 6;
            }
            ++i;
        }
        return 4;
    }

    public static SequenceBuilderFactory fileToFactory(int fileType) throws BioException {
        switch (fileType) {
            case 1: {
                return SeqIOTools.getFastaBuilderFactory();
            }
            case 2: {
                return SeqIOTools.getFastaBuilderFactory();
            }
            case 3: {
                return SeqIOTools.getEmblBuilderFactory();
            }
            case 4: {
                return SeqIOTools.getGenbankBuilderFactory();
            }
            case 5: {
                return SeqIOTools.getSwissprotBuilderFactory();
            }
            case 6: {
                return SeqIOTools.getGenpeptBuilderFactory();
            }
        }
        throw new BioException("Unknown format: " + fileType);
    }

    public static SequenceBuilderFactory formatToFactory(SequenceFormat format, Alphabet alpha) throws BioException {
        if (format instanceof FastaFormat && (alpha == DNATools.getDNA() || alpha == ProteinTools.getAlphabet())) {
            return SeqIOTools.getFastaBuilderFactory();
        }
        if (format instanceof GenbankFormat && alpha == DNATools.getDNA()) {
            return SeqIOTools.getGenbankBuilderFactory();
        }
        if (format instanceof GenbankFormat && alpha == ProteinTools.getAlphabet()) {
            return SeqIOTools.getGenpeptBuilderFactory();
        }
        if (format instanceof EmblLikeFormat && alpha == DNATools.getDNA()) {
            return SeqIOTools.getEmblBuilderFactory();
        }
        if (format instanceof EmblLikeFormat && alpha == ProteinTools.getAlphabet()) {
            return SeqIOTools.getSwissprotBuilderFactory();
        }
        throw new BioException("Unknown combination of Alphabet and Format");
    }

    public static SequenceFormat fileToFormat(int fileType) throws BioException {
        switch (fileType) {
            case 1: {
                return new FastaFormat();
            }
            case 2: {
                return new FastaFormat();
            }
            case 3: {
                return new EmblLikeFormat();
            }
            case 4: {
                return new GenbankFormat();
            }
            case 5: {
                return new EmblLikeFormat();
            }
        }
        throw new BioException("Unknown format: " + fileType);
    }

    public static Object fileToBiojava(int fileType, BufferedReader br) {
        switch (fileType) {
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return SeqIOTools.fileToAlign(fileType, br);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return SeqIOTools.fileToSeq(fileType, br);
            }
        }
        System.out.println("fileToBiojava -- File type not recognized.");
        return null;
    }

    private static Alignment fileToAlign(int fileType, BufferedReader br) {
        switch (fileType) {
            case 7: 
            case 10: 
            case 12: {
                return new MSFAlignmentFormat().read(br);
            }
            case 9: 
            case 11: {
                return new FastaAlignmentFormat().read(br);
            }
        }
        System.out.println("fileToAlign -- File type not recognized.");
        return null;
    }

    private static SequenceIterator fileToSeq(int fileType, BufferedReader br) {
        switch (fileType) {
            case 1: {
                return SeqIOTools.readFastaDNA(br);
            }
            case 2: {
                return SeqIOTools.readFastaProtein(br);
            }
            case 3: {
                return SeqIOTools.readEmbl(br);
            }
            case 4: {
                return SeqIOTools.readGenbank(br);
            }
            case 5: {
                return SeqIOTools.readSwissprot(br);
            }
            case 6: {
                return SeqIOTools.readGenpept(br);
            }
        }
        System.out.println("fileToSeq -- File type not recognized.");
        return null;
    }

    public static void biojavaToFile(int fileType, OutputStream os, Object biojava) throws BioException, IOException, IllegalSymbolException {
        switch (fileType) {
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                SeqIOTools.alignToFile(fileType, os, (Alignment)biojava);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                SeqIOTools.seqToFile(fileType, os, (SequenceIterator)biojava);
                break;
            }
            default: {
                System.out.println("biojavaToFile -- File type not recognized.");
            }
        }
    }

    private static void alignToFile(int fileType, OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        switch (fileType) {
            case 7: {
                new MSFAlignmentFormat().writeDna(os, align);
                break;
            }
            case 10: {
                new MSFAlignmentFormat().writeProtein(os, align);
                break;
            }
            case 9: {
                new FastaAlignmentFormat().writeDna(os, align);
                break;
            }
            case 11: {
                new FastaAlignmentFormat().writeProtein(os, align);
                break;
            }
            default: {
                System.out.println("alignToFile -- File type not recognized.");
            }
        }
    }

    private static void seqToFile(int fileType, OutputStream os, SequenceIterator seq) throws IOException, BioException {
        switch (fileType) {
            case 1: 
            case 2: 
            case 8: {
                SeqIOTools.writeFasta(os, seq);
                break;
            }
            case 3: {
                SeqIOTools.writeEmbl(os, seq);
                break;
            }
            case 5: {
                SeqIOTools.writeSwissprot(os, seq);
                break;
            }
            case 4: {
                SeqIOTools.writeGenbank(os, seq);
                break;
            }
            case 6: {
                SeqIOTools.writeGenpept(os, seq);
                break;
            }
            default: {
                System.out.println("seqToFile -- File type not recognized.");
            }
        }
    }

    private static final class SingleSeqIterator
    implements SequenceIterator {
        private Sequence seq;

        SingleSeqIterator(Sequence seq) {
            this.seq = seq;
        }

        public boolean hasNext() {
            return this.seq != null;
        }

        public Sequence nextSequence() {
            Sequence seq = this.seq;
            this.seq = null;
            return seq;
        }
    }
}

