/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.filterxml;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.filterxml.XMLAnnotationTypeWriter;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.xml.XMLWriter;

public class XMLFilterWriter {
    public static final String XML_FILTER_NS = "http://www.biojava.org/FeatureFilter";
    private static final Class[] NO_ARGS = new Class[0];
    private static final Object[] NO_ARGS_VAL = new Object[0];
    private Map filterWritersByClass = new HashMap();
    private boolean strict = false;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByType;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$BySource;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByClass;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ShadowContainedByLocation;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ShadowOverlapsLocation;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$Not;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$And;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$Or;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$StrandFilter;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$FrameFilter;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByParent;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByAncestor;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByChild;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByDescendant;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$OnlyChildren;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$OnlyDescendants;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByComponentName;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$BySequenceName;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByAnnotation;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$HasAnnotation;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$AnnotationContains;
    static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByPairwiseScore;

    public XMLFilterWriter() {
        try {
            this.filterWritersByClass.put(FeatureFilter.all, new BlankFilterWriter(XML_FILTER_NS, "all"));
            this.filterWritersByClass.put(FeatureFilter.none, new BlankFilterWriter(XML_FILTER_NS, "none"));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByType == null ? (class$org$biojava$bio$seq$FeatureFilter$ByType = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByType")) : class$org$biojava$bio$seq$FeatureFilter$ByType, new StringFilterWriter(XML_FILTER_NS, "byType", (class$org$biojava$bio$seq$FeatureFilter$ByType == null ? (class$org$biojava$bio$seq$FeatureFilter$ByType = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByType")) : class$org$biojava$bio$seq$FeatureFilter$ByType).getMethod("getType", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$BySource == null ? (class$org$biojava$bio$seq$FeatureFilter$BySource = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$BySource")) : class$org$biojava$bio$seq$FeatureFilter$BySource, new StringFilterWriter(XML_FILTER_NS, "bySource", (class$org$biojava$bio$seq$FeatureFilter$BySource == null ? (class$org$biojava$bio$seq$FeatureFilter$BySource = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$BySource")) : class$org$biojava$bio$seq$FeatureFilter$BySource).getMethod("getSource", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByClass == null ? (class$org$biojava$bio$seq$FeatureFilter$ByClass = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByClass")) : class$org$biojava$bio$seq$FeatureFilter$ByClass, new ByClassFilterWriter());
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ContainedByLocation")) : class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation, new LocationFilterWriter(XML_FILTER_NS, "containedByLocation", (class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ContainedByLocation")) : class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation).getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$OverlapsLocation")) : class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation, new LocationFilterWriter(XML_FILTER_NS, "overlapsLocation", (class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$OverlapsLocation")) : class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation).getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ShadowContainedByLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$ShadowContainedByLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ShadowContainedByLocation")) : class$org$biojava$bio$seq$FeatureFilter$ShadowContainedByLocation, new LocationFilterWriter(XML_FILTER_NS, "shadowContainedByLocation", (class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ContainedByLocation")) : class$org$biojava$bio$seq$FeatureFilter$ContainedByLocation).getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ShadowOverlapsLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$ShadowOverlapsLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ShadowOverlapsLocation")) : class$org$biojava$bio$seq$FeatureFilter$ShadowOverlapsLocation, new LocationFilterWriter(XML_FILTER_NS, "shadowOverlapsLocation", (class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation == null ? (class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$OverlapsLocation")) : class$org$biojava$bio$seq$FeatureFilter$OverlapsLocation).getMethod("getLocation", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$Not == null ? (class$org$biojava$bio$seq$FeatureFilter$Not = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$Not")) : class$org$biojava$bio$seq$FeatureFilter$Not, new FilterFilterWriter(XML_FILTER_NS, "not", (class$org$biojava$bio$seq$FeatureFilter$Not == null ? (class$org$biojava$bio$seq$FeatureFilter$Not = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$Not")) : class$org$biojava$bio$seq$FeatureFilter$Not).getMethod("getChild", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$And == null ? (class$org$biojava$bio$seq$FeatureFilter$And = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$And")) : class$org$biojava$bio$seq$FeatureFilter$And, new AndFilterWriter());
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$Or == null ? (class$org$biojava$bio$seq$FeatureFilter$Or = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$Or")) : class$org$biojava$bio$seq$FeatureFilter$Or, new OrFilterWriter());
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$StrandFilter == null ? (class$org$biojava$bio$seq$FeatureFilter$StrandFilter = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$StrandFilter")) : class$org$biojava$bio$seq$FeatureFilter$StrandFilter, new StrandFilterWriter());
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$FrameFilter == null ? (class$org$biojava$bio$seq$FeatureFilter$FrameFilter = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$FrameFilter")) : class$org$biojava$bio$seq$FeatureFilter$FrameFilter, new FrameFilterWriter());
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByParent == null ? (class$org$biojava$bio$seq$FeatureFilter$ByParent = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByParent")) : class$org$biojava$bio$seq$FeatureFilter$ByParent, new FilterFilterWriter(XML_FILTER_NS, "byParent", (class$org$biojava$bio$seq$FeatureFilter$ByParent == null ? (class$org$biojava$bio$seq$FeatureFilter$ByParent = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByParent")) : class$org$biojava$bio$seq$FeatureFilter$ByParent).getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByAncestor == null ? (class$org$biojava$bio$seq$FeatureFilter$ByAncestor = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByAncestor")) : class$org$biojava$bio$seq$FeatureFilter$ByAncestor, new FilterFilterWriter(XML_FILTER_NS, "byAncestor", (class$org$biojava$bio$seq$FeatureFilter$ByAncestor == null ? (class$org$biojava$bio$seq$FeatureFilter$ByAncestor = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByAncestor")) : class$org$biojava$bio$seq$FeatureFilter$ByAncestor).getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByChild == null ? (class$org$biojava$bio$seq$FeatureFilter$ByChild = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByChild")) : class$org$biojava$bio$seq$FeatureFilter$ByChild, new FilterFilterWriter(XML_FILTER_NS, "byChild", (class$org$biojava$bio$seq$FeatureFilter$ByChild == null ? (class$org$biojava$bio$seq$FeatureFilter$ByChild = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByChild")) : class$org$biojava$bio$seq$FeatureFilter$ByChild).getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByDescendant == null ? (class$org$biojava$bio$seq$FeatureFilter$ByDescendant = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByDescendant")) : class$org$biojava$bio$seq$FeatureFilter$ByDescendant, new FilterFilterWriter(XML_FILTER_NS, "byDescendant", (class$org$biojava$bio$seq$FeatureFilter$ByDescendant == null ? (class$org$biojava$bio$seq$FeatureFilter$ByDescendant = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByDescendant")) : class$org$biojava$bio$seq$FeatureFilter$ByDescendant).getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$OnlyChildren == null ? (class$org$biojava$bio$seq$FeatureFilter$OnlyChildren = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$OnlyChildren")) : class$org$biojava$bio$seq$FeatureFilter$OnlyChildren, new FilterFilterWriter(XML_FILTER_NS, "onlyChildren", (class$org$biojava$bio$seq$FeatureFilter$OnlyChildren == null ? (class$org$biojava$bio$seq$FeatureFilter$OnlyChildren = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$OnlyChildren")) : class$org$biojava$bio$seq$FeatureFilter$OnlyChildren).getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$OnlyDescendants == null ? (class$org$biojava$bio$seq$FeatureFilter$OnlyDescendants = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$OnlyDescendants")) : class$org$biojava$bio$seq$FeatureFilter$OnlyDescendants, new FilterFilterWriter(XML_FILTER_NS, "onlyDescendants", (class$org$biojava$bio$seq$FeatureFilter$OnlyDescendants == null ? (class$org$biojava$bio$seq$FeatureFilter$OnlyDescendants = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$OnlyDescendants")) : class$org$biojava$bio$seq$FeatureFilter$OnlyDescendants).getMethod("getFilter", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByComponentName == null ? (class$org$biojava$bio$seq$FeatureFilter$ByComponentName = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByComponentName")) : class$org$biojava$bio$seq$FeatureFilter$ByComponentName, new StringFilterWriter(XML_FILTER_NS, "byComponentName", (class$org$biojava$bio$seq$FeatureFilter$ByComponentName == null ? (class$org$biojava$bio$seq$FeatureFilter$ByComponentName = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByComponentName")) : class$org$biojava$bio$seq$FeatureFilter$ByComponentName).getMethod("getComponentName", NO_ARGS)));
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$BySequenceName == null ? (class$org$biojava$bio$seq$FeatureFilter$BySequenceName = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$BySequenceName")) : class$org$biojava$bio$seq$FeatureFilter$BySequenceName, new StringFilterWriter(XML_FILTER_NS, "bySequenceName", (class$org$biojava$bio$seq$FeatureFilter$BySequenceName == null ? (class$org$biojava$bio$seq$FeatureFilter$BySequenceName = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$BySequenceName")) : class$org$biojava$bio$seq$FeatureFilter$BySequenceName).getMethod("getSequenceName", NO_ARGS)));
            this.filterWritersByClass.put(FeatureFilter.top_level, new BlankFilterWriter(XML_FILTER_NS, "isTopLevel"));
            this.filterWritersByClass.put(FeatureFilter.leaf, new BlankFilterWriter(XML_FILTER_NS, "isLeaf"));
            AnnotationTypeFilterWriter atfw = new AnnotationTypeFilterWriter(new XMLAnnotationTypeWriter());
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType == null ? (class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByAnnotationType")) : class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType, atfw);
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByAnnotation == null ? (class$org$biojava$bio$seq$FeatureFilter$ByAnnotation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByAnnotation")) : class$org$biojava$bio$seq$FeatureFilter$ByAnnotation, atfw);
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$HasAnnotation == null ? (class$org$biojava$bio$seq$FeatureFilter$HasAnnotation = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$HasAnnotation")) : class$org$biojava$bio$seq$FeatureFilter$HasAnnotation, atfw);
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$AnnotationContains == null ? (class$org$biojava$bio$seq$FeatureFilter$AnnotationContains = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$AnnotationContains")) : class$org$biojava$bio$seq$FeatureFilter$AnnotationContains, atfw);
            this.filterWritersByClass.put(class$org$biojava$bio$seq$FeatureFilter$ByPairwiseScore == null ? (class$org$biojava$bio$seq$FeatureFilter$ByPairwiseScore = XMLFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByPairwiseScore")) : class$org$biojava$bio$seq$FeatureFilter$ByPairwiseScore, new ByPairwiseScoreFilterWriter());
        }
        catch (Exception ex) {
            throw new BioError(ex, "Assertion failed: couldn't initialize XMLFilterWriters");
        }
    }

    public void addXMLFilterWriter(Class clazz, FilterWriter xfw) {
        this.filterWritersByClass.put(clazz, xfw);
    }

    public void addXMLFilterWriter(FeatureFilter ff, FilterWriter xfw) {
        this.filterWritersByClass.put(ff, xfw);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIsStrict(boolean b) {
        this.strict = b;
    }

    public void writeFilter(FeatureFilter ff, XMLWriter xw) throws IllegalArgumentException, IOException {
        FilterWriter xfw = (FilterWriter)this.filterWritersByClass.get(ff);
        if (xfw == null) {
            xfw = (FilterWriter)this.filterWritersByClass.get(ff.getClass());
        }
        if (xfw != null) {
            try {
                xfw.writeFilter(ff, xw, this);
            }
            catch (ClassCastException ex) {
                throw new BioError(ex, "Filter type mismatch");
            }
        } else {
            if (this.strict) {
                throw new IllegalArgumentException("Couldn't find a writer for filter of type " + ff.getClass().getName());
            }
            this.writeFilter(FeatureFilter.all, xw);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AnnotationTypeFilterWriter
    extends PropertyFilterWriter {
        private XMLAnnotationTypeWriter xatw;
        static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType;

        AnnotationTypeFilterWriter(XMLAnnotationTypeWriter xatw) throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byAnnotationType", (class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType == null ? (class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType = AnnotationTypeFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByAnnotationType")) : class$org$biojava$bio$seq$FeatureFilter$ByAnnotationType).getMethod("getType", NO_ARGS));
            this.xatw = xatw;
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            this.xatw.writeAnnotationType((AnnotationType)obj, xw);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class FrameFilterWriter
    extends PropertyFilterWriter {
        static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$FrameFilter;

        FrameFilterWriter() throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byFrame", (class$org$biojava$bio$seq$FeatureFilter$FrameFilter == null ? (class$org$biojava$bio$seq$FeatureFilter$FrameFilter = FrameFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$FrameFilter")) : class$org$biojava$bio$seq$FeatureFilter$FrameFilter).getMethod("getFrame", NO_ARGS));
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print("" + ((FramedFeature.ReadingFrame)obj).getFrame());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class StrandFilterWriter
    extends PropertyFilterWriter {
        static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$StrandFilter;

        StrandFilterWriter() throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byStrand", (class$org$biojava$bio$seq$FeatureFilter$StrandFilter == null ? (class$org$biojava$bio$seq$FeatureFilter$StrandFilter = StrandFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$StrandFilter")) : class$org$biojava$bio$seq$FeatureFilter$StrandFilter).getMethod("getStrand", NO_ARGS));
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print(((StrandedFeature.Strand)obj).toString());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class ByClassFilterWriter
    extends PropertyFilterWriter {
        static /* synthetic */ Class class$org$biojava$bio$seq$FeatureFilter$ByClass;

        ByClassFilterWriter() throws NoSuchMethodException {
            super(XMLFilterWriter.XML_FILTER_NS, "byClass", (class$org$biojava$bio$seq$FeatureFilter$ByClass == null ? (class$org$biojava$bio$seq$FeatureFilter$ByClass = ByClassFilterWriter.class$("org.biojava.bio.seq.FeatureFilter$ByClass")) : class$org$biojava$bio$seq$FeatureFilter$ByClass).getMethod("getTestClass", NO_ARGS));
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print(((Class)obj).getName());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class ByPairwiseScoreFilterWriter
    implements FilterWriter {
        private ByPairwiseScoreFilterWriter() {
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            FeatureFilter.ByPairwiseScore scoreFilter = (FeatureFilter.ByPairwiseScore)ff;
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "byPairwiseScore");
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "minScore");
            xw.print("" + scoreFilter.getMinScore());
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "minScore");
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "maxScore");
            xw.print("" + scoreFilter.getMaxScore());
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "maxScore");
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "byPairwiseScore");
        }
    }

    private static class OrFilterWriter
    implements FilterWriter {
        private OrFilterWriter() {
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            FeatureFilter.Or ffa = (FeatureFilter.Or)ff;
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "or");
            this.writeSubFilter(ff, xw, config);
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "or");
        }

        private void writeSubFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (ff instanceof FeatureFilter.Or) {
                FeatureFilter.Or ffa = (FeatureFilter.Or)ff;
                this.writeSubFilter(ffa.getChild1(), xw, config);
                this.writeSubFilter(ffa.getChild2(), xw, config);
            } else {
                config.writeFilter(ff, xw);
            }
        }
    }

    private static class AndFilterWriter
    implements FilterWriter {
        private AndFilterWriter() {
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            FeatureFilter.And ffa = (FeatureFilter.And)ff;
            xw.openTag(XMLFilterWriter.XML_FILTER_NS, "and");
            this.writeSubFilter(ff, xw, config);
            xw.closeTag(XMLFilterWriter.XML_FILTER_NS, "and");
        }

        private void writeSubFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (ff instanceof FeatureFilter.And) {
                FeatureFilter.And ffa = (FeatureFilter.And)ff;
                this.writeSubFilter(ffa.getChild1(), xw, config);
                this.writeSubFilter(ffa.getChild2(), xw, config);
            } else {
                config.writeFilter(ff, xw);
            }
        }
    }

    private static class FilterFilterWriter
    extends PropertyFilterWriter {
        FilterFilterWriter(String nsURI, String localName, Method propMethod) {
            super(nsURI, localName, propMethod);
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            FeatureFilter ff = (FeatureFilter)obj;
            config.writeFilter(ff, xw);
        }
    }

    private static class LocationFilterWriter
    extends PropertyFilterWriter {
        LocationFilterWriter(String nsURI, String localName, Method propMethod) {
            super(nsURI, localName, propMethod);
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            Location l = (Location)obj;
            Iterator i = l.blockIterator();
            while (i.hasNext()) {
                Location block = (Location)i.next();
                xw.openTag("span");
                xw.attribute("start", "" + block.getMin());
                xw.attribute("stop", "" + block.getMax());
                xw.closeTag("span");
            }
        }
    }

    private static class StringFilterWriter
    extends PropertyFilterWriter {
        StringFilterWriter(String nsURI, String localName, Method propMethod) {
            super(nsURI, localName, propMethod);
        }

        protected void writeContent(Object obj, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.print(obj.toString());
        }
    }

    private static abstract class PropertyFilterWriter
    implements FilterWriter {
        private final String nsURI;
        private final String localName;
        private final Method propMethod;

        PropertyFilterWriter(String nsURI, String localName, Method propMethod) {
            this.nsURI = nsURI;
            this.localName = localName;
            this.propMethod = propMethod;
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            try {
                Object obj = this.propMethod.invoke((Object)ff, NO_ARGS_VAL);
                xw.openTag(this.nsURI, this.localName);
                this.writeContent(obj, xw, config);
                xw.closeTag(this.nsURI, this.localName);
            }
            catch (IllegalAccessException ex) {
                throw new BioError(ex, "Can't access property method");
            }
            catch (InvocationTargetException ex) {
                throw new BioError(ex, "Coudln't access property");
            }
        }

        protected abstract void writeContent(Object var1, XMLWriter var2, XMLFilterWriter var3) throws ClassCastException, IllegalArgumentException, IOException;
    }

    private static class BlankFilterWriter
    implements FilterWriter {
        private String nsURI;
        private String localName;

        BlankFilterWriter(String nsURI, String localName) {
            this.nsURI = nsURI;
            this.localName = localName;
        }

        public void writeFilter(FeatureFilter ff, XMLWriter xw, XMLFilterWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.openTag(this.nsURI, this.localName);
            xw.closeTag(this.nsURI, this.localName);
        }
    }

    public static interface FilterWriter {
        public void writeFilter(FeatureFilter var1, XMLWriter var2, XMLFilterWriter var3) throws ClassCastException, IllegalArgumentException, IOException;
    }
}

