/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import org.biojava.bio.BioError;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.projection.ProjectedFeature;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;

public class ProjectedStrandedFeature
extends ProjectedFeature
implements StrandedFeature {
    public ProjectedStrandedFeature(StrandedFeature f, ProjectionContext ctx) {
        super(f, ctx);
    }

    public StrandedFeature.Strand getStrand() {
        return this.getProjectionContext().getStrand((StrandedFeature)this.getViewedFeature());
    }

    public Feature.Template makeTemplate() {
        StrandedFeature.Template sft = (StrandedFeature.Template)super.makeTemplate();
        sft.strand = this.getStrand();
        return sft;
    }

    public String toString() {
        String pm = this.getStrand() == StrandedFeature.POSITIVE ? "+" : (this.getStrand() == StrandedFeature.NEGATIVE ? "-" : " ");
        return "Feature " + this.getType() + " " + this.getSource() + " " + this.getLocation() + " " + pm;
    }

    public SymbolList getSymbols() {
        SymbolList symList = super.getSymbols();
        if (this.getStrand() == StrandedFeature.NEGATIVE) {
            try {
                symList = DNATools.reverseComplement(symList);
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError(iae, "Could not retrieve symbols for feature as the alphabet can not be complemented.");
            }
        }
        return symList;
    }
}

