/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractSymbolList
extends AbstractChangeable
implements SymbolList {
    private volatile int hashCode = 0;

    protected AbstractSymbolList() {
    }

    public Iterator iterator() {
        return new SymbolIterator(1, this.length());
    }

    public SymbolList subList(int start, int end) {
        if (start < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
        }
        return new SubList(start, end);
    }

    public List toList() {
        return new ListView(this);
    }

    public String seqString() {
        try {
            SymbolTokenization toke = this.getAlphabet().getTokenization("token");
            return toke.tokenizeSymbolList(this);
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex, "Couldn't tokenize sequence");
        }
    }

    public String subStr(int start, int end) {
        return this.subList(start, end).seqString();
    }

    public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
        throw new ChangeVetoException("AbstractSymbolList is immutable");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SymbolList)) {
            return false;
        }
        return this.compare(this, (SymbolList)o);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                result = 37 * result + i.next().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    private boolean compare(SymbolList sl1, SymbolList sl2) {
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator si1 = sl1.iterator();
        Iterator si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }

    public abstract Symbol symbolAt(int var1) throws IndexOutOfBoundsException;

    public abstract int length();

    public abstract Alphabet getAlphabet();

    public class EditTranslater
    extends EditScreener {
        public EditTranslater(Object source, ChangeSupport cs, int min, int max) {
            super(source, cs, min, max);
        }

        protected ChangeEvent generateEvent(ChangeEvent ce) {
            if ((ce = super.generateEvent(ce)) != null) {
                Edit edit = (Edit)ce.getChange();
                return new ChangeEvent(ce.getSource(), ce.getType(), new Edit(edit.pos - this.min, edit.length, edit.replacement), null, ce.getChainedEvent());
            }
            return null;
        }
    }

    public class EditScreener
    extends ChangeForwarder {
        protected final int min;
        protected final int max;

        public EditScreener(Object source, ChangeSupport cs, int min, int max) {
            super(source, cs);
            this.min = min;
            this.max = max;
        }

        protected ChangeEvent generateEvent(ChangeEvent ce) {
            Object change;
            ChangeType ct = ce.getType();
            if (ct == SymbolList.EDIT && (change = ce.getChange()) != null && change instanceof Edit) {
                Edit edit = (Edit)change;
                int start = edit.pos;
                int end = start + edit.length - 1;
                if (start <= this.max && end >= this.min) {
                    return new ChangeEvent(this.getSource(), ct, edit, null, ce);
                }
            }
            return null;
        }
    }

    private static class ListView
    extends AbstractList
    implements Serializable {
        private SymbolList rl;

        ListView(SymbolList symList) {
            this.rl = symList;
        }

        public Object get(int pos) {
            return this.rl.symbolAt(pos + 1);
        }

        public int size() {
            return this.rl.length();
        }
    }

    private class SubList
    extends AbstractChangeable
    implements SymbolList,
    Serializable {
        private int start;
        private int end;
        private transient EditTranslater editTranslater = null;
        private transient Annotatable.AnnotationForwarder annotationForwarder = null;
        private volatile int hashCode = 0;

        public SubList(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public Alphabet getAlphabet() {
            return AbstractSymbolList.this.getAlphabet();
        }

        public Iterator iterator() {
            return new SymbolIterator(this.start, this.end);
        }

        public int length() {
            return this.end - this.start + 1;
        }

        public Symbol symbolAt(int pos) {
            if (pos < 1 || pos > this.length()) {
                throw new IndexOutOfBoundsException("Symbol index out of bounds " + this.length() + ":" + pos);
            }
            return AbstractSymbolList.this.symbolAt(pos + this.start - 1);
        }

        public SymbolList subList(int sstart, int send) {
            if (sstart < 1 || send > this.length()) {
                throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + this.start + "," + send);
            }
            if (send < sstart) {
                throw new IndexOutOfBoundsException("send must not be lower than sstart: sstart=" + this.start + ", send=" + send);
            }
            return new SubList(sstart + this.start - 1, send + this.start - 1);
        }

        public String seqString() {
            try {
                SymbolTokenization toke = this.getAlphabet().getTokenization("token");
                return toke.tokenizeSymbolList(this);
            }
            catch (BioException ex) {
                throw new BioRuntimeException(ex, "Couldn't tokenize sequence");
            }
        }

        public String subStr(int start, int end) {
            return this.subList(start, end).seqString();
        }

        public List toList() {
            return new ListView(this);
        }

        public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
            AbstractSymbolList.this.edit(new Edit(edit.pos + this.start - 1, edit.length, edit.replacement));
        }

        protected ChangeSupport getChangeSupport(ChangeType changeType) {
            ChangeSupport cs = super.getChangeSupport(changeType);
            if ((changeType == null || changeType == SymbolList.EDIT) && this.editTranslater == null) {
                this.editTranslater = new EditTranslater(this, cs, this.start, this.end);
                AbstractSymbolList.this.addChangeListener(this.editTranslater, SymbolList.EDIT);
            }
            if ((changeType == null || changeType == Annotation.PROPERTY) && this.annotationForwarder == null) {
                this.annotationForwarder = new Annotatable.AnnotationForwarder(this, cs);
                AbstractSymbolList.this.addChangeListener(this.annotationForwarder, Annotation.PROPERTY);
            }
            return cs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof SymbolList)) {
                return false;
            }
            return AbstractSymbolList.this.compare(this, (SymbolList)o);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    result = 37 * result + i.next().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }

    private class SymbolIterator
    implements Iterator,
    Serializable {
        private int min;
        private int max;
        private int pos;

        public SymbolIterator(int min, int max) {
            this.min = min;
            this.max = max;
            this.pos = min;
        }

        protected SymbolIterator() {
        }

        public boolean hasNext() {
            return this.pos <= this.max;
        }

        public Object next() {
            if (this.pos > this.max) {
                throw new NoSuchElementException();
            }
            return AbstractSymbolList.this.symbolAt(this.pos++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

