/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractLocationDecorator;
import org.biojava.bio.symbol.CircularLocationTools;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class CircularLocation
extends AbstractLocationDecorator {
    private final int length;
    private final boolean overlaps;

    public final int getLength() {
        return this.length;
    }

    public boolean overlapsOrigin() {
        return this.overlaps;
    }

    public CircularLocation(Location wrapped, int length) {
        super(wrapped);
        this.length = length;
        this.overlaps = CircularLocationTools.overlapsOrigin(this);
    }

    protected Location decorate(Location loc) {
        return new CircularLocation(loc, this.getLength());
    }

    public boolean contains(int p) {
        int pp = p % this.getLength() + super.getMin() / this.getLength();
        return this.getWrapped().contains(pp);
    }

    public Location intersection(Location l) {
        return LocationTools.intersection(this, l);
    }

    public boolean overlaps(Location l) {
        return LocationTools.overlaps(this, l);
    }

    public Location union(Location l) {
        return LocationTools.union(this, l);
    }

    public boolean contains(Location l) {
        return LocationTools.contains(this, l);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        return LocationTools.areEqual(this, (Location)o);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getWrapped().toString());
        sb.append("  (circular)");
        return sb.toString();
    }

    public boolean isContiguous() {
        return this.getWrapped().isContiguous();
    }

    public SymbolList symbols(SymbolList seq) {
        if (this.getWrapped() instanceof CompoundLocation && this.overlapsOrigin()) {
            SimpleSymbolList syms;
            CompoundLocation loc = (CompoundLocation)this.getWrapped();
            LinkedList ll = new LinkedList(loc.getBlockList());
            Object o = ll.removeFirst();
            ll.addLast(o);
            ArrayList residues = new ArrayList();
            ListIterator i = ll.listIterator();
            while (i.hasNext()) {
                Location subloc = (Location)i.next();
                residues.addAll(seq.subList(subloc.getMin(), subloc.getMax()).toList());
            }
            try {
                syms = new SimpleSymbolList(seq.getAlphabet(), residues);
            }
            catch (IllegalSymbolException ex) {
                throw new BioError(ex, "Failure to build a SymbolList from its own Symbols!?");
            }
            return syms;
        }
        if (this.overlapsOrigin()) {
            SimpleSymbolList syms;
            if (this.getMin() == 1 && this.getMax() == this.length) {
                return seq;
            }
            ArrayList l = new ArrayList(seq.subList(this.getMin(), seq.length()).toList());
            l.addAll(seq.subList(1, this.getMax()).toList());
            try {
                syms = new SimpleSymbolList(seq.getAlphabet(), l);
            }
            catch (IllegalSymbolException ex) {
                throw new BioError(ex, "Failure to build a SymbolList from its own Symbols!?");
            }
            return syms;
        }
        return super.symbols(seq);
    }
}

