/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.symbol.AbstractRangeLocation;
import org.biojava.bio.symbol.CircularLocation;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.MergeLocation;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

final class CircularLocationTools {
    CircularLocationTools() {
    }

    private static int realValue(int val, int length) {
        if ((val %= length) < 1) {
            val = length + val;
        }
        return val;
    }

    protected static CircularLocation makeCircLoc(int min, int max, int seqLength) {
        int rmax;
        if (min == max) {
            return new CircularLocation(new PointLocation(min), seqLength);
        }
        boolean overlap = false;
        int rmin = CircularLocationTools.realValue(min, seqLength);
        if (rmin > (rmax = CircularLocationTools.realValue(max, seqLength))) {
            overlap = true;
            rmax += seqLength;
        }
        if (!overlap) {
            RangeLocation loc = new RangeLocation(rmin, rmax);
            return new CircularLocation(loc, seqLength);
        }
        AbstractRangeLocation locB = rmin == seqLength ? new PointLocation(rmin) : new RangeLocation(rmin, seqLength);
        AbstractRangeLocation locA = rmax - seqLength == 1 ? new PointLocation(1) : new RangeLocation(1, rmax - seqLength);
        Location compound = LocationTools.union(locA, locB);
        return new CircularLocation(compound, seqLength);
    }

    static Location intersection(Location locA, Location locB) {
        if (!(locA instanceof CircularLocation)) {
            if (locA == Location.empty) {
                return Location.empty;
            }
            throw new BioError("Assertion failure: not circular");
        }
        int circularityA = ((CircularLocation)locA).getLength();
        Location rawA = ((CircularLocation)locA).getWrapped();
        if (!(locA instanceof CircularLocation)) {
            if (locB == Location.empty) {
                return Location.empty;
            }
            throw new BioError("Assertion failure: not circular");
        }
        int circularityB = ((CircularLocation)locB).getLength();
        Location rawB = ((CircularLocation)locB).getWrapped();
        if (circularityA != circularityB) {
            throw new BioRuntimeException("Can't find intersection of locations on circular sequences of non-equal length");
        }
        Location intersect = LocationTools.intersection(rawA, rawB);
        if (intersect != Location.empty) {
            intersect = new CircularLocation(intersect, circularityA);
        }
        return intersect;
    }

    protected static CircularLocation union(CircularLocation locA, CircularLocation locB) {
        int length = locA.getLength();
        if (locA.isContiguous() && locB.isContiguous() && locA.overlaps(locB)) {
            MergeLocation temp;
            try {
                temp = MergeLocation.mergeLocations(locA, locB);
            }
            catch (BioException ex) {
                throw new BioError(ex, "Assertion Error, cannot build MergeLocation");
            }
            return new CircularLocation(temp, length);
        }
        ArrayList locList = new ArrayList();
        Iterator i = locA.blockIterator();
        while (i.hasNext()) {
            locList.add(i.next());
        }
        Iterator i2 = locB.blockIterator();
        while (i2.hasNext()) {
            locList.add(i2.next());
        }
        Location temp = LocationTools._union(locList);
        return new CircularLocation(temp, length);
    }

    protected static boolean overlapsOrigin(CircularLocation loc) {
        if (loc.getWrapped() instanceof CompoundLocation) {
            boolean min = false;
            boolean max = false;
            Iterator i = loc.blockIterator();
            while (i.hasNext()) {
                Location l = (Location)i.next();
                if (l.getMax() == loc.getLength()) {
                    max = true;
                }
                if (l.getMin() != 1) continue;
                min = true;
            }
            return min && max;
        }
        return loc.getMin() == 1 && loc.getMax() == loc.getLength();
    }

    protected static boolean isCircular(Location loc) {
        boolean toReturn = false;
        try {
            if (loc.getDecorator(Class.forName("org.biojava.bio.symbol.CircularLocation")) != null) {
                toReturn = true;
            }
        }
        catch (Exception e) {
            throw new BioError("class org.biojava.bio.symbol.BetweenLocation could not be loaded");
        }
        return toReturn;
    }

    public static boolean safeOperation(Location locA, Location locB) {
        if (CircularLocationTools.isCircular(locA) && CircularLocationTools.isCircular(locB)) {
            return ((CircularLocation)locA).getLength() == ((CircularLocation)locB).getLength();
        }
        return false;
    }
}

