/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.DoubleTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.SingletonList;
import org.biojava.utils.StaticMemberPlaceHolder;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.cache.WeakValueHashMap;

public final class DoubleAlphabet
extends Unchangeable
implements Alphabet,
Serializable {
    public static DoubleAlphabet INSTANCE;
    private List alphabets = null;
    private WeakValueHashMap doubleToSym = new WeakValueHashMap();
    static /* synthetic */ Class class$org$biojava$bio$symbol$DoubleAlphabet;

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$DoubleAlphabet == null ? (class$org$biojava$bio$symbol$DoubleAlphabet = DoubleAlphabet.class$("org.biojava.bio.symbol.DoubleAlphabet")) : class$org$biojava$bio$symbol$DoubleAlphabet).getField("INSTANCE"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }

    public static SymbolList fromArray(double[] dArray) {
        return new DoubleArray(dArray);
    }

    public static DoubleAlphabet getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DoubleAlphabet();
        }
        return INSTANCE;
    }

    private DoubleAlphabet() {
    }

    public DoubleSymbol getSymbol(double val) {
        Double d = new Double(val);
        DoubleSymbol sym = (DoubleSymbol)this.doubleToSym.get(d);
        if (sym == null) {
            sym = new DoubleSymbol(val);
            this.doubleToSym.put(d, sym);
        }
        return sym;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public boolean contains(Symbol s) {
        return s instanceof DoubleSymbol;
    }

    public void validate(Symbol s) throws IllegalSymbolException {
        if (!this.contains(s)) {
            throw new IllegalSymbolException("Only symbols of type DoubleAlphabet.DoubleSymbol are valid for this alphabet.\n(" + s.getClass() + ") " + s.getName());
        }
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    public Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
        Iterator i = syms.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            this.validate(sym);
        }
        throw new BioError("Operation not implemented");
    }

    public Symbol getSymbol(List symList) throws IllegalSymbolException {
        if (symList.size() != 1) {
            throw new IllegalSymbolException("Can't build symbol from list " + symList.size() + " long");
        }
        Symbol s = (Symbol)symList.get(0);
        this.validate(s);
        return s;
    }

    public String getName() {
        return "Alphabet of all doubles.";
    }

    public SymbolTokenization getTokenization(String name) {
        if (!name.equals("name")) {
            throw new NoSuchElementException("No parsers supported by DoubleAlphabet called " + name);
        }
        return new DoubleTokenization();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DoubleArray
    extends AbstractSymbolList
    implements Serializable {
        private final double[] dArray;

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public Symbol symbolAt(int i) {
            return new DoubleSymbol(this.dArray[i - 1]);
        }

        public int length() {
            return this.dArray.length;
        }

        public DoubleArray(double[] dArray) {
            this.dArray = dArray;
        }
    }

    public static class DoubleSymbol
    extends Unchangeable
    implements AtomicSymbol,
    Serializable {
        private final double val;
        private final Alphabet matches;

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public String getName() {
            return this.val + "";
        }

        public double doubleValue() {
            return this.val;
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        protected DoubleSymbol(double val) {
            this.val = val;
            this.matches = new SingletonAlphabet(this);
        }
    }
}

