/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.taxa;

import java.util.Set;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.taxa.Taxon;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractTaxon
extends AbstractChangeable
implements Taxon {
    private transient ChangeListener annotationForwarder;
    private Annotation ann;
    private String commonName;
    private String scientificName;

    protected AbstractTaxon() {
    }

    protected AbstractTaxon(String scientificName, String commonName) {
        this.scientificName = scientificName;
        this.commonName = commonName;
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.annotationForwarder == null && (ct == null || ct == Annotatable.ANNOTATION)) {
            this.annotationForwarder = new Annotatable.AnnotationForwarder(this, cs);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        return cs;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) throws ChangeVetoException {
        if (this.commonName != null) {
            throw new ChangeVetoException("Common name already set to: " + this.commonName + " so you can't set it to: " + commonName);
        }
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(Taxon.CHANGE_COMMON_NAME);
            ChangeEvent cevt = new ChangeEvent(this, Taxon.CHANGE_COMMON_NAME, commonName);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(cevt);
                this.commonName = commonName;
                cs.firePostChangeEvent(cevt);
            }
        } else {
            this.commonName = commonName;
        }
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) throws ChangeVetoException {
        if (this.scientificName != null) {
            throw new ChangeVetoException("Common name already set to: " + this.scientificName + " so you can't set it to: " + scientificName);
        }
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(Taxon.CHANGE_SCIENTIFIC_NAME);
            ChangeEvent cevt = new ChangeEvent(this, Taxon.CHANGE_SCIENTIFIC_NAME, scientificName);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(cevt);
                this.scientificName = scientificName;
                cs.firePostChangeEvent(cevt);
            }
        } else {
            this.scientificName = scientificName;
        }
    }

    public Annotation getAnnotation() {
        if (this.ann == null) {
            this.ann = new SmallAnnotation();
        }
        return this.ann;
    }

    public boolean equals(Object o) {
        if (o instanceof Taxon) {
            Taxon t = (Taxon)o;
            return this == t || this.safeEq(this.getScientificName(), t.getScientificName()) && this.safeEq(this.getCommonName(), t.getCommonName()) && this.safeEq(this.getChildren(), t.getChildren());
        }
        return false;
    }

    public String toString() {
        Taxon parent = this.getParent();
        String scientificName = this.getScientificName();
        if (parent != null) {
            return parent.toString() + " -> " + scientificName;
        }
        return scientificName;
    }

    public int hashCode() {
        return this.getScientificName().hashCode();
    }

    private boolean safeEq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public abstract Set getChildren();

    public abstract Taxon getParent();
}

