/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.taxa;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.biojava.bio.taxa.CircularReferenceException;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.TaxonFactory;
import org.biojava.bio.taxa.TaxonParser;
import org.biojava.utils.ChangeVetoException;

public class EbiFormat
implements TaxonParser {
    public static final String PROPERTY_NCBI_TAXON = (class$org$biojava$bio$taxa$EbiFormat == null ? (class$org$biojava$bio$taxa$EbiFormat = EbiFormat.class$("org.biojava.bio.taxa.EbiFormat")) : class$org$biojava$bio$taxa$EbiFormat) + ":NCBI_TAXON";
    private static EbiFormat INSTANCE = new EbiFormat();
    static /* synthetic */ Class class$org$biojava$bio$taxa$EbiFormat;

    public static final EbiFormat getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EbiFormat();
        }
        return INSTANCE;
    }

    public Taxon parse(TaxonFactory taxonFactory, String taxonString) throws ChangeVetoException, CircularReferenceException {
        String name = taxonString.trim();
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        Taxon taxon = taxonFactory.getRoot();
        StringTokenizer sTok = new StringTokenizer(name, ";");
        if (sTok.countTokens() == 1) {
            return taxonFactory.addChild(taxon, taxonFactory.createTaxon(name, null));
        }
        String tok = null;
        block0: while (sTok.hasMoreTokens()) {
            tok = sTok.nextToken().trim();
            Iterator i = taxon.getChildren().iterator();
            while (i.hasNext()) {
                Taxon child = (Taxon)i.next();
                if (!child.getScientificName().equals(tok)) continue;
                taxon = child;
                continue block0;
            }
            break block0;
        }
        while (sTok.hasMoreTokens()) {
            taxon = taxonFactory.addChild(taxon, taxonFactory.createTaxon(tok, null));
            tok = sTok.nextToken().trim();
        }
        return taxon;
    }

    public String serialize(Taxon taxon) {
        String name = null;
        do {
            String sci = taxon.getScientificName();
            name = name == null ? sci + "." : sci + "; " + name;
        } while ((taxon = taxon.getParent()) != null && taxon.getParent() != null);
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

