/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.directory.ProviderNotFoundException;
import org.biojava.directory.RegistryConfiguration;
import org.biojava.directory.RegistryException;
import org.biojava.directory.SequenceDBProvider;
import org.biojava.utils.Services;

public class Registry {
    private RegistryConfiguration regConfig = null;
    static /* synthetic */ Class class$org$biojava$directory$SequenceDBProvider;

    public Registry(RegistryConfiguration regConfig) {
        this.regConfig = regConfig;
    }

    public SequenceDBLite getDatabase(String dbName) throws RegistryException, BioException {
        Map dbConfig = null;
        String providerName = "";
        dbConfig = (Map)this.getRegistryConfiguration().getConfiguration().get(dbName);
        if (dbConfig == null) {
            throw new RegistryException("Couldn't find a configuration for database: " + dbName);
        }
        try {
            providerName = (String)dbConfig.get("protocol");
        }
        catch (Exception e) {
            throw new RegistryException("File for configuration cannot be found: " + e.toString());
        }
        return this.getProvider(providerName).getSequenceDB(dbConfig);
    }

    private SequenceDBProvider getProvider(String providerName) throws RegistryException {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Iterator implNames = Services.getImplementationNames(class$org$biojava$directory$SequenceDBProvider == null ? (class$org$biojava$directory$SequenceDBProvider = Registry.class$("org.biojava.directory.SequenceDBProvider")) : class$org$biojava$directory$SequenceDBProvider, loader).iterator();
            while (implNames.hasNext()) {
                String className = (String)implNames.next();
                Class<?> clazz = loader.loadClass(className);
                SequenceDBProvider seqDB = (SequenceDBProvider)clazz.newInstance();
                if (!seqDB.getName().equals(providerName)) continue;
                return seqDB;
            }
            throw new ProviderNotFoundException("No such provider exists: " + providerName);
        }
        catch (Exception e) {
            throw new RegistryException(e, "Error accessing SequenceDBProvider services");
        }
    }

    public RegistryConfiguration getRegistryConfiguration() {
        return this.regConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

